/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.gtfs.export.loader;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.entur.netex.NetexParser;
import org.entur.netex.gtfs.export.exception.NetexParsingException;
import org.entur.netex.gtfs.export.loader.NetexDatasetLoader;
import org.entur.netex.gtfs.export.repository.NetexDatasetRepository;

public class DefaultNetexDatasetLoader
implements NetexDatasetLoader {
    protected final NetexParser netexParser = new NetexParser();

    @Override
    public void load(InputStream timetableDataset, NetexDatasetRepository netexDatasetRepository) {
        try (ZipInputStream zipInputStream = new ZipInputStream(timetableDataset);){
            this.parseDataset(zipInputStream, netexDatasetRepository);
        }
        catch (IOException e) {
            throw new NetexParsingException("Error while parsing the NeTEx timetable dataset", e);
        }
    }

    protected void parseDataset(ZipInputStream zipInputStream, NetexDatasetRepository netexDatasetRepository) throws IOException {
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            byte[] allBytes = zipInputStream.readAllBytes();
            this.netexParser.parse((InputStream)new ByteArrayInputStream(allBytes), netexDatasetRepository.getIndex());
            zipEntry = zipInputStream.getNextEntry();
        }
    }
}

