/*
 *
 *  * Licensed under the EUPL, Version 1.2 or – as soon they will be approved by
 *  * the European Commission - subsequent versions of the EUPL (the "Licence");
 *  * You may not use this work except in compliance with the Licence.
 *  * You may obtain a copy of the Licence at:
 *  *
 *  *   https://joinup.ec.europa.eu/software/page/eupl
 *  *
 *  * Unless required by applicable law or agreed to in writing, software
 *  * distributed under the Licence is distributed on an "AS IS" basis,
 *  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  * See the Licence for the specific language governing permissions and
 *  * limitations under the Licence.
 *  *
 *
 */

package org.entur.netex.gtfs.export.producer;

import org.entur.netex.gtfs.export.model.GtfsShape;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.rutebanken.netex.model.JourneyPattern;
import org.rutebanken.netex.model.TimetabledPassingTime;

/**
 * Produce a GTFS Stop Time.
 */
public interface StopTimeProducer {
  int PICKUP_AND_DROP_OFF_TYPE_NOT_AVAILABLE = 1;
  int PICKUP_AND_DROP_OFF_TYPE_MUST_COORDINATE_WITH_DRIVER = 3;

  StopTime produce(
    TimetabledPassingTime timetabledPassingTime,
    JourneyPattern journeyPattern,
    Trip trip,
    GtfsShape gtfsShape,
    String currentHeadSign
  );
}
