/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.gtfs.export.serializer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.onebusaway.csv_entities.schema.EntitySchema;
import org.onebusaway.csv_entities.schema.FieldMapping;
import org.onebusaway.gtfs.serialization.GtfsWriter;

public class FilteredFieldsGtfsWriter
extends GtfsWriter {
    private final Map<Class<?>, Collection<String>> filteredFields;

    public FilteredFieldsGtfsWriter(Map<Class<?>, Collection<String>> filteredFields) {
        this.filteredFields = filteredFields;
    }

    public void excludeOptionalAndMissingFields(Class<?> entityType, Iterable<Object> entities) {
        super.excludeOptionalAndMissingFields(entityType, entities);
        this.filteredFields.forEach((key, value) -> {
            EntitySchema entitySchema = this.getEntitySchemaFactory().getSchema(key);
            FilteredFieldsGtfsWriter.removeFields(entitySchema, value);
        });
    }

    private static void removeFields(EntitySchema entitySchema, Collection<String> excludedFields) {
        Iterator iterator = entitySchema.getFields().iterator();
        while (iterator.hasNext()) {
            FieldMapping field = (FieldMapping)iterator.next();
            ArrayList fieldNames = new ArrayList();
            field.getCSVFieldNames(fieldNames);
            String fieldName = fieldNames.stream().findFirst().orElse("");
            if (!excludedFields.contains(fieldName)) continue;
            iterator.remove();
        }
    }
}

