/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.gtfs.export.producer;

import jakarta.xml.bind.JAXBElement;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.entur.netex.gtfs.export.exception.GtfsExportException;
import org.entur.netex.gtfs.export.model.GtfsShape;
import org.entur.netex.gtfs.export.producer.ShapeProducer;
import org.entur.netex.gtfs.export.repository.GtfsDatasetRepository;
import org.entur.netex.gtfs.export.repository.NetexDatasetRepository;
import org.entur.netex.gtfs.export.util.GeometryUtil;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.ShapePoint;
import org.rutebanken.netex.model.JourneyPattern;
import org.rutebanken.netex.model.LinkInLinkSequence_VersionedChildStructure;
import org.rutebanken.netex.model.LinkSequenceProjection;
import org.rutebanken.netex.model.Projections_RelStructure;
import org.rutebanken.netex.model.ServiceLink;
import org.rutebanken.netex.model.ServiceLinkInJourneyPattern_VersionedChildStructure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultShapeProducer
implements ShapeProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultShapeProducer.class);
    private final Agency agency;
    private final NetexDatasetRepository netexDatasetRepository;
    private final Comparator<? super LinkInLinkSequence_VersionedChildStructure> serviceLinksComparator;

    public DefaultShapeProducer(NetexDatasetRepository netexDatasetRepository, GtfsDatasetRepository gtfsDatasetRepository) {
        this.agency = gtfsDatasetRepository.getDefaultAgency();
        this.netexDatasetRepository = netexDatasetRepository;
        this.serviceLinksComparator = new ServiceLinksComparator();
    }

    @Override
    public GtfsShape produce(JourneyPattern journeyPattern) {
        int nbStopPoints = journeyPattern.getPointsInSequence().getPointInJourneyPatternOrStopPointInJourneyPatternOrTimingPointInJourneyPattern().size();
        if (journeyPattern.getLinksInSequence() == null || journeyPattern.getLinksInSequence().getServiceLinkInJourneyPatternOrTimingLinkInJourneyPattern() == null || journeyPattern.getLinksInSequence().getServiceLinkInJourneyPatternOrTimingLinkInJourneyPattern().size() != nbStopPoints - 1) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Skipping GTFS shape export for JourneyPattern {} with incomplete list of service links", (Object)journeyPattern.getId());
            }
            return null;
        }
        List serviceLinks = journeyPattern.getLinksInSequence().getServiceLinkInJourneyPatternOrTimingLinkInJourneyPattern();
        ArrayList<ShapePoint> shapePoints = new ArrayList<ShapePoint>();
        ArrayList<Double> travelledDistanceToStop = new ArrayList<Double>(nbStopPoints);
        travelledDistanceToStop.add(0.0);
        String shapeId = journeyPattern.getId();
        int sequence = 0;
        double distanceFromStart = 0.0;
        Coordinate previousPoint = null;
        serviceLinks.sort(this.serviceLinksComparator);
        for (LinkInLinkSequence_VersionedChildStructure link : serviceLinks) {
            ServiceLinkInJourneyPattern_VersionedChildStructure serviceLinkInJourneyPattern = (ServiceLinkInJourneyPattern_VersionedChildStructure)link;
            ServiceLink serviceLink = this.netexDatasetRepository.getServiceLinkById(serviceLinkInJourneyPattern.getServiceLinkRef().getRef());
            Projections_RelStructure projections = serviceLink.getProjections();
            if (projections == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Skipping GTFS shape export for JourneyPattern {} with service link {} without LineString", (Object)journeyPattern.getId(), (Object)serviceLink.getId());
                }
                return null;
            }
            for (JAXBElement jaxbElement : projections.getProjectionRefOrProjection()) {
                LinkSequenceProjection linkSequenceProjection = (LinkSequenceProjection)jaxbElement.getValue();
                LineString lineString = GeometryUtil.convertLineStringFromGmlToJts(linkSequenceProjection.getLineString());
                if (lineString == null) {
                    LOGGER.debug("Skipping GTFS shape export for JourneyPattern {} with service link {} with invalid LineString", (Object)journeyPattern.getId(), (Object)serviceLink.getId());
                    return null;
                }
                for (Coordinate currentPoint : lineString.getCoordinates()) {
                    if (currentPoint.equals(previousPoint)) continue;
                    distanceFromStart += GeometryUtil.distance(previousPoint, currentPoint);
                    ShapePoint shapePoint = new ShapePoint();
                    AgencyAndId agencyAndId = new AgencyAndId();
                    agencyAndId.setId(shapeId);
                    agencyAndId.setAgencyId(this.agency.getId());
                    shapePoint.setShapeId(agencyAndId);
                    shapePoint.setSequence(sequence);
                    shapePoint.setLon(currentPoint.getX());
                    shapePoint.setLat(currentPoint.getY());
                    shapePoint.setDistTraveled((double)Math.round(distanceFromStart));
                    shapePoints.add(shapePoint);
                    ++sequence;
                    previousPoint = currentPoint;
                }
            }
            travelledDistanceToStop.add(Double.valueOf(Math.round(distanceFromStart)));
        }
        return new GtfsShape(shapeId, shapePoints, travelledDistanceToStop);
    }

    private static class ServiceLinksComparator
    implements Comparator<LinkInLinkSequence_VersionedChildStructure> {
        private ServiceLinksComparator() {
        }

        @Override
        public int compare(LinkInLinkSequence_VersionedChildStructure o1, LinkInLinkSequence_VersionedChildStructure o2) {
            BigInteger order1 = o1.getOrder();
            if (order1 == null) {
                throw new GtfsExportException("Undefined order for service link" + o1.getId());
            }
            BigInteger order2 = o2.getOrder();
            if (order2 == null) {
                throw new GtfsExportException("Undefined order for service link " + o2.getId());
            }
            return order1.compareTo(order2);
        }
    }
}

