/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.gtfs.export.producer;

import java.time.DayOfWeek;
import java.util.Collection;
import org.entur.netex.gtfs.export.producer.ServiceCalendarProducer;
import org.entur.netex.gtfs.export.repository.GtfsDatasetRepository;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.calendar.ServiceDate;

public class DefaultServiceCalendarProducer
implements ServiceCalendarProducer {
    private final Agency agency;

    public DefaultServiceCalendarProducer(GtfsDatasetRepository gtfsDatasetRepository) {
        this.agency = gtfsDatasetRepository.getDefaultAgency();
    }

    @Override
    public ServiceCalendar produce(String serviceId, ServiceDate startDate, ServiceDate endDate, Collection<DayOfWeek> daysOfWeeks) {
        ServiceCalendar serviceCalendar = new ServiceCalendar();
        AgencyAndId agencyAndId = new AgencyAndId();
        agencyAndId.setId(serviceId);
        agencyAndId.setAgencyId(this.agency.getId());
        serviceCalendar.setServiceId(agencyAndId);
        serviceCalendar.setStartDate(startDate);
        serviceCalendar.setEndDate(endDate);
        serviceCalendar.setMonday(daysOfWeeks.contains(DayOfWeek.MONDAY) ? 1 : 0);
        serviceCalendar.setTuesday(daysOfWeeks.contains(DayOfWeek.TUESDAY) ? 1 : 0);
        serviceCalendar.setWednesday(daysOfWeeks.contains(DayOfWeek.WEDNESDAY) ? 1 : 0);
        serviceCalendar.setThursday(daysOfWeeks.contains(DayOfWeek.THURSDAY) ? 1 : 0);
        serviceCalendar.setFriday(daysOfWeeks.contains(DayOfWeek.FRIDAY) ? 1 : 0);
        serviceCalendar.setSaturday(daysOfWeeks.contains(DayOfWeek.SATURDAY) ? 1 : 0);
        serviceCalendar.setSunday(daysOfWeeks.contains(DayOfWeek.SUNDAY) ? 1 : 0);
        return serviceCalendar;
    }
}

