/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.gtfs.export.util;

import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.entur.netex.gtfs.export.model.GtfsRouteType;
import org.rutebanken.netex.model.AirSubmodeEnumeration;
import org.rutebanken.netex.model.AllVehicleModesOfTransportEnumeration;
import org.rutebanken.netex.model.BusSubmodeEnumeration;
import org.rutebanken.netex.model.CoachSubmodeEnumeration;
import org.rutebanken.netex.model.Line;
import org.rutebanken.netex.model.RailSubmodeEnumeration;
import org.rutebanken.netex.model.TramSubmodeEnumeration;
import org.rutebanken.netex.model.TransportSubmodeStructure;
import org.rutebanken.netex.model.VehicleModeEnumeration;
import org.rutebanken.netex.model.WaterSubmodeEnumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransportModeUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransportModeUtil.class);
    private static final Map<TransportModeAndSubMode, GtfsRouteType> ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE = new TreeMap<TransportModeAndSubMode, GtfsRouteType>();

    private TransportModeUtil() {
    }

    public static int getGtfsExtendedRouteType(Line line) {
        String transportMode = line.getTransportMode().value();
        String transportSubMode = TransportModeUtil.getSubMode(line.getTransportSubmode());
        return TransportModeUtil.getGtfsExtendedRouteType(transportMode, transportSubMode).getValue();
    }

    public static int getGtfsExtendedRouteType(VehicleModeEnumeration transportMode) {
        return TransportModeUtil.getGtfsExtendedRouteType(transportMode.value(), null).getValue();
    }

    private static GtfsRouteType getGtfsExtendedRouteType(String transportMode, String transportSubMode) {
        GtfsRouteType routeType = ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.get(new TransportModeAndSubMode(transportMode, transportSubMode));
        if (routeType == null) {
            LOGGER.debug("Unknown transport sub mode {}, falling back to route type for parent transport mode {}", (Object)transportSubMode, (Object)transportMode);
            routeType = ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.get(new TransportModeAndSubMode(transportMode, null));
        }
        if (routeType == null) {
            LOGGER.debug("Unknown transport mode {}, falling back to route type for miscellaneous services", (Object)transportMode);
            routeType = GtfsRouteType.MISCELLANEOUS_SERVICE;
        }
        return routeType;
    }

    private static String getSubMode(TransportSubmodeStructure subModeStructure) {
        if (subModeStructure == null) {
            return null;
        }
        if (subModeStructure.getAirSubmode() != null) {
            return subModeStructure.getAirSubmode().value();
        }
        if (subModeStructure.getBusSubmode() != null) {
            return subModeStructure.getBusSubmode().value();
        }
        if (subModeStructure.getCoachSubmode() != null) {
            return subModeStructure.getCoachSubmode().value();
        }
        if (subModeStructure.getFunicularSubmode() != null) {
            return subModeStructure.getFunicularSubmode().value();
        }
        if (subModeStructure.getMetroSubmode() != null) {
            return subModeStructure.getMetroSubmode().value();
        }
        if (subModeStructure.getRailSubmode() != null) {
            return subModeStructure.getRailSubmode().value();
        }
        if (subModeStructure.getTelecabinSubmode() != null) {
            return subModeStructure.getTelecabinSubmode().value();
        }
        if (subModeStructure.getTramSubmode() != null) {
            return subModeStructure.getTramSubmode().value();
        }
        if (subModeStructure.getSnowAndIceSubmode() != null) {
            return subModeStructure.getSnowAndIceSubmode().value();
        }
        if (subModeStructure.getWaterSubmode() != null) {
            return subModeStructure.getWaterSubmode().value();
        }
        return null;
    }

    public static void main(String[] args) {
        TransportModeUtil.printMappingTable();
    }

    private static void printMappingTable() {
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.forEach((key, value) -> System.out.println(" | " + key.transportMode + " | " + (key.transportSubMode == null ? "" : key.transportSubMode) + " | " + value.name() + " | " + value.getValue() + " | "));
    }

    static {
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.AIR.value(), null), GtfsRouteType.AIR_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.AIR.value(), AirSubmodeEnumeration.DOMESTIC_FLIGHT.value()), GtfsRouteType.DOMESTIC_AIR_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.AIR.value(), AirSubmodeEnumeration.HELICOPTER_SERVICE.value()), GtfsRouteType.HELICOPTER_AIR_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.AIR.value(), AirSubmodeEnumeration.INTERNATIONAL_FLIGHT.value()), GtfsRouteType.INTERNATIONAL_AIR_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.BUS.value(), null), GtfsRouteType.BUS_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.BUS.value(), BusSubmodeEnumeration.AIRPORT_LINK_BUS.value()), GtfsRouteType.BUS_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.BUS.value(), BusSubmodeEnumeration.EXPRESS_BUS.value()), GtfsRouteType.EXPRESS_BUS_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.BUS.value(), BusSubmodeEnumeration.LOCAL_BUS.value()), GtfsRouteType.LOCAL_BUS_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.BUS.value(), BusSubmodeEnumeration.NIGHT_BUS.value()), GtfsRouteType.NIGHT_BUS_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.BUS.value(), BusSubmodeEnumeration.RAIL_REPLACEMENT_BUS.value()), GtfsRouteType.RAIL_REPLACEMENT_BUS_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.BUS.value(), BusSubmodeEnumeration.REGIONAL_BUS.value()), GtfsRouteType.REGIONAL_BUS_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.BUS.value(), BusSubmodeEnumeration.SCHOOL_BUS.value()), GtfsRouteType.SCHOOL_BUS);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.BUS.value(), BusSubmodeEnumeration.SHUTTLE_BUS.value()), GtfsRouteType.SHUTTLE_BUS);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.BUS.value(), BusSubmodeEnumeration.SIGHTSEEING_BUS.value()), GtfsRouteType.SIGHTSEEING_BUS);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.COACH.value(), null), GtfsRouteType.COACH_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.COACH.value(), CoachSubmodeEnumeration.INTERNATIONAL_COACH.value()), GtfsRouteType.INTERNATIONAL_COACH_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.COACH.value(), CoachSubmodeEnumeration.NATIONAL_COACH.value()), GtfsRouteType.NATIONAL_COACH_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.COACH.value(), CoachSubmodeEnumeration.TOURIST_COACH.value()), GtfsRouteType.TOURIST_COACH_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(VehicleModeEnumeration.FERRY.value(), null), GtfsRouteType.FERRY_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.METRO.value(), null), GtfsRouteType.METRO_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.RAIL.value(), null), GtfsRouteType.RAILWAY_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.RAIL.value(), RailSubmodeEnumeration.INTERNATIONAL.value()), GtfsRouteType.LONG_DISTANCE_TRAINS);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.RAIL.value(), RailSubmodeEnumeration.LONG_DISTANCE.value()), GtfsRouteType.LONG_DISTANCE_TRAINS);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.RAIL.value(), RailSubmodeEnumeration.INTERREGIONAL_RAIL.value()), GtfsRouteType.INTER_REGIONAL_RAIL_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.RAIL.value(), RailSubmodeEnumeration.LOCAL.value()), GtfsRouteType.RAILWAY_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.RAIL.value(), RailSubmodeEnumeration.NIGHT_RAIL.value()), GtfsRouteType.SLEEPER_RAIL_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.RAIL.value(), RailSubmodeEnumeration.REGIONAL_RAIL.value()), GtfsRouteType.REGIONAL_RAIL_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.RAIL.value(), RailSubmodeEnumeration.TOURIST_RAILWAY.value()), GtfsRouteType.TOURIST_RAILWAY_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.RAIL.value(), RailSubmodeEnumeration.AIRPORT_LINK_RAIL.value()), GtfsRouteType.HIGH_SPEED_RAIL_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.TROLLEY_BUS.value(), null), GtfsRouteType.TROLLEYBUS_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.TRAM.value(), null), GtfsRouteType.TRAM_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.TRAM.value(), TramSubmodeEnumeration.LOCAL_TRAM.value()), GtfsRouteType.LOCAL_TRAM_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.TRAM.value(), TramSubmodeEnumeration.CITY_TRAM.value()), GtfsRouteType.CITY_TRAM_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.WATER.value(), null), GtfsRouteType.WATER_TRANSPORT_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.WATER.value(), WaterSubmodeEnumeration.HIGH_SPEED_PASSENGER_SERVICE.value()), GtfsRouteType.PASSENGER_HIGH_SPEED_FERRY_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.WATER.value(), WaterSubmodeEnumeration.HIGH_SPEED_VEHICLE_SERVICE.value()), GtfsRouteType.CAR_HIGH_SPEED_FERRY_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.WATER.value(), WaterSubmodeEnumeration.INTERNATIONAL_CAR_FERRY.value()), GtfsRouteType.INTERNATIONAL_CAR_FERRY_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.WATER.value(), WaterSubmodeEnumeration.INTERNATIONAL_PASSENGER_FERRY.value()), GtfsRouteType.INTERNATIONAL_PASSENGER_FERRY_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.WATER.value(), WaterSubmodeEnumeration.LOCAL_CAR_FERRY.value()), GtfsRouteType.LOCAL_CAR_FERRY_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.WATER.value(), WaterSubmodeEnumeration.LOCAL_PASSENGER_FERRY.value()), GtfsRouteType.LOCAL_PASSENGER_FERRY_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.WATER.value(), WaterSubmodeEnumeration.NATIONAL_CAR_FERRY.value()), GtfsRouteType.NATIONAL_CAR_FERRY_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.WATER.value(), WaterSubmodeEnumeration.SIGHTSEEING_SERVICE.value()), GtfsRouteType.SIGHTSEEING_BOAT_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.CABLEWAY.value(), null), GtfsRouteType.TELECABIN_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(VehicleModeEnumeration.LIFT.value(), null), GtfsRouteType.TELECABIN_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.FUNICULAR.value(), null), GtfsRouteType.FUNICULAR_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(AllVehicleModesOfTransportEnumeration.TAXI.value(), null), GtfsRouteType.TAXI_SERVICE);
        ROUTE_TYPE_FOR_TRANSPORT_MODE_AND_SUB_MODE.put(new TransportModeAndSubMode(VehicleModeEnumeration.OTHER.value(), null), GtfsRouteType.MISCELLANEOUS_SERVICE);
    }

    private record TransportModeAndSubMode(String transportMode, String transportSubMode) implements Comparable<TransportModeAndSubMode>
    {
        @Override
        public int compareTo(TransportModeAndSubMode o) {
            if (this.transportMode.equals(o.transportMode)) {
                return StringUtils.compare((String)this.transportSubMode, (String)o.transportSubMode);
            }
            return this.transportMode.compareTo(o.transportMode);
        }
    }
}

