/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.gtfs.export.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.opengis.gml._3.DirectPositionListType;
import net.opengis.gml._3.DirectPositionType;
import net.opengis.gml._3.LineStringType;
import net.opengis.gml._3.PointPropertyType;
import org.apache.commons.lang3.StringUtils;
import org.entur.netex.gtfs.export.exception.GtfsExportException;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;
import org.locationtech.jts.geom.impl.PackedCoordinateSequenceFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GeometryUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeometryUtil.class);
    private static final String DEFAULT_SRID_NAME = "WGS84";
    private static final String DEFAULT_SRID_AS_STRING = "4326";
    private static final int DEFAULT_SRID_AS_INT = 4326;
    private static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory(new PrecisionModel(), 4326);

    private GeometryUtil() {
    }

    public static double distance(Coordinate from, Coordinate to) {
        if (from == null) {
            return 0.0;
        }
        try {
            return JTS.orthodromicDistance((Coordinate)from, (Coordinate)to, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        }
        catch (TransformException e) {
            throw new GtfsExportException(e);
        }
    }

    public static LineString convertLineStringFromGmlToJts(LineStringType gmlLineString) {
        List<Double> coordinates = GeometryUtil.extractCoordinates(gmlLineString);
        if (coordinates.isEmpty()) {
            return null;
        }
        CoordinateSequence coordinateSequence = new PackedCoordinateSequenceFactory().create(coordinates.stream().mapToDouble(Double::doubleValue).toArray(), 2);
        LineString jts = new LineString(coordinateSequence, GEOMETRY_FACTORY);
        jts.apply((CoordinateSequenceFilter)new SwapPackedCoordinateSequenceFilter());
        GeometryUtil.assignSRID(gmlLineString, jts);
        return jts;
    }

    private static List<Double> extractCoordinates(LineStringType gmlLineString) {
        ArrayList coordinates;
        DirectPositionListType posList = gmlLineString.getPosList();
        if (posList != null && !posList.getValue().isEmpty()) {
            coordinates = posList.getValue();
        } else if (gmlLineString.getPosOrPointProperty() != null && !gmlLineString.getPosOrPointProperty().isEmpty()) {
            coordinates = new ArrayList();
            for (Object o : gmlLineString.getPosOrPointProperty()) {
                if (o instanceof DirectPositionType) {
                    DirectPositionType directPositionType = (DirectPositionType)o;
                    coordinates.addAll(directPositionType.getValue());
                    continue;
                }
                if (o instanceof PointPropertyType) {
                    LOGGER.warn("Unsupported PointPropertyType for gmlString {}", (Object)gmlLineString.getId());
                    return Collections.emptyList();
                }
                LOGGER.warn("Unknown class ({}) for PosOrPointProperty for gmlString {}", o.getClass(), (Object)gmlLineString.getId());
                return Collections.emptyList();
            }
            if (coordinates.isEmpty()) {
                LOGGER.warn("LineStringType without coordinates for gmlString {}", (Object)gmlLineString.getId());
            }
        } else {
            LOGGER.warn("LineStringType without posList or PosOrPointProperty for gmlString {}", (Object)gmlLineString.getId());
            return Collections.emptyList();
        }
        return coordinates;
    }

    private static void assignSRID(LineStringType gml, LineString jts) {
        String srsName = gml.getSrsName();
        if (!(StringUtils.isEmpty((CharSequence)srsName) || DEFAULT_SRID_NAME.equals(srsName) || DEFAULT_SRID_AS_STRING.equals(srsName))) {
            LOGGER.warn("The LineString {} is not based on the WGS84 Spatial Reference System. SRID in use: {}", (Object)gml.getId(), (Object)srsName);
            try {
                jts.setSRID(Integer.parseInt(srsName));
            }
            catch (NumberFormatException nfe) {
                LOGGER.warn("Ignoring SRID on linestring {} for illegal value: {}", (Object)gml.getId(), (Object)srsName);
            }
        }
    }

    private static final class SwapPackedCoordinateSequenceFilter
    implements CoordinateSequenceFilter {
        private SwapPackedCoordinateSequenceFilter() {
        }

        public void filter(CoordinateSequence coordinateSequence, int i) {
            PackedCoordinateSequence packedCoordinateSequence = (PackedCoordinateSequence)coordinateSequence;
            double originalCoordinateX = packedCoordinateSequence.getX(i);
            packedCoordinateSequence.setX(i, coordinateSequence.getY(i));
            packedCoordinateSequence.setY(i, originalCoordinateX);
        }

        public boolean isDone() {
            return false;
        }

        public boolean isGeometryChanged() {
            return true;
        }
    }
}

