/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.gtfs.export.repository;

import java.io.InputStream;
import org.entur.netex.gtfs.export.repository.GtfsDatasetRepository;
import org.entur.netex.gtfs.export.repository.GtfsDatasetRepositoryException;
import org.entur.netex.gtfs.export.serializer.DefaultGtfsSerializer;
import org.entur.netex.gtfs.export.serializer.GtfsSerializer;
import org.onebusaway.gtfs.impl.GtfsRelationalDaoImpl;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsDao;
import org.onebusaway.gtfs.services.GtfsMutableDao;

public class DefaultGtfsRepository
implements GtfsDatasetRepository {
    private static final String DEFAULT_AGENCY_ID = "DEFAULT";
    private final GtfsMutableDao gtfsDao = new GtfsRelationalDaoImpl();
    private final GtfsSerializer gtfsSerializer = new DefaultGtfsSerializer();
    private final Agency defaultAgency = DefaultGtfsRepository.createDefaultAgency();

    @Override
    public Agency getAgencyById(String agencyId) {
        Agency agency = this.gtfsDao.getAgencyForId(agencyId);
        if (agency == null) {
            throw new GtfsDatasetRepositoryException("Agency not found: " + agencyId);
        }
        return agency;
    }

    @Override
    public Trip getTripById(String tripId) {
        AgencyAndId agencyAndId = new AgencyAndId();
        agencyAndId.setId(tripId);
        agencyAndId.setAgencyId(this.defaultAgency.getId());
        Trip tripForId = this.gtfsDao.getTripForId(agencyAndId);
        if (tripForId == null) {
            throw new GtfsDatasetRepositoryException("GTFS Trip not found: " + tripId);
        }
        return tripForId;
    }

    @Override
    public Stop getStopById(String stopId) {
        AgencyAndId agencyAndId = new AgencyAndId();
        agencyAndId.setId(stopId);
        agencyAndId.setAgencyId(this.defaultAgency.getId());
        Stop stop = this.gtfsDao.getStopForId(agencyAndId);
        if (stop == null) {
            throw new GtfsDatasetRepositoryException("Stop not found: " + stopId);
        }
        return stop;
    }

    @Override
    public void saveEntity(Object entity) {
        this.gtfsDao.saveEntity(entity);
    }

    @Override
    public InputStream writeGtfs() {
        return this.gtfsSerializer.writeGtfs((GtfsDao)this.gtfsDao);
    }

    @Override
    public Agency getDefaultAgency() {
        return this.defaultAgency;
    }

    private static Agency createDefaultAgency() {
        Agency defaultAgency = new Agency();
        defaultAgency.setId(DEFAULT_AGENCY_ID);
        return defaultAgency;
    }
}

