/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.gtfs.export.producer;

import org.entur.netex.gtfs.export.exception.GtfsExportException;
import org.entur.netex.gtfs.export.producer.StopProducer;
import org.entur.netex.gtfs.export.repository.GtfsDatasetRepository;
import org.entur.netex.gtfs.export.stop.StopAreaRepository;
import org.entur.netex.gtfs.export.util.TransportModeUtil;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Stop;
import org.rutebanken.netex.model.MultilingualString;
import org.rutebanken.netex.model.Quay;
import org.rutebanken.netex.model.StopPlace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStopProducer
implements StopProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultStopProducer.class);
    private final Agency defaultAgency;
    private final StopAreaRepository stopAreaRepository;

    public DefaultStopProducer(StopAreaRepository stopAreaRepository, GtfsDatasetRepository gtfsDatasetRepository) {
        this.defaultAgency = gtfsDatasetRepository.getDefaultAgency();
        this.stopAreaRepository = stopAreaRepository;
    }

    @Override
    public Stop produceStopFromStopPlace(StopPlace stopPlace) {
        Stop stop = new Stop();
        AgencyAndId agencyAndId = new AgencyAndId();
        agencyAndId.setAgencyId(this.defaultAgency.getId());
        agencyAndId.setId(stopPlace.getId());
        stop.setId(agencyAndId);
        stop.setLocationType(1);
        if (DefaultStopProducer.isBlankMultilingualString(stopPlace.getName())) {
            throw new GtfsExportException("The stop place " + stopPlace.getId() + " does not have a name");
        }
        stop.setName(stopPlace.getName().getValue());
        if (stopPlace.getDescription() != null && stopPlace.getDescription().getValue() != null && !stopPlace.getDescription().getValue().equals(stop.getName())) {
            stop.setDesc(stopPlace.getDescription().getValue());
        }
        if (stopPlace.getPrivateCode() != null) {
            stop.setPlatformCode(stopPlace.getPrivateCode().getValue());
        }
        stop.setLon(stopPlace.getCentroid().getLocation().getLongitude().doubleValue());
        stop.setLat(stopPlace.getCentroid().getLocation().getLatitude().doubleValue());
        if (stopPlace.getTransportMode() != null) {
            stop.setVehicleType(TransportModeUtil.getGtfsExtendedRouteType(stopPlace.getTransportMode()));
        } else {
            LOGGER.info("Missing transport mode for stop place {}.", (Object)stop.getId());
        }
        if (stopPlace.getAccessibilityAssessment() != null) {
            String wheelchairAccess = stopPlace.getAccessibilityAssessment().getLimitations().getAccessibilityLimitation().getWheelchairAccess().value();
            if ("true".equals(wheelchairAccess)) {
                stop.setWheelchairBoarding(1);
            } else if ("false".equals(wheelchairAccess)) {
                stop.setWheelchairBoarding(2);
            }
        }
        return stop;
    }

    @Override
    public Stop produceStopFromQuay(Quay quay) {
        Stop stop = new Stop();
        AgencyAndId agencyAndId = new AgencyAndId();
        agencyAndId.setAgencyId(this.defaultAgency.getId());
        agencyAndId.setId(quay.getId());
        stop.setId(agencyAndId);
        stop.setLocationType(0);
        StopPlace parentStopPlace = this.stopAreaRepository.getStopPlaceByQuayId(quay.getId());
        stop.setParentStation(parentStopPlace.getId());
        if (DefaultStopProducer.isBlankMultilingualString(parentStopPlace.getName())) {
            throw new GtfsExportException("The parent stop place " + parentStopPlace.getId() + " of quay " + quay.getId() + " does not have a name");
        }
        stop.setName(parentStopPlace.getName().getValue());
        if (quay.getDescription() != null && quay.getDescription().getValue() != null && !quay.getDescription().getValue().equals(stop.getName())) {
            stop.setDesc(quay.getDescription().getValue());
        }
        if (quay.getPrivateCode() != null) {
            stop.setPlatformCode(quay.getPrivateCode().getValue());
        }
        stop.setLon(quay.getCentroid().getLocation().getLongitude().doubleValue());
        stop.setLat(quay.getCentroid().getLocation().getLatitude().doubleValue());
        if (parentStopPlace.getTransportMode() != null) {
            stop.setVehicleType(TransportModeUtil.getGtfsExtendedRouteType(parentStopPlace.getTransportMode()));
        } else {
            LOGGER.info("Missing transport mode for quay {}", (Object)stop.getId());
        }
        if (quay.getAccessibilityAssessment() != null) {
            String wheelchairAccess = quay.getAccessibilityAssessment().getLimitations().getAccessibilityLimitation().getWheelchairAccess().value();
            if ("true".equals(wheelchairAccess)) {
                stop.setWheelchairBoarding(1);
            } else if ("false".equals(wheelchairAccess)) {
                stop.setWheelchairBoarding(2);
            }
        }
        return stop;
    }

    private static boolean isBlankMultilingualString(MultilingualString multilingualString) {
        return multilingualString == null || multilingualString.getValue() == null || multilingualString.getValue().isBlank();
    }
}

