/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.gtfs.export;

import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.entur.netex.gtfs.export.GtfsExporter;
import org.entur.netex.gtfs.export.loader.DefaultNetexDatasetLoader;
import org.entur.netex.gtfs.export.loader.NetexDatasetLoader;
import org.entur.netex.gtfs.export.model.GtfsService;
import org.entur.netex.gtfs.export.model.GtfsShape;
import org.entur.netex.gtfs.export.model.ServiceCalendarPeriod;
import org.entur.netex.gtfs.export.producer.AgencyProducer;
import org.entur.netex.gtfs.export.producer.DefaultAgencyProducer;
import org.entur.netex.gtfs.export.producer.DefaultGtfsServiceRepository;
import org.entur.netex.gtfs.export.producer.DefaultRouteProducer;
import org.entur.netex.gtfs.export.producer.DefaultServiceCalendarDateProducer;
import org.entur.netex.gtfs.export.producer.DefaultServiceCalendarProducer;
import org.entur.netex.gtfs.export.producer.DefaultShapeProducer;
import org.entur.netex.gtfs.export.producer.DefaultStopProducer;
import org.entur.netex.gtfs.export.producer.DefaultStopTimeProducer;
import org.entur.netex.gtfs.export.producer.DefaultTransferProducer;
import org.entur.netex.gtfs.export.producer.DefaultTripProducer;
import org.entur.netex.gtfs.export.producer.FeedInfoProducer;
import org.entur.netex.gtfs.export.producer.GtfsServiceRepository;
import org.entur.netex.gtfs.export.producer.RouteProducer;
import org.entur.netex.gtfs.export.producer.ServiceCalendarDateProducer;
import org.entur.netex.gtfs.export.producer.ServiceCalendarProducer;
import org.entur.netex.gtfs.export.producer.ShapeProducer;
import org.entur.netex.gtfs.export.producer.StopProducer;
import org.entur.netex.gtfs.export.producer.StopTimeProducer;
import org.entur.netex.gtfs.export.producer.TransferProducer;
import org.entur.netex.gtfs.export.producer.TripProducer;
import org.entur.netex.gtfs.export.repository.DefaultGtfsRepository;
import org.entur.netex.gtfs.export.repository.DefaultNetexDatasetRepository;
import org.entur.netex.gtfs.export.repository.GtfsDatasetRepository;
import org.entur.netex.gtfs.export.repository.NetexDatasetRepository;
import org.entur.netex.gtfs.export.stop.StopAreaRepository;
import org.entur.netex.gtfs.export.util.DestinationDisplayUtil;
import org.entur.netex.gtfs.export.util.ServiceAlterationChecker;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.FeedInfo;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.rutebanken.netex.model.DestinationDisplay;
import org.rutebanken.netex.model.EntityStructure;
import org.rutebanken.netex.model.JourneyPattern;
import org.rutebanken.netex.model.JourneyPatternRefStructure;
import org.rutebanken.netex.model.Line;
import org.rutebanken.netex.model.ScheduledStopPointRefStructure;
import org.rutebanken.netex.model.ServiceJourney;
import org.rutebanken.netex.model.ServiceJourneyInterchange;
import org.rutebanken.netex.model.StopPointInJourneyPattern;
import org.rutebanken.netex.model.TimetabledPassingTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGtfsExporter
implements GtfsExporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultGtfsExporter.class);
    private final String codespace;
    private final NetexDatasetRepository netexDatasetRepository;
    private final GtfsDatasetRepository gtfsDatasetRepository;
    private final GtfsServiceRepository gtfsServiceRepository;
    private final StopAreaRepository stopAreaRepository;
    private TransferProducer transferProducer;
    private AgencyProducer agencyProducer;
    private FeedInfoProducer feedInfoProducer;
    private RouteProducer routeProducer;
    private ShapeProducer shapeProducer;
    private TripProducer tripProducer;
    private StopTimeProducer stopTimeProducer;
    private ServiceCalendarDateProducer serviceCalendarDateProducer;
    private ServiceCalendarProducer serviceCalendarProducer;
    private StopProducer stopProducer;
    private NetexDatasetLoader netexDatasetLoader;
    private final ServiceAlterationChecker serviceAlterationChecker;

    public DefaultGtfsExporter(String codespace, StopAreaRepository stopAreaRepository) {
        this(codespace, stopAreaRepository, false);
    }

    public DefaultGtfsExporter(StopAreaRepository stopAreaRepository) {
        this(null, stopAreaRepository);
    }

    public DefaultGtfsExporter(String codespace, StopAreaRepository stopAreaRepository, boolean generateStaySeatedTransfer) {
        this.codespace = codespace;
        this.netexDatasetLoader = new DefaultNetexDatasetLoader();
        this.stopAreaRepository = stopAreaRepository;
        this.gtfsDatasetRepository = new DefaultGtfsRepository();
        this.netexDatasetRepository = new DefaultNetexDatasetRepository();
        this.gtfsServiceRepository = new DefaultGtfsServiceRepository(codespace, this.netexDatasetRepository);
        this.serviceAlterationChecker = new ServiceAlterationChecker(this.netexDatasetRepository);
        this.transferProducer = new DefaultTransferProducer(this.netexDatasetRepository, this.gtfsDatasetRepository, generateStaySeatedTransfer);
        this.agencyProducer = new DefaultAgencyProducer(this.netexDatasetRepository);
        this.routeProducer = new DefaultRouteProducer(this.netexDatasetRepository, this.gtfsDatasetRepository);
        this.shapeProducer = new DefaultShapeProducer(this.netexDatasetRepository, this.gtfsDatasetRepository);
        this.tripProducer = new DefaultTripProducer(this.netexDatasetRepository, this.gtfsDatasetRepository, this.gtfsServiceRepository);
        this.stopTimeProducer = new DefaultStopTimeProducer(this.netexDatasetRepository, this.gtfsDatasetRepository);
        this.serviceCalendarDateProducer = new DefaultServiceCalendarDateProducer(this.gtfsDatasetRepository);
        this.serviceCalendarProducer = new DefaultServiceCalendarProducer(this.gtfsDatasetRepository);
        this.stopProducer = new DefaultStopProducer(stopAreaRepository, this.gtfsDatasetRepository);
    }

    @Override
    public InputStream convertTimetablesToGtfs(InputStream netexTimetableDataset) {
        if (this.codespace == null) {
            throw new IllegalStateException("Missing required codespace for timetable data export");
        }
        this.loadNetex(netexTimetableDataset);
        this.convertNetexToGtfs();
        return this.gtfsDatasetRepository.writeGtfs();
    }

    @Override
    public InputStream convertStopsToGtfs() {
        this.convertStops(false);
        this.addFeedInfo();
        return this.gtfsDatasetRepository.writeGtfs();
    }

    private void loadNetex(InputStream netexTimetableDataset) {
        LOGGER.info("Importing NeTEx Timetable dataset");
        this.netexDatasetLoader.load(netexTimetableDataset, this.netexDatasetRepository);
        LOGGER.info("Imported NeTEx Timetable dataset");
    }

    private void convertNetexToGtfs() {
        LOGGER.info("Converting NeTEx to GTFS");
        this.netexDatasetRepository.getLines().stream().map(this.netexDatasetRepository::getAuthorityIdForLine).distinct().map(this.netexDatasetRepository::getAuthorityById).map(this.agencyProducer::produce).forEach(this.gtfsDatasetRepository::saveEntity);
        this.convertStops(true);
        this.convertRoutes();
        this.convertServices();
        this.convertTransfers();
        this.addFeedInfo();
    }

    protected void addFeedInfo() {
        FeedInfo feedInfo;
        if (this.feedInfoProducer != null && (feedInfo = this.feedInfoProducer.produceFeedInfo()) != null) {
            this.gtfsDatasetRepository.saveEntity(feedInfo);
        }
    }

    protected void convertRoutes() {
        for (Line netexLine : this.netexDatasetRepository.getLines()) {
            Route gtfsRoute = this.routeProducer.produce(netexLine);
            this.gtfsDatasetRepository.saveEntity(gtfsRoute);
            for (org.rutebanken.netex.model.Route netexRoute : this.netexDatasetRepository.getRoutesByLine(netexLine)) {
                for (JourneyPattern journeyPattern : this.netexDatasetRepository.getJourneyPatternsByRoute(netexRoute)) {
                    GtfsShape gtfsShape = this.shapeProducer.produce(journeyPattern);
                    AgencyAndId shapeId = null;
                    if (gtfsShape != null && !gtfsShape.getShapePoints().isEmpty()) {
                        gtfsShape.getShapePoints().forEach(this.gtfsDatasetRepository::saveEntity);
                        shapeId = new AgencyAndId();
                        shapeId.setAgencyId(this.gtfsDatasetRepository.getDefaultAgency().getId());
                        shapeId.setId(gtfsShape.getId());
                    }
                    DestinationDisplay initialDestinationDisplay = DestinationDisplayUtil.getInitialDestinationDisplay(journeyPattern, this.netexDatasetRepository);
                    for (ServiceJourney serviceJourney : this.netexDatasetRepository.getServiceJourneysByJourneyPattern(journeyPattern)) {
                        Trip trip = this.tripProducer.produce(serviceJourney, netexRoute, gtfsRoute, shapeId, initialDestinationDisplay);
                        if (trip == null) continue;
                        this.gtfsDatasetRepository.saveEntity(trip);
                        String currentHeadSign = null;
                        for (TimetabledPassingTime timetabledPassingTime : serviceJourney.getPassingTimes().getTimetabledPassingTime()) {
                            StopTime stopTime = this.stopTimeProducer.produce(timetabledPassingTime, journeyPattern, trip, gtfsShape, currentHeadSign);
                            this.gtfsDatasetRepository.saveEntity(stopTime);
                            currentHeadSign = stopTime.getStopHeadsign();
                        }
                    }
                }
            }
        }
    }

    protected void convertServices() {
        for (GtfsService gtfsService : this.gtfsServiceRepository.getAllServices()) {
            ServiceCalendarPeriod serviceCalendarPeriod = gtfsService.getServiceCalendarPeriod();
            if (serviceCalendarPeriod != null) {
                ServiceCalendar serviceCalendar = this.serviceCalendarProducer.produce(gtfsService.getId(), serviceCalendarPeriod.getStartDate(), serviceCalendarPeriod.getEndDate(), serviceCalendarPeriod.getDaysOfWeek());
                this.gtfsDatasetRepository.saveEntity(serviceCalendar);
            }
            for (LocalDateTime includedDate : gtfsService.getIncludedDates()) {
                this.gtfsDatasetRepository.saveEntity(this.serviceCalendarDateProducer.produce(gtfsService.getId(), includedDate, true));
            }
            for (LocalDateTime excludedDate : gtfsService.getExcludedDates()) {
                this.gtfsDatasetRepository.saveEntity(this.serviceCalendarDateProducer.produce(gtfsService.getId(), excludedDate, false));
            }
        }
    }

    protected void convertTransfers() {
        this.netexDatasetRepository.getServiceJourneyInterchanges().stream().filter(this::isValidServiceJourneyInterchange).map(this.transferProducer::produce).forEach(this.gtfsDatasetRepository::saveEntity);
    }

    protected void convertStops(boolean exportOnlyUsedStops) {
        Set allQuaysId = exportOnlyUsedStops ? this.netexDatasetRepository.getServiceJourneys().stream().filter(Predicate.not(this.serviceAlterationChecker::isReplacedOrCancelled)).map(serviceJourney -> ((JourneyPatternRefStructure)serviceJourney.getJourneyPatternRef().getValue()).getRef()).distinct().map(this.netexDatasetRepository::getJourneyPatternById).map(journeyPattern -> journeyPattern.getPointsInSequence().getPointInJourneyPatternOrStopPointInJourneyPatternOrTimingPointInJourneyPattern()).flatMap(Collection::stream).map(stopPointInJourneyPattern -> ((ScheduledStopPointRefStructure)((StopPointInJourneyPattern)stopPointInJourneyPattern).getScheduledStopPointRef().getValue()).getRef()).distinct().filter(Predicate.not(this::isFlexibleScheduledStopPoint)).map(this.netexDatasetRepository::getQuayIdByScheduledStopPointId).collect(Collectors.toSet()) : this.stopAreaRepository.getAllQuays().stream().map(EntityStructure::getId).collect(Collectors.toSet());
        allQuaysId.stream().map(this.stopAreaRepository::getQuayById).map(this.stopProducer::produceStopFromQuay).forEach(this.gtfsDatasetRepository::saveEntity);
        allQuaysId.stream().map(this.stopAreaRepository::getStopPlaceByQuayId).distinct().map(this.stopProducer::produceStopFromStopPlace).forEach(this.gtfsDatasetRepository::saveEntity);
    }

    private boolean isValidServiceJourneyInterchange(ServiceJourneyInterchange serviceJourneyInterchange) {
        boolean isActive;
        boolean hasValidReferences;
        ServiceJourney fromServiceJourney = this.netexDatasetRepository.getServiceJourneyById(serviceJourneyInterchange.getFromJourneyRef().getRef());
        ServiceJourney toServiceJourney = this.netexDatasetRepository.getServiceJourneyById(serviceJourneyInterchange.getToJourneyRef().getRef());
        boolean bl = hasValidReferences = fromServiceJourney != null && toServiceJourney != null;
        if (!hasValidReferences) {
            LOGGER.warn("Filtering ServiceJourneyInterchange {} with invalid references.", (Object)serviceJourneyInterchange.getId());
            return false;
        }
        boolean bl2 = isActive = !this.serviceAlterationChecker.isReplacedOrCancelled(fromServiceJourney) && !this.serviceAlterationChecker.isReplacedOrCancelled(toServiceJourney);
        if (!isActive) {
            LOGGER.info("Filtering cancelled or replaced ServiceJourneyInterchange {}", (Object)serviceJourneyInterchange.getId());
        }
        return isActive;
    }

    private boolean isFlexibleScheduledStopPoint(String scheduledStopPointId) {
        String flexibleStopPlaceId = this.netexDatasetRepository.getFlexibleStopPlaceIdByScheduledStopPointId(scheduledStopPointId);
        if (flexibleStopPlaceId != null) {
            LOGGER.info("Ignoring scheduled stop point {} referring to flexible stop place {}", (Object)scheduledStopPointId, (Object)flexibleStopPlaceId);
            return true;
        }
        return false;
    }

    protected final String getCodespace() {
        return this.codespace;
    }

    protected final NetexDatasetRepository getNetexDatasetRepository() {
        return this.netexDatasetRepository;
    }

    protected final GtfsDatasetRepository getGtfsDatasetRepository() {
        return this.gtfsDatasetRepository;
    }

    protected final GtfsServiceRepository getGtfsServiceRepository() {
        return this.gtfsServiceRepository;
    }

    protected final StopAreaRepository getStopAreaRepository() {
        return this.stopAreaRepository;
    }

    protected final void setNetexDatasetLoader(NetexDatasetLoader netexDatasetLoader) {
        this.netexDatasetLoader = netexDatasetLoader;
    }

    protected final void setTransferProducer(TransferProducer transferProducer) {
        this.transferProducer = transferProducer;
    }

    protected final void setAgencyProducer(AgencyProducer agencyProducer) {
        this.agencyProducer = agencyProducer;
    }

    protected final void setFeedInfoProducer(FeedInfoProducer feedInfoProducer) {
        this.feedInfoProducer = feedInfoProducer;
    }

    protected final void setRouteProducer(RouteProducer routeProducer) {
        this.routeProducer = routeProducer;
    }

    protected final void setShapeProducer(ShapeProducer shapeProducer) {
        this.shapeProducer = shapeProducer;
    }

    protected final void setTripProducer(TripProducer tripProducer) {
        this.tripProducer = tripProducer;
    }

    protected final void setStopTimeProducer(StopTimeProducer stopTimeProducer) {
        this.stopTimeProducer = stopTimeProducer;
    }

    protected final void setServiceCalendarDateProducer(ServiceCalendarDateProducer serviceCalendarDateProducer) {
        this.serviceCalendarDateProducer = serviceCalendarDateProducer;
    }

    protected final void setServiceCalendarProducer(ServiceCalendarProducer serviceCalendarProducer) {
        this.serviceCalendarProducer = serviceCalendarProducer;
    }

    protected final void setStopProducer(StopProducer stopProducer) {
        this.stopProducer = stopProducer;
    }
}

