/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.junit5.impl;

import java.lang.annotation.Annotation;
import org.entur.jwt.junit5.AuthorizationServer;
import org.entur.jwt.junit5.AuthorizationServerEncoder;

public class AuthorizationServerImplementation {
    private AuthorizationServer authorizationServer;
    private Annotation annotation;
    private AuthorizationServerEncoder authorizationServerEncoder;

    public AuthorizationServerImplementation(AuthorizationServer server, Annotation source) {
        this.authorizationServer = server;
        this.annotation = source;
        this.authorizationServerEncoder = this.getAuthorizationServerEncoder(server);
    }

    protected AuthorizationServerEncoder getAuthorizationServerEncoder(AuthorizationServer token) {
        Class<? extends AuthorizationServerEncoder> encoder = token.encoder();
        try {
            return encoder.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to initialize encoder type " + encoder.getClass().getName(), e);
        }
    }

    public AuthorizationServerEncoder getEncoder() {
        return this.authorizationServerEncoder;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public AuthorizationServer getAuthorizationServer() {
        return this.authorizationServer;
    }

    public String getJsonWebKeys() {
        return this.authorizationServerEncoder.getJsonWebKeys(this.annotation);
    }

    public void setEncoder(AuthorizationServerEncoder encoder) {
        this.authorizationServerEncoder = encoder;
    }

    public String getId() {
        return this.authorizationServer.value();
    }
}

