/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.junit5.extention;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.entur.jwt.junit5.AccessToken;
import org.entur.jwt.junit5.AuthorizationServer;
import org.entur.jwt.junit5.configuration.enrich.ResourceServerConfigurationEnricher;
import org.entur.jwt.junit5.configuration.enrich.ResourceServerConfigurationEnricherServiceLoader;
import org.entur.jwt.junit5.configuration.resolve.ResourceServerConfiguration;
import org.entur.jwt.junit5.configuration.resolve.ResourceServerConfigurationResolver;
import org.entur.jwt.junit5.configuration.resolve.ResourceServerConfigurationResolverServiceLoader;
import org.entur.jwt.junit5.impl.AccessTokenImplementationFactory;
import org.entur.jwt.junit5.impl.AuthorizationServerImplementation;
import org.entur.jwt.junit5.impl.AuthorizationServerImplementationFactory;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;

public class AuthorizationServerExtension
implements ParameterResolver,
BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
ResourceServerConfiguration {
    public static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{AuthorizationServerExtension.class});
    protected List<AuthorizationServerImplementation> servers = new ArrayList<AuthorizationServerImplementation>();
    protected List<ResourceServerConfigurationEnricher> enrichers = new ArrayList<ResourceServerConfigurationEnricher>();
    protected List<ResourceServerConfigurationResolver> resolvers = new ArrayList<ResourceServerConfigurationResolver>();
    protected List<ResourceServerConfiguration> configurations = new ArrayList<ResourceServerConfiguration>();

    public static ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getRoot().getStore(NAMESPACE);
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        Class testClass = context.getRequiredTestClass();
        AuthorizationServerImplementationFactory factory = new AuthorizationServerImplementationFactory();
        this.servers = factory.create(testClass);
        this.enrichers = ResourceServerConfigurationEnricherServiceLoader.load();
        if (this.enrichers.isEmpty()) {
            throw new IllegalArgumentException("No configuration enrichers registred");
        }
        for (ResourceServerConfigurationEnricher enricher : this.enrichers) {
            enricher.beforeAll(this.servers, context);
        }
        this.resolvers = ResourceServerConfigurationResolverServiceLoader.load();
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        ArrayList<ResourceServerConfiguration> values = new ArrayList<ResourceServerConfiguration>();
        for (ResourceServerConfigurationResolver resolver : this.resolvers) {
            values.add(resolver.resolve(context));
        }
        this.configurations = values;
        for (ResourceServerConfigurationEnricher enricher : this.enrichers) {
            enricher.beforeEach(this, context);
        }
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.servers.clear();
        for (ResourceServerConfigurationEnricher enricher : this.enrichers) {
            enricher.afterAll(context);
        }
        this.enrichers.clear();
        this.resolvers.clear();
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Optional accessTokenTokenAnnotation = parameterContext.findAnnotation(AccessToken.class);
        if (accessTokenTokenAnnotation.isPresent()) {
            AuthorizationServerImplementation authorizationServerImplementation;
            AccessToken accessToken = (AccessToken)accessTokenTokenAnnotation.get();
            String authorizationServer = accessToken.by();
            if (authorizationServer != null && !authorizationServer.isEmpty()) {
                authorizationServerImplementation = this.getAuthorizationServerImplementation(authorizationServer);
                if (authorizationServerImplementation == null) {
                    throw new IllegalArgumentException("Unknown authorization server " + authorizationServer);
                }
            } else if (this.servers.size() == 1) {
                authorizationServerImplementation = this.servers.iterator().next();
            } else {
                throw new IllegalArgumentException("Please specify AccessToken authorization-server attribute when using multiple authorization servers");
            }
            AccessTokenImplementationFactory factory = new AccessTokenImplementationFactory(authorizationServerImplementation);
            String token = factory.create(accessToken, parameterContext, extensionContext, this);
            return "Bearer " + token;
        }
        throw new IllegalArgumentException("Unable to resolve parameter");
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Optional accessTokenTokenAnnotation = parameterContext.findAnnotation(AccessToken.class);
        if (accessTokenTokenAnnotation.isPresent()) {
            AccessToken accessToken = (AccessToken)accessTokenTokenAnnotation.get();
            if (this.servers.size() == 1) {
                return true;
            }
            String authorizationServer = accessToken.by();
            if (authorizationServer == null || authorizationServer.isEmpty()) {
                throw new IllegalArgumentException("Please specify AccessToken authorization-server 'by' attribute when using multiple authorization servers");
            }
            if (!authorizationServer.isEmpty()) {
                if (this.getAuthorizationServerImplementation(authorizationServer) == null) {
                    throw new IllegalArgumentException("Unknown authorization server " + authorizationServer);
                }
                return true;
            }
            throw new IllegalArgumentException("Unknown authorization-server attribute '" + authorizationServer + "' for access-token " + String.valueOf(accessTokenTokenAnnotation));
        }
        return false;
    }

    protected AuthorizationServerImplementation getAuthorizationServerImplementation(String id) {
        for (AuthorizationServerImplementation issuer : this.servers) {
            if (!issuer.getAuthorizationServer().value().equals(id)) continue;
            return issuer;
        }
        return null;
    }

    @Override
    public String getProperty(String id, String propertyName) {
        if (this.configurations.isEmpty()) {
            if (propertyName.equals("issuer")) {
                return AuthorizationServerExtension.toDefaultIssuer(id);
            }
        } else {
            for (ResourceServerConfiguration r : this.configurations) {
                String value = r.getProperty(id, propertyName);
                if (value == null) continue;
                return value;
            }
        }
        throw new IllegalArgumentException("Unknown property " + propertyName + " for tenant " + id);
    }

    public static String toIssuer(AccessToken token) {
        return AuthorizationServerExtension.toDefaultIssuer(token.by());
    }

    public static String toIssuer(AuthorizationServer server) {
        return AuthorizationServerExtension.toDefaultIssuer(server.value());
    }

    public static String toDefaultIssuer(String tenant) {
        if (tenant.isEmpty()) {
            return "https://mock.issuer.xyz";
        }
        return "https://mock.issuer." + tenant.substring(tenant.lastIndexOf(46) + 1) + ".xyz";
    }
}

