/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.junit5.impl;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.entur.jwt.junit5.AuthorizationServer;
import org.entur.jwt.junit5.impl.AnnotationUtils;
import org.entur.jwt.junit5.impl.AuthorizationServerImplementation;

public class AuthorizationServerImplementationFactory {
    public List<AuthorizationServerImplementation> create(Class<?> testClass) {
        Annotation[] annotations;
        ArrayList<AuthorizationServerImplementation> results = new ArrayList<AuthorizationServerImplementation>();
        for (Annotation annotation : annotations = testClass.getAnnotations()) {
            this.createFromAnnotation(annotation, results);
        }
        return results;
    }

    private void createFromAnnotation(Annotation annotation, List<AuthorizationServerImplementation> results) {
        if (annotation instanceof AuthorizationServer) {
            AuthorizationServer authorizationServer = (AuthorizationServer)annotation;
            results.add(new AuthorizationServerImplementation(authorizationServer, annotation));
        } else if (annotation instanceof AuthorizationServer.List) {
            AuthorizationServer.List l = (AuthorizationServer.List)annotation;
            for (AuthorizationServer authorizationServer : l.value()) {
                results.add(new AuthorizationServerImplementation(authorizationServer, annotation));
            }
        } else {
            this.createFromMetaAnnotation(annotation, results);
        }
    }

    private void createFromMetaAnnotation(Annotation annotation, List<AuthorizationServerImplementation> results) {
        Optional<AuthorizationServer.List> list;
        Optional<AuthorizationServer> single = AnnotationUtils.findAnnotation(annotation.getClass(), AuthorizationServer.class);
        if (single.isPresent()) {
            AuthorizationServer authorizationServer = single.get();
            results.add(new AuthorizationServerImplementation(authorizationServer, annotation));
        }
        if ((list = AnnotationUtils.findAnnotation(annotation.getClass(), AuthorizationServer.List.class)).isPresent()) {
            for (AuthorizationServer authorizationServer : list.get().value()) {
                results.add(new AuthorizationServerImplementation(authorizationServer, annotation));
            }
        }
    }
}

