/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.junit5.impl;

import org.entur.jwt.junit5.AccessToken;
import org.entur.jwt.junit5.AccessTokenEncoder;
import org.entur.jwt.junit5.configuration.resolve.ResourceServerConfiguration;
import org.entur.jwt.junit5.impl.AuthorizationServerImplementation;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;

public class AccessTokenImplementationFactory {
    private AuthorizationServerImplementation server;

    public AccessTokenImplementationFactory(AuthorizationServerImplementation server) {
        this.server = server;
    }

    public String create(AccessToken token, ParameterContext parameterContext, ExtensionContext extensionContext, ResourceServerConfiguration resolver) {
        Object encoder = this.getAccessTokenEncoder(token);
        return encoder.encode(parameterContext, extensionContext, this.server.getAnnotation(), this.server.getEncoder(), resolver);
    }

    protected <T extends AccessTokenEncoder> T getAccessTokenEncoder(AccessToken token) {
        Class<? extends AccessTokenEncoder> encoder = token.encoder();
        try {
            return (T)encoder.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to initialize encoder type " + encoder.getClass().getName(), e);
        }
    }
}

