/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.junit5.configuration.enrich;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;
import org.entur.jwt.junit5.configuration.enrich.AbstractPropertiesResourceServerConfigurationEnricher;
import org.entur.jwt.junit5.configuration.resolve.ResourceServerConfiguration;
import org.entur.jwt.junit5.impl.AuthorizationServerImplementation;
import org.junit.jupiter.api.extension.ExtensionContext;

public class PropertiesFileResourceServerConfigurationEnricher
extends AbstractPropertiesResourceServerConfigurationEnricher {
    protected Path output;

    public PropertiesFileResourceServerConfigurationEnricher() throws IOException {
        this("entur.jwt.tenants", Paths.get("jwt.junit5.properties", new String[0]));
    }

    public PropertiesFileResourceServerConfigurationEnricher(String prefix, Path output) {
        super(prefix);
        this.output = output;
    }

    public void setOutput(Path output) {
        this.output = output;
    }

    @Override
    public void beforeAll(List<AuthorizationServerImplementation> authorizationServers, ExtensionContext context) throws IOException {
        Properties properties = this.getProperties(authorizationServers);
        try (BufferedWriter writer = Files.newBufferedWriter(this.output, StandardCharsets.UTF_8, new OpenOption[0]);){
            properties.store(writer, null);
        }
    }

    @Override
    public void beforeEach(ResourceServerConfiguration configuration, ExtensionContext context) {
    }

    @Override
    public void afterAll(ExtensionContext context) throws IOException {
        File file;
        if (this.output != null && (file = this.output.toFile()).exists() && !file.delete()) {
            throw new IOException("Unable to delete " + this.output);
        }
    }
}

