/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.junit5.impl;

import com.fasterxml.jackson.databind.util.RawValue;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.entur.jwt.junit5.AccessToken;
import org.entur.jwt.junit5.AccessTokenEncoder;
import org.entur.jwt.junit5.AuthorizationServerEncoder;
import org.entur.jwt.junit5.claim.Audience;
import org.entur.jwt.junit5.claim.AuthorizedParty;
import org.entur.jwt.junit5.claim.BooleanArrayClaim;
import org.entur.jwt.junit5.claim.BooleanClaim;
import org.entur.jwt.junit5.claim.DoubleArrayClaim;
import org.entur.jwt.junit5.claim.DoubleClaim;
import org.entur.jwt.junit5.claim.ExpiresAt;
import org.entur.jwt.junit5.claim.IntegerArrayClaim;
import org.entur.jwt.junit5.claim.IntegerClaim;
import org.entur.jwt.junit5.claim.IssuedAt;
import org.entur.jwt.junit5.claim.Issuer;
import org.entur.jwt.junit5.claim.JsonClaim;
import org.entur.jwt.junit5.claim.MapClaim;
import org.entur.jwt.junit5.claim.Scope;
import org.entur.jwt.junit5.claim.StringArrayClaim;
import org.entur.jwt.junit5.claim.StringClaim;
import org.entur.jwt.junit5.claim.Subject;
import org.entur.jwt.junit5.configuration.resolve.ResourceServerConfiguration;
import org.entur.jwt.junit5.headers.AlgorithmHeader;
import org.entur.jwt.junit5.headers.KeyIdHeader;
import org.entur.jwt.junit5.headers.TypeHeader;
import org.entur.jwt.junit5.sabotage.Signature;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;

public class DefaultAccessTokenEncoder
implements AccessTokenEncoder {
    private static final String TYP = "typ";
    private static final String KID = "kid";
    private static final String ALG = "alg";
    private static final String ISS = "iss";
    private static final String SUB = "sub";
    private static final String AUD = "aud";
    private static final String IAT = "iat";
    private static final String EXP = "exp";
    private static final String AZP = "azp";
    private static final String SCOPE = "scope";
    private static final Class<? extends Annotation>[] fixedClaims = new Class[]{Audience.class, AuthorizedParty.class, ExpiresAt.class, IssuedAt.class, Issuer.class, Scope.class, Subject.class};
    private static final Class<? extends Annotation>[] customClaims = new Class[]{MapClaim.class, BooleanClaim.class, IntegerClaim.class, StringClaim.class, DoubleClaim.class, BooleanArrayClaim.class, IntegerArrayClaim.class, StringArrayClaim.class, DoubleArrayClaim.class, JsonClaim.class};
    private static final Class<? extends Annotation>[] fixedSabotages = new Class[]{Signature.class};
    private static final Class<? extends Annotation>[] fixedHeaders = new Class[]{AlgorithmHeader.class, KeyIdHeader.class, TypeHeader.class};

    @Override
    public String encode(ParameterContext parameterContext, ExtensionContext extensionContext, Annotation authorizationServer, AuthorizationServerEncoder encoder, ResourceServerConfiguration resolver) {
        String token = encoder.getToken(authorizationServer, this.encodeClaims(parameterContext, resolver), this.encoderHeaders(parameterContext, resolver));
        return this.sabotageToken(token, parameterContext, resolver);
    }

    protected String sabotageToken(String token, ParameterContext parameterContext, ResourceServerConfiguration resolver) {
        return this.encodeKnownSabotages(token, parameterContext);
    }

    protected String encodeKnownSabotages(String token, ParameterContext parameterContext) {
        List<Object> parameters = this.extractKnownSabotages(parameterContext);
        for (Object c : parameters) {
            if (c instanceof Signature) {
                Signature s = (Signature)c;
                int index = token.lastIndexOf(46);
                token = token.substring(index + 1) + s.value();
                continue;
            }
            throw new IllegalArgumentException("Unsupported sabotage type " + c);
        }
        return token;
    }

    public Map<String, Object> encoderHeaders(ParameterContext parameterContext, ResourceServerConfiguration resolver) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.encodeKnownHeaders(parameterContext, result, resolver);
        return result;
    }

    protected void encodeKnownHeaders(ParameterContext parameterContext, Map<String, Object> result, ResourceServerConfiguration resolver) {
        List<Object> parameters = this.extractKnownHeaders(parameterContext);
        for (Object c : parameters) {
            Annotation b;
            if (c instanceof AlgorithmHeader) {
                b = (AlgorithmHeader)c;
                result.put(ALG, b.value());
                continue;
            }
            if (c instanceof KeyIdHeader) {
                b = (KeyIdHeader)c;
                result.put(KID, b.value());
                continue;
            }
            if (c instanceof TypeHeader) {
                b = (TypeHeader)c;
                result.put(TYP, b.value());
                continue;
            }
            throw new IllegalArgumentException("Unsupported header type " + c);
        }
    }

    public Map<String, Object> encodeClaims(ParameterContext parameterContext, ResourceServerConfiguration resolver) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Optional a = parameterContext.findAnnotation(AccessToken.class);
        if (a.isPresent()) {
            this.encode(result, (AccessToken)a.get(), resolver);
        }
        this.encodeKnownClaims(parameterContext, result, resolver);
        this.encodeCustomClaims(parameterContext, result, resolver);
        this.transformParameters(result);
        return result;
    }

    protected void transformParameters(Map<String, Object> result) {
        Long issuedAt = (Long)result.get(IAT);
        result.put(IAT, System.currentTimeMillis() / 1000L + issuedAt);
        Long expiresAt = (Long)result.get(EXP);
        result.put(EXP, System.currentTimeMillis() / 1000L + expiresAt);
    }

    protected void encodeKnownClaims(ParameterContext parameterContext, Map<String, Object> result, ResourceServerConfiguration resolver) {
        List<Object> parameters = this.extractKnownClaims(parameterContext);
        if (!parameters.isEmpty()) {
            for (Object c : parameters) {
                Annotation b;
                if (c instanceof Audience) {
                    b = (Audience)c;
                    result.put(AUD, b.value());
                    continue;
                }
                if (c instanceof AuthorizedParty) {
                    b = (AuthorizedParty)c;
                    result.put(AZP, b.value());
                    continue;
                }
                if (c instanceof ExpiresAt) {
                    b = (ExpiresAt)c;
                    result.put(EXP, b.value());
                    continue;
                }
                if (c instanceof IssuedAt) {
                    b = (IssuedAt)c;
                    result.put(IAT, b.value());
                    continue;
                }
                if (c instanceof Issuer) {
                    b = (Issuer)c;
                    result.put(ISS, b.value());
                    continue;
                }
                if (c instanceof Scope) {
                    b = (Scope)c;
                    result.put(SCOPE, String.join((CharSequence)" ", b.value()));
                    continue;
                }
                if (c instanceof Subject) {
                    b = (Subject)c;
                    result.put(SUB, b.value());
                    continue;
                }
                throw new IllegalArgumentException("Unsupported claim type " + c);
            }
        }
    }

    protected void encodeCustomClaims(ParameterContext parameterContext, Map<String, Object> result, ResourceServerConfiguration resolver) {
        List<Object> parameters = this.extractCustomClaims(parameterContext);
        if (!parameters.isEmpty()) {
            for (Object c : parameters) {
                Annotation b;
                if (c instanceof BooleanClaim) {
                    b = (BooleanClaim)c;
                    result.put(b.name(), b.value());
                    continue;
                }
                if (c instanceof IntegerClaim) {
                    b = (IntegerClaim)c;
                    result.put(b.name(), b.value());
                    continue;
                }
                if (c instanceof DoubleClaim) {
                    b = (DoubleClaim)c;
                    result.put(b.name(), b.value());
                    continue;
                }
                if (c instanceof StringClaim) {
                    b = (StringClaim)c;
                    result.put(b.name(), b.value());
                    continue;
                }
                if (c instanceof BooleanArrayClaim) {
                    b = (BooleanArrayClaim)c;
                    result.put(b.name(), b.value());
                    continue;
                }
                if (c instanceof IntegerArrayClaim) {
                    b = (IntegerArrayClaim)c;
                    result.put(b.name(), b.value());
                    continue;
                }
                if (c instanceof DoubleArrayClaim) {
                    b = (DoubleArrayClaim)c;
                    result.put(b.name(), b.value());
                    continue;
                }
                if (c instanceof StringArrayClaim) {
                    b = (StringArrayClaim)c;
                    result.put(b.name(), b.value());
                    continue;
                }
                if (c instanceof MapClaim) {
                    MapClaim mapClaim = (MapClaim)c;
                    String[] paths = mapClaim.path();
                    HashMap<String, Object> mapForPath = result;
                    int i = 0;
                    do {
                        HashMap<String, Object> nextMapForPath;
                        if ((nextMapForPath = (HashMap<String, Object>)mapForPath.get(paths[i])) == null) {
                            nextMapForPath = new HashMap<String, Object>();
                            mapForPath.put(paths[i], nextMapForPath);
                        }
                        mapForPath = nextMapForPath;
                    } while (++i < paths.length);
                    for (MapClaim.Entry entry : mapClaim.entries()) {
                        String[] value = entry.value();
                        if (!entry.alwaysArray() && value.length == 1) {
                            mapForPath.put(entry.name(), this.valueForType(value[0], entry.type()));
                            continue;
                        }
                        ArrayList<Object> list = new ArrayList<Object>();
                        for (String v : value) {
                            list.add(this.valueForType(v, entry.type()));
                        }
                        mapForPath.put(entry.name(), list);
                    }
                    continue;
                }
                if (c instanceof JsonClaim) {
                    JsonClaim jsonClaim = (JsonClaim)c;
                    result.put(jsonClaim.name(), new RawValue(jsonClaim.value()));
                    continue;
                }
                throw new IllegalArgumentException("Unsupported claim type " + c);
            }
        }
    }

    protected Object valueForType(String value, Class<?> type) {
        if (type == String.class) {
            return value;
        }
        if (type == Long.class) {
            return Long.parseLong(value);
        }
        if (type == Integer.class) {
            return Integer.parseInt(value);
        }
        if (type == Boolean.class) {
            return Boolean.parseBoolean(value);
        }
        if (type == Double.class) {
            return Double.parseDouble(value);
        }
        if (type == Float.class) {
            return Float.valueOf(Float.parseFloat(value));
        }
        throw new IllegalArgumentException("Cant convert '" + value + "' to " + type.getName());
    }

    protected List<Object> extractCustomClaims(ParameterContext parameterContext) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        for (Class<? extends Annotation> c : customClaims) {
            parameters.addAll(parameterContext.findRepeatableAnnotations(c));
        }
        return parameters;
    }

    protected List<Object> extractAnnotations(ParameterContext parameterContext, Class<? extends Annotation>[] items) {
        ArrayList<Object> parameters = new ArrayList<Object>(items.length);
        for (Class<? extends Annotation> c : items) {
            Optional optional = parameterContext.findAnnotation(c);
            if (!optional.isPresent()) continue;
            parameters.add(optional.get());
        }
        return parameters;
    }

    protected List<Object> extractKnownClaims(ParameterContext parameterContext) {
        return this.extractAnnotations(parameterContext, fixedClaims);
    }

    protected List<Object> extractKnownHeaders(ParameterContext parameterContext) {
        return this.extractAnnotations(parameterContext, fixedHeaders);
    }

    protected List<Object> extractKnownSabotages(ParameterContext parameterContext) {
        return this.extractAnnotations(parameterContext, fixedSabotages);
    }

    protected void encode(Map<String, Object> result, AccessToken token, ResourceServerConfiguration resolver) {
        String[] audience;
        if (!result.containsKey(ISS)) {
            result.put(ISS, resolver.getProperty(token.by(), "issuer"));
        }
        if (!this.isBlank(token.subject())) {
            result.put(SUB, token.subject());
        }
        if (!result.containsKey(AUD) && (audience = token.audience()) != null && audience.length > 0) {
            result.put(AUD, audience);
        }
        if (!result.containsKey(IAT)) {
            result.put(IAT, token.issuedAt() * 1000L);
        }
        if (!result.containsKey(EXP)) {
            result.put(EXP, token.expiresAt() * 1000L);
        }
        if (!result.containsKey(SCOPE) && !this.isBlank(token.scope())) {
            result.put(SCOPE, token.scope());
        }
        if (!result.containsKey(AZP) && !this.isBlank(token.authorizedParty())) {
            result.put(AZP, token.authorizedParty());
        }
    }

    private boolean isBlank(String[] scope) {
        return scope == null || scope.length == 0;
    }

    private boolean isBlank(String subject) {
        return subject == null || subject.isEmpty();
    }
}

