/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.jwk.connect2id;

import com.nimbusds.jose.KeySourceException;
import com.nimbusds.jose.RemoteKeySourceException;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import java.util.LinkedList;
import java.util.List;
import org.entur.jwt.jwk.JwksException;
import org.entur.jwt.jwk.JwksProvider;
import org.entur.jwt.jwk.JwksUnavailableException;

public class EnturJWKSource<C extends SecurityContext>
implements JWKSource<C> {
    private final JwksProvider<JWK> provider;

    public EnturJWKSource(JwksProvider<JWK> provider) {
        this.provider = provider;
    }

    public List<JWK> get(JWKSelector jwkSelector, C context) throws KeySourceException {
        JWKMatcher matcher = jwkSelector.getMatcher();
        try {
            List<JWK> select = this.select(this.provider.getJwks(false), matcher);
            if (select.isEmpty()) {
                select = this.select(this.provider.getJwks(true), matcher);
            }
            return select;
        }
        catch (JwksUnavailableException e) {
            throw new RemoteKeySourceException("Unable to get keys", (Throwable)e);
        }
        catch (JwksException e) {
            throw new KeySourceException("Unable to get keys", (Throwable)e);
        }
    }

    public List<JWK> select(List<JWK> list, JWKMatcher matcher) {
        LinkedList<JWK> selectedKeys = new LinkedList<JWK>();
        if (list == null) {
            return selectedKeys;
        }
        for (JWK jwk : list) {
            if (!matcher.matches(jwk)) continue;
            selectedKeys.add(jwk);
        }
        return selectedKeys;
    }
}

