/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.jwk.connect2id;

import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.List;
import org.entur.jwt.jwk.InvalidSigningKeysException;
import org.entur.jwt.jwk.JwksReader;

public class Connect2IdJwkReader
implements JwksReader<JWK> {
    public List<JWK> readJwks(InputStream inputStream) throws IOException, InvalidSigningKeysException {
        JWKSet parse;
        String content = IOUtils.readInputStreamToString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        try {
            parse = JWKSet.parse((String)content);
        }
        catch (ParseException e) {
            throw new InvalidSigningKeysException("Unable to parse keys", (Throwable)e);
        }
        return parse.getKeys();
    }
}

