/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.mapper;

import java.util.List;
import java.util.stream.Collectors;
import org.entur.gbfs.v2_3.station_information.GBFSVehicleCapacity;
import org.entur.gbfs.v2_3.station_information.GBFSVehicleTypeCapacity;
import org.entur.gbfs.v3_0_RC.station_information.GBFSName;
import org.entur.gbfs.v3_0_RC.station_information.GBFSShortName;
import org.entur.gbfs.v3_0_RC.station_information.GBFSStation;
import org.entur.gbfs.v3_0_RC.station_information.GBFSVehicleTypeAreaCapacity;
import org.entur.gbfs.v3_0_RC.station_information.GBFSVehicleTypeDockCapacity;
import org.mapstruct.Context;
import org.mapstruct.InheritInverseConfiguration;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;

@Mapper
public abstract class StationInformationAdditionalMapper {
    List<GBFSName> mapName(String value, @Context String language) {
        if (value == null) {
            return null;
        }
        return List.of(new GBFSName().withText(value).withLanguage(language));
    }

    String mapNameInverse(List<GBFSName> values, @Context String language) {
        if (values == null) {
            return null;
        }
        return values.stream().filter(name -> name.getLanguage().equals(language)).map(GBFSName::getText).findFirst().orElse(null);
    }

    List<GBFSShortName> mapShortName(String value, @Context String language) {
        if (value == null) {
            return null;
        }
        return List.of(new GBFSShortName().withText(value).withLanguage(language));
    }

    String mapShortNameInverse(List<GBFSShortName> values, @Context String language) {
        if (values == null) {
            return null;
        }
        return values.stream().filter(name -> name.getLanguage().equals(language)).map(GBFSShortName::getText).findFirst().orElse(null);
    }

    @Mappings(value={@Mapping(source="vehicleCapacity", target="vehicleTypeAreaCapacity"), @Mapping(source="vehicleTypeCapacity", target="vehicleTypeDockCapacity")})
    abstract GBFSStation mapStation(org.entur.gbfs.v2_3.station_information.GBFSStation var1, @Context String var2);

    List<GBFSVehicleTypeAreaCapacity> mapVehicleTypeAreaCapacity(GBFSVehicleCapacity source) {
        if (source == null) {
            return null;
        }
        return source.getAdditionalProperties().entrySet().stream().map(entry -> new GBFSVehicleTypeAreaCapacity().withVehicleTypeId((String)entry.getKey()).withCount(Integer.valueOf(((Double)entry.getValue()).intValue()))).collect(Collectors.toList());
    }

    List<GBFSVehicleTypeDockCapacity> mapVehicleTypeDockCapacity(GBFSVehicleTypeCapacity source) {
        if (source == null) {
            return null;
        }
        return source.getAdditionalProperties().entrySet().stream().map(entry -> new GBFSVehicleTypeDockCapacity().withVehicleTypeId((String)entry.getKey()).withCount(Integer.valueOf(((Double)entry.getValue()).intValue()))).collect(Collectors.toList());
    }

    @InheritInverseConfiguration
    abstract org.entur.gbfs.v2_3.station_information.GBFSStation mapStationInverse(GBFSStation var1, @Context String var2);

    GBFSVehicleCapacity mapVehicleTypeAreaCapacityInverse(List<GBFSVehicleTypeAreaCapacity> source) {
        if (source == null) {
            return null;
        }
        GBFSVehicleCapacity mapped = new GBFSVehicleCapacity();
        source.forEach(gbfsVehicleTypeAreaCapacity -> mapped.setAdditionalProperty(gbfsVehicleTypeAreaCapacity.getVehicleTypeId(), Double.valueOf(gbfsVehicleTypeAreaCapacity.getCount().doubleValue())));
        return mapped;
    }

    GBFSVehicleTypeCapacity mapVehicleTypeDockCapacityInverse(List<GBFSVehicleTypeDockCapacity> source) {
        if (source == null) {
            return null;
        }
        GBFSVehicleTypeCapacity mapped = new GBFSVehicleTypeCapacity();
        source.forEach(gbfsVehicleTypeDockCapacity -> mapped.setAdditionalProperty(gbfsVehicleTypeDockCapacity.getVehicleTypeId(), Double.valueOf(gbfsVehicleTypeDockCapacity.getCount().doubleValue())));
        return mapped;
    }
}

