/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.mapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.entur.gbfs.mapper.DiscoveryFileAdditionalMapper;
import org.entur.gbfs.mapper.GBFSMapper;
import org.entur.gbfs.mapper.GeofencingZonesAdditionalMapper;
import org.entur.gbfs.mapper.StationInformationAdditionalMapper;
import org.entur.gbfs.mapper.StationStatusAdditionalMapper;
import org.entur.gbfs.mapper.SystemAlertsAdditionalMapper;
import org.entur.gbfs.mapper.SystemInformationAdditionalMapper;
import org.entur.gbfs.mapper.SystemPricingPlansAdditionalMapper;
import org.entur.gbfs.mapper.SystemRegionsAdditionalMapper;
import org.entur.gbfs.mapper.VehicleStatusAdditionalMapper;
import org.entur.gbfs.mapper.VehicleTypesAdditionalMapper;
import org.entur.gbfs.v2_3.free_bike_status.GBFSFreeBikeStatus;
import org.entur.gbfs.v2_3.gbfs.GBFS;
import org.entur.gbfs.v2_3.gbfs_versions.GBFSGbfsVersions;
import org.entur.gbfs.v2_3.gbfs_versions.GBFSVersion;
import org.entur.gbfs.v2_3.geofencing_zones.GBFSFeature;
import org.entur.gbfs.v2_3.geofencing_zones.GBFSGeofencingZones;
import org.entur.gbfs.v2_3.geofencing_zones.GBFSGeofencingZones__1;
import org.entur.gbfs.v2_3.geofencing_zones.GBFSProperties;
import org.entur.gbfs.v2_3.system_alerts.GBFSAlert;
import org.entur.gbfs.v2_3.system_information.GBFSSystemInformation;
import org.entur.gbfs.v2_3.system_pricing_plans.GBFSPerKmPricing;
import org.entur.gbfs.v2_3.system_regions.GBFSRegion;
import org.entur.gbfs.v2_3.system_regions.GBFSSystemRegions;
import org.entur.gbfs.v2_3.vehicle_types.GBFSVehicleAssets;
import org.entur.gbfs.v2_3.vehicle_types.GBFSVehicleType;
import org.entur.gbfs.v2_3.vehicle_types.VehicleAccessory;
import org.entur.gbfs.v3_0_RC.gbfs.GBFSGbfs;
import org.entur.gbfs.v3_0_RC.gbfs_versions.GBFSGbfsVersions;
import org.entur.gbfs.v3_0_RC.gbfs_versions.GBFSVersion;
import org.entur.gbfs.v3_0_RC.geofencing_zones.GBFSFeature;
import org.entur.gbfs.v3_0_RC.geofencing_zones.GBFSGeofencingZones;
import org.entur.gbfs.v3_0_RC.geofencing_zones.GBFSGeofencingZones__1;
import org.entur.gbfs.v3_0_RC.geofencing_zones.GBFSRule;
import org.entur.gbfs.v3_0_RC.station_information.GBFSStationInformation;
import org.entur.gbfs.v3_0_RC.station_status.GBFSData;
import org.entur.gbfs.v3_0_RC.station_status.GBFSStation;
import org.entur.gbfs.v3_0_RC.station_status.GBFSStationStatus;
import org.entur.gbfs.v3_0_RC.system_alerts.GBFSAlert;
import org.entur.gbfs.v3_0_RC.system_alerts.GBFSSystemAlerts;
import org.entur.gbfs.v3_0_RC.system_alerts.GBFSTime;
import org.entur.gbfs.v3_0_RC.system_information.GBFSSystemInformation;
import org.entur.gbfs.v3_0_RC.system_pricing_plans.GBFSPerMinPricing;
import org.entur.gbfs.v3_0_RC.system_pricing_plans.GBFSPlan;
import org.entur.gbfs.v3_0_RC.system_pricing_plans.GBFSSystemPricingPlans;
import org.entur.gbfs.v3_0_RC.system_regions.GBFSSystemRegions;
import org.entur.gbfs.v3_0_RC.vehicle_status.GBFSVehicleStatus;
import org.entur.gbfs.v3_0_RC.vehicle_types.GBFSEcoLabel;
import org.entur.gbfs.v3_0_RC.vehicle_types.GBFSVehicleType;
import org.entur.gbfs.v3_0_RC.vehicle_types.GBFSVehicleTypes;
import org.mapstruct.factory.Mappers;

public class GBFSMapperImpl
implements GBFSMapper {
    private final DiscoveryFileAdditionalMapper discoveryFileAdditionalMapper = new DiscoveryFileAdditionalMapper();
    private final SystemInformationAdditionalMapper systemInformationAdditionalMapper = (SystemInformationAdditionalMapper)Mappers.getMapper(SystemInformationAdditionalMapper.class);
    private final VehicleTypesAdditionalMapper vehicleTypesAdditionalMapper = new VehicleTypesAdditionalMapper();
    private final VehicleStatusAdditionalMapper vehicleStatusAdditionalMapper = (VehicleStatusAdditionalMapper)Mappers.getMapper(VehicleStatusAdditionalMapper.class);
    private final StationInformationAdditionalMapper stationInformationAdditionalMapper = (StationInformationAdditionalMapper)Mappers.getMapper(StationInformationAdditionalMapper.class);
    private final StationStatusAdditionalMapper stationStatusAdditionalMapper = (StationStatusAdditionalMapper)Mappers.getMapper(StationStatusAdditionalMapper.class);
    private final SystemPricingPlansAdditionalMapper systemPricingPlansAdditionalMapper = new SystemPricingPlansAdditionalMapper();
    private final GeofencingZonesAdditionalMapper geofencingZonesAdditionalMapper = (GeofencingZonesAdditionalMapper)Mappers.getMapper(GeofencingZonesAdditionalMapper.class);
    private final SystemRegionsAdditionalMapper systemRegionsAdditionalMapper = new SystemRegionsAdditionalMapper();
    private final SystemAlertsAdditionalMapper systemAlertsAdditionalMapper = new SystemAlertsAdditionalMapper();

    @Override
    public GBFSGbfs map(GBFS source, String language) {
        if (source == null) {
            return null;
        }
        GBFSGbfs gBFSGbfs = new GBFSGbfs();
        gBFSGbfs.setData(this.discoveryFileAdditionalMapper.map(source.getFeedsData(), language));
        gBFSGbfs.setLastUpdated(source.getLastUpdated());
        gBFSGbfs.setTtl(source.getTtl());
        gBFSGbfs.setVersion(GBFSGbfs.Version._3_0_RC);
        return gBFSGbfs;
    }

    @Override
    public GBFS map(GBFSGbfs source, String language) {
        if (source == null) {
            return null;
        }
        GBFS gBFS = new GBFS();
        gBFS.setFeedsData(this.discoveryFileAdditionalMapper.map(source.getData(), language));
        gBFS.setLastUpdated(source.getLastUpdated());
        gBFS.setTtl(source.getTtl());
        gBFS.setVersion("2.3");
        return gBFS;
    }

    @Override
    public org.entur.gbfs.v3_0_RC.gbfs_versions.GBFSGbfsVersions map(GBFSGbfsVersions source, String language) {
        Map map;
        if (source == null) {
            return null;
        }
        org.entur.gbfs.v3_0_RC.gbfs_versions.GBFSGbfsVersions gBFSGbfsVersions = new org.entur.gbfs.v3_0_RC.gbfs_versions.GBFSGbfsVersions();
        gBFSGbfsVersions.setLastUpdated(source.getLastUpdated());
        gBFSGbfsVersions.setTtl(source.getTtl());
        gBFSGbfsVersions.setData(this.gBFSDataToGBFSData(source.getData(), language));
        if (gBFSGbfsVersions.getAdditionalProperties() != null && (map = source.getAdditionalProperties()) != null) {
            gBFSGbfsVersions.getAdditionalProperties().putAll(map);
        }
        gBFSGbfsVersions.setVersion(GBFSGbfsVersions.Version._3_0_RC);
        return gBFSGbfsVersions;
    }

    @Override
    public GBFSGbfsVersions map(org.entur.gbfs.v3_0_RC.gbfs_versions.GBFSGbfsVersions source, String language) {
        Map map;
        if (source == null) {
            return null;
        }
        GBFSGbfsVersions gBFSGbfsVersions = new GBFSGbfsVersions();
        gBFSGbfsVersions.setLastUpdated(source.getLastUpdated());
        gBFSGbfsVersions.setTtl(source.getTtl());
        gBFSGbfsVersions.setData(this.gBFSDataToGBFSData1(source.getData(), language));
        if (gBFSGbfsVersions.getAdditionalProperties() != null && (map = source.getAdditionalProperties()) != null) {
            gBFSGbfsVersions.getAdditionalProperties().putAll(map);
        }
        gBFSGbfsVersions.setVersion("2.3");
        return gBFSGbfsVersions;
    }

    @Override
    public org.entur.gbfs.v3_0_RC.system_information.GBFSSystemInformation map(GBFSSystemInformation source, String language) {
        Map map;
        if (source == null) {
            return null;
        }
        org.entur.gbfs.v3_0_RC.system_information.GBFSSystemInformation gBFSSystemInformation = new org.entur.gbfs.v3_0_RC.system_information.GBFSSystemInformation();
        gBFSSystemInformation.setData(this.systemInformationAdditionalMapper.mapData(source.getData(), language));
        gBFSSystemInformation.setLastUpdated(source.getLastUpdated());
        gBFSSystemInformation.setTtl(source.getTtl());
        if (gBFSSystemInformation.getAdditionalProperties() != null && (map = source.getAdditionalProperties()) != null) {
            gBFSSystemInformation.getAdditionalProperties().putAll(map);
        }
        gBFSSystemInformation.setVersion(GBFSSystemInformation.Version._3_0_RC);
        return gBFSSystemInformation;
    }

    @Override
    public GBFSSystemInformation map(org.entur.gbfs.v3_0_RC.system_information.GBFSSystemInformation source, String language) {
        Map map;
        if (source == null) {
            return null;
        }
        GBFSSystemInformation gBFSSystemInformation = new GBFSSystemInformation();
        gBFSSystemInformation.setData(this.systemInformationAdditionalMapper.mapDataInverse(source.getData(), language));
        gBFSSystemInformation.setLastUpdated(source.getLastUpdated());
        gBFSSystemInformation.setTtl(source.getTtl());
        if (gBFSSystemInformation.getAdditionalProperties() != null && (map = source.getAdditionalProperties()) != null) {
            gBFSSystemInformation.getAdditionalProperties().putAll(map);
        }
        gBFSSystemInformation.setVersion("2.3");
        return gBFSSystemInformation;
    }

    @Override
    public GBFSVehicleTypes map(org.entur.gbfs.v2_3.vehicle_types.GBFSVehicleTypes source, String language) {
        Map map;
        if (source == null) {
            return null;
        }
        GBFSVehicleTypes gBFSVehicleTypes = new GBFSVehicleTypes();
        gBFSVehicleTypes.setLastUpdated(source.getLastUpdated());
        gBFSVehicleTypes.setTtl(source.getTtl());
        gBFSVehicleTypes.setData(this.gBFSDataToGBFSData2(source.getData(), language));
        if (gBFSVehicleTypes.getAdditionalProperties() != null && (map = source.getAdditionalProperties()) != null) {
            gBFSVehicleTypes.getAdditionalProperties().putAll(map);
        }
        gBFSVehicleTypes.setVersion(GBFSVehicleTypes.Version._3_0_RC);
        return gBFSVehicleTypes;
    }

    @Override
    public org.entur.gbfs.v2_3.vehicle_types.GBFSVehicleTypes map(GBFSVehicleTypes source, String language) {
        Map map;
        if (source == null) {
            return null;
        }
        org.entur.gbfs.v2_3.vehicle_types.GBFSVehicleTypes gBFSVehicleTypes = new org.entur.gbfs.v2_3.vehicle_types.GBFSVehicleTypes();
        gBFSVehicleTypes.setLastUpdated(source.getLastUpdated());
        gBFSVehicleTypes.setTtl(source.getTtl());
        gBFSVehicleTypes.setData(this.gBFSDataToGBFSData3(source.getData(), language));
        if (gBFSVehicleTypes.getAdditionalProperties() != null && (map = source.getAdditionalProperties()) != null) {
            gBFSVehicleTypes.getAdditionalProperties().putAll(map);
        }
        gBFSVehicleTypes.setVersion("2.3");
        return gBFSVehicleTypes;
    }

    @Override
    public GBFSVehicleStatus map(GBFSFreeBikeStatus source, String language) {
        Map map;
        if (source == null) {
            return null;
        }
        GBFSVehicleStatus gBFSVehicleStatus = new GBFSVehicleStatus();
        gBFSVehicleStatus.setData(this.vehicleStatusAdditionalMapper.mapDataInverse(source.getData()));
        gBFSVehicleStatus.setLastUpdated(source.getLastUpdated());
        gBFSVehicleStatus.setTtl(source.getTtl());
        if (gBFSVehicleStatus.getAdditionalProperties() != null && (map = source.getAdditionalProperties()) != null) {
            gBFSVehicleStatus.getAdditionalProperties().putAll(map);
        }
        gBFSVehicleStatus.setVersion(GBFSVehicleStatus.Version._3_0_RC);
        return gBFSVehicleStatus;
    }

    @Override
    public GBFSFreeBikeStatus map(GBFSVehicleStatus source, String language) {
        Map map;
        if (source == null) {
            return null;
        }
        GBFSFreeBikeStatus gBFSFreeBikeStatus = new GBFSFreeBikeStatus();
        gBFSFreeBikeStatus.setData(this.vehicleStatusAdditionalMapper.mapData(source.getData()));
        gBFSFreeBikeStatus.setLastUpdated(source.getLastUpdated());
        gBFSFreeBikeStatus.setTtl(source.getTtl());
        if (gBFSFreeBikeStatus.getAdditionalProperties() != null && (map = source.getAdditionalProperties()) != null) {
            gBFSFreeBikeStatus.getAdditionalProperties().putAll(map);
        }
        gBFSFreeBikeStatus.setVersion("2.3");
        return gBFSFreeBikeStatus;
    }

    @Override
    public GBFSStationInformation map(org.entur.gbfs.v2_3.station_information.GBFSStationInformation source, String language) {
        Map map;
        if (source == null) {
            return null;
        }
        GBFSStationInformation gBFSStationInformation = new GBFSStationInformation();
        gBFSStationInformation.setLastUpdated(source.getLastUpdated());
        gBFSStationInformation.setTtl(source.getTtl());
        gBFSStationInformation.setData(this.gBFSDataToGBFSData4(source.getData(), language));
        if (gBFSStationInformation.getAdditionalProperties() != null && (map = source.getAdditionalProperties()) != null) {
            gBFSStationInformation.getAdditionalProperties().putAll(map);
        }
        gBFSStationInformation.setVersion(GBFSStationInformation.Version._3_0_RC);
        return gBFSStationInformation;
    }

    @Override
    public org.entur.gbfs.v2_3.station_information.GBFSStationInformation map(GBFSStationInformation source, String language) {
        Map map;
        if (source == null) {
            return null;
        }
        org.entur.gbfs.v2_3.station_information.GBFSStationInformation gBFSStationInformation = new org.entur.gbfs.v2_3.station_information.GBFSStationInformation();
        gBFSStationInformation.setLastUpdated(source.getLastUpdated());
        gBFSStationInformation.setTtl(source.getTtl());
        gBFSStationInformation.setData(this.gBFSDataToGBFSData5(source.getData(), language));
        if (gBFSStationInformation.getAdditionalProperties() != null && (map = source.getAdditionalProperties()) != null) {
            gBFSStationInformation.getAdditionalProperties().putAll(map);
        }
        gBFSStationInformation.setVersion("2.3");
        return gBFSStationInformation;
    }

    @Override
    public GBFSStationStatus map(org.entur.gbfs.v2_3.station_status.GBFSStationStatus source, String language) {
        Map map;
        if (source == null) {
            return null;
        }
        GBFSStationStatus gBFSStationStatus = new GBFSStationStatus();
        gBFSStationStatus.setLastUpdated(source.getLastUpdated());
        gBFSStationStatus.setTtl(source.getTtl());
        gBFSStationStatus.setData(this.gBFSDataToGBFSData6(source.getData(), language));
        if (gBFSStationStatus.getAdditionalProperties() != null && (map = source.getAdditionalProperties()) != null) {
            gBFSStationStatus.getAdditionalProperties().putAll(map);
        }
        gBFSStationStatus.setVersion(GBFSStationStatus.Version._3_0_RC);
        return gBFSStationStatus;
    }

    @Override
    public org.entur.gbfs.v2_3.station_status.GBFSStationStatus map(GBFSStationStatus source, String language) {
        Map map;
        if (source == null) {
            return null;
        }
        org.entur.gbfs.v2_3.station_status.GBFSStationStatus gBFSStationStatus = new org.entur.gbfs.v2_3.station_status.GBFSStationStatus();
        gBFSStationStatus.setLastUpdated(source.getLastUpdated());
        gBFSStationStatus.setTtl(source.getTtl());
        gBFSStationStatus.setData(this.gBFSDataToGBFSData7(source.getData(), language));
        if (gBFSStationStatus.getAdditionalProperties() != null && (map = source.getAdditionalProperties()) != null) {
            gBFSStationStatus.getAdditionalProperties().putAll(map);
        }
        gBFSStationStatus.setVersion("2.3");
        return gBFSStationStatus;
    }

    @Override
    public GBFSSystemPricingPlans map(org.entur.gbfs.v2_3.system_pricing_plans.GBFSSystemPricingPlans source, String language) {
        Map map;
        if (source == null) {
            return null;
        }
        GBFSSystemPricingPlans gBFSSystemPricingPlans = new GBFSSystemPricingPlans();
        gBFSSystemPricingPlans.setLastUpdated(source.getLastUpdated());
        gBFSSystemPricingPlans.setTtl(source.getTtl());
        gBFSSystemPricingPlans.setData(this.gBFSDataToGBFSData8(source.getData(), language));
        if (gBFSSystemPricingPlans.getAdditionalProperties() != null && (map = source.getAdditionalProperties()) != null) {
            gBFSSystemPricingPlans.getAdditionalProperties().putAll(map);
        }
        gBFSSystemPricingPlans.setVersion(GBFSSystemPricingPlans.Version._3_0_RC);
        return gBFSSystemPricingPlans;
    }

    @Override
    public org.entur.gbfs.v2_3.system_pricing_plans.GBFSSystemPricingPlans map(GBFSSystemPricingPlans source, String language) {
        Map map;
        if (source == null) {
            return null;
        }
        org.entur.gbfs.v2_3.system_pricing_plans.GBFSSystemPricingPlans gBFSSystemPricingPlans = new org.entur.gbfs.v2_3.system_pricing_plans.GBFSSystemPricingPlans();
        gBFSSystemPricingPlans.setLastUpdated(source.getLastUpdated());
        gBFSSystemPricingPlans.setTtl(source.getTtl());
        gBFSSystemPricingPlans.setData(this.gBFSDataToGBFSData9(source.getData(), language));
        if (gBFSSystemPricingPlans.getAdditionalProperties() != null && (map = source.getAdditionalProperties()) != null) {
            gBFSSystemPricingPlans.getAdditionalProperties().putAll(map);
        }
        gBFSSystemPricingPlans.setVersion("2.3");
        return gBFSSystemPricingPlans;
    }

    @Override
    public org.entur.gbfs.v3_0_RC.geofencing_zones.GBFSGeofencingZones map(GBFSGeofencingZones source, String language) {
        Map map;
        if (source == null) {
            return null;
        }
        org.entur.gbfs.v3_0_RC.geofencing_zones.GBFSGeofencingZones gBFSGeofencingZones = new org.entur.gbfs.v3_0_RC.geofencing_zones.GBFSGeofencingZones();
        gBFSGeofencingZones.setLastUpdated(source.getLastUpdated());
        gBFSGeofencingZones.setTtl(source.getTtl());
        gBFSGeofencingZones.setData(this.gBFSDataToGBFSData10(source.getData(), language));
        if (gBFSGeofencingZones.getAdditionalProperties() != null && (map = source.getAdditionalProperties()) != null) {
            gBFSGeofencingZones.getAdditionalProperties().putAll(map);
        }
        gBFSGeofencingZones.setVersion(GBFSGeofencingZones.Version._3_0_RC);
        return gBFSGeofencingZones;
    }

    @Override
    public GBFSGeofencingZones map(org.entur.gbfs.v3_0_RC.geofencing_zones.GBFSGeofencingZones source, String language) {
        Map map;
        if (source == null) {
            return null;
        }
        GBFSGeofencingZones gBFSGeofencingZones = new GBFSGeofencingZones();
        gBFSGeofencingZones.setLastUpdated(source.getLastUpdated());
        gBFSGeofencingZones.setTtl(source.getTtl());
        gBFSGeofencingZones.setData(this.gBFSDataToGBFSData11(source.getData(), language));
        if (gBFSGeofencingZones.getAdditionalProperties() != null && (map = source.getAdditionalProperties()) != null) {
            gBFSGeofencingZones.getAdditionalProperties().putAll(map);
        }
        gBFSGeofencingZones.setVersion("2.3");
        return gBFSGeofencingZones;
    }

    @Override
    public org.entur.gbfs.v3_0_RC.system_regions.GBFSSystemRegions map(GBFSSystemRegions source, String language) {
        Map map;
        if (source == null) {
            return null;
        }
        org.entur.gbfs.v3_0_RC.system_regions.GBFSSystemRegions gBFSSystemRegions = new org.entur.gbfs.v3_0_RC.system_regions.GBFSSystemRegions();
        gBFSSystemRegions.setLastUpdated(source.getLastUpdated());
        gBFSSystemRegions.setTtl(source.getTtl());
        gBFSSystemRegions.setData(this.gBFSDataToGBFSData12(source.getData(), language));
        if (gBFSSystemRegions.getAdditionalProperties() != null && (map = source.getAdditionalProperties()) != null) {
            gBFSSystemRegions.getAdditionalProperties().putAll(map);
        }
        gBFSSystemRegions.setVersion(GBFSSystemRegions.Version._3_0_RC);
        return gBFSSystemRegions;
    }

    @Override
    public GBFSSystemRegions map(org.entur.gbfs.v3_0_RC.system_regions.GBFSSystemRegions source, String language) {
        Map map;
        if (source == null) {
            return null;
        }
        GBFSSystemRegions gBFSSystemRegions = new GBFSSystemRegions();
        gBFSSystemRegions.setLastUpdated(source.getLastUpdated());
        gBFSSystemRegions.setTtl(source.getTtl());
        gBFSSystemRegions.setData(this.gBFSDataToGBFSData13(source.getData(), language));
        if (gBFSSystemRegions.getAdditionalProperties() != null && (map = source.getAdditionalProperties()) != null) {
            gBFSSystemRegions.getAdditionalProperties().putAll(map);
        }
        gBFSSystemRegions.setVersion("2.3");
        return gBFSSystemRegions;
    }

    @Override
    public GBFSSystemAlerts map(org.entur.gbfs.v2_3.system_alerts.GBFSSystemAlerts source, String language) {
        Map map;
        if (source == null) {
            return null;
        }
        GBFSSystemAlerts gBFSSystemAlerts = new GBFSSystemAlerts();
        gBFSSystemAlerts.setLastUpdated(source.getLastUpdated());
        gBFSSystemAlerts.setTtl(source.getTtl());
        gBFSSystemAlerts.setData(this.gBFSDataToGBFSData14(source.getData(), language));
        if (gBFSSystemAlerts.getAdditionalProperties() != null && (map = source.getAdditionalProperties()) != null) {
            gBFSSystemAlerts.getAdditionalProperties().putAll(map);
        }
        gBFSSystemAlerts.setVersion(GBFSSystemAlerts.Version._3_0_RC);
        return gBFSSystemAlerts;
    }

    @Override
    public org.entur.gbfs.v2_3.system_alerts.GBFSSystemAlerts map(GBFSSystemAlerts source, String language) {
        Map map;
        if (source == null) {
            return null;
        }
        org.entur.gbfs.v2_3.system_alerts.GBFSSystemAlerts gBFSSystemAlerts = new org.entur.gbfs.v2_3.system_alerts.GBFSSystemAlerts();
        gBFSSystemAlerts.setLastUpdated(source.getLastUpdated());
        gBFSSystemAlerts.setTtl(source.getTtl());
        gBFSSystemAlerts.setData(this.gBFSDataToGBFSData15(source.getData(), language));
        if (gBFSSystemAlerts.getAdditionalProperties() != null && (map = source.getAdditionalProperties()) != null) {
            gBFSSystemAlerts.getAdditionalProperties().putAll(map);
        }
        gBFSSystemAlerts.setVersion("2.3");
        return gBFSSystemAlerts;
    }

    protected GBFSVersion.Version versionToVersion(GBFSVersion.Version version, String language) {
        GBFSVersion.Version version1;
        if (version == null) {
            return null;
        }
        switch (version) {
            case _1_0: {
                version1 = GBFSVersion.Version._1_0;
                break;
            }
            case _1_1: {
                version1 = GBFSVersion.Version._1_1;
                break;
            }
            case _2_0: {
                version1 = GBFSVersion.Version._2_0;
                break;
            }
            case _2_1: {
                version1 = GBFSVersion.Version._2_1;
                break;
            }
            case _2_2: {
                version1 = GBFSVersion.Version._2_2;
                break;
            }
            case _2_3: {
                version1 = GBFSVersion.Version._2_3;
                break;
            }
            case _3_0_RC: {
                version1 = GBFSVersion.Version._3_0_RC;
                break;
            }
            case _3_0: {
                version1 = GBFSVersion.Version._3_0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + version);
            }
        }
        return version1;
    }

    protected org.entur.gbfs.v3_0_RC.gbfs_versions.GBFSVersion gBFSVersionToGBFSVersion(GBFSVersion gBFSVersion, String language) {
        Map map;
        if (gBFSVersion == null) {
            return null;
        }
        org.entur.gbfs.v3_0_RC.gbfs_versions.GBFSVersion gBFSVersion1 = new org.entur.gbfs.v3_0_RC.gbfs_versions.GBFSVersion();
        gBFSVersion1.setVersion(this.versionToVersion(gBFSVersion.getVersion(), language));
        gBFSVersion1.setUrl(gBFSVersion.getUrl());
        if (gBFSVersion1.getAdditionalProperties() != null && (map = gBFSVersion.getAdditionalProperties()) != null) {
            gBFSVersion1.getAdditionalProperties().putAll(map);
        }
        return gBFSVersion1;
    }

    protected List<org.entur.gbfs.v3_0_RC.gbfs_versions.GBFSVersion> gBFSVersionListToGBFSVersionList(List<GBFSVersion> list, String language) {
        if (list == null) {
            return null;
        }
        ArrayList<org.entur.gbfs.v3_0_RC.gbfs_versions.GBFSVersion> list1 = new ArrayList<org.entur.gbfs.v3_0_RC.gbfs_versions.GBFSVersion>(list.size());
        for (GBFSVersion gBFSVersion : list) {
            list1.add(this.gBFSVersionToGBFSVersion(gBFSVersion, language));
        }
        return list1;
    }

    protected org.entur.gbfs.v3_0_RC.gbfs_versions.GBFSData gBFSDataToGBFSData(org.entur.gbfs.v2_3.gbfs_versions.GBFSData gBFSData, String language) {
        if (gBFSData == null) {
            return null;
        }
        org.entur.gbfs.v3_0_RC.gbfs_versions.GBFSData gBFSData1 = new org.entur.gbfs.v3_0_RC.gbfs_versions.GBFSData();
        gBFSData1.setVersions(this.gBFSVersionListToGBFSVersionList(gBFSData.getVersions(), language));
        return gBFSData1;
    }

    protected GBFSVersion.Version versionToVersion1(GBFSVersion.Version version, String language) {
        GBFSVersion.Version version1;
        if (version == null) {
            return null;
        }
        switch (version) {
            case _1_0: {
                version1 = GBFSVersion.Version._1_0;
                break;
            }
            case _1_1: {
                version1 = GBFSVersion.Version._1_1;
                break;
            }
            case _2_0: {
                version1 = GBFSVersion.Version._2_0;
                break;
            }
            case _2_1: {
                version1 = GBFSVersion.Version._2_1;
                break;
            }
            case _2_2: {
                version1 = GBFSVersion.Version._2_2;
                break;
            }
            case _2_3: {
                version1 = GBFSVersion.Version._2_3;
                break;
            }
            case _3_0_RC: {
                version1 = GBFSVersion.Version._3_0_RC;
                break;
            }
            case _3_0: {
                version1 = GBFSVersion.Version._3_0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + version);
            }
        }
        return version1;
    }

    protected GBFSVersion gBFSVersionToGBFSVersion1(org.entur.gbfs.v3_0_RC.gbfs_versions.GBFSVersion gBFSVersion, String language) {
        Map map;
        if (gBFSVersion == null) {
            return null;
        }
        GBFSVersion gBFSVersion1 = new GBFSVersion();
        gBFSVersion1.setVersion(this.versionToVersion1(gBFSVersion.getVersion(), language));
        gBFSVersion1.setUrl(gBFSVersion.getUrl());
        if (gBFSVersion1.getAdditionalProperties() != null && (map = gBFSVersion.getAdditionalProperties()) != null) {
            gBFSVersion1.getAdditionalProperties().putAll(map);
        }
        return gBFSVersion1;
    }

    protected List<GBFSVersion> gBFSVersionListToGBFSVersionList1(List<org.entur.gbfs.v3_0_RC.gbfs_versions.GBFSVersion> list, String language) {
        if (list == null) {
            return null;
        }
        ArrayList<GBFSVersion> list1 = new ArrayList<GBFSVersion>(list.size());
        for (org.entur.gbfs.v3_0_RC.gbfs_versions.GBFSVersion gBFSVersion : list) {
            list1.add(this.gBFSVersionToGBFSVersion1(gBFSVersion, language));
        }
        return list1;
    }

    protected org.entur.gbfs.v2_3.gbfs_versions.GBFSData gBFSDataToGBFSData1(org.entur.gbfs.v3_0_RC.gbfs_versions.GBFSData gBFSData, String language) {
        if (gBFSData == null) {
            return null;
        }
        org.entur.gbfs.v2_3.gbfs_versions.GBFSData gBFSData1 = new org.entur.gbfs.v2_3.gbfs_versions.GBFSData();
        gBFSData1.setVersions(this.gBFSVersionListToGBFSVersionList1(gBFSData.getVersions(), language));
        return gBFSData1;
    }

    protected GBFSVehicleType.FormFactor formFactorToFormFactor(GBFSVehicleType.FormFactor formFactor, String language) {
        GBFSVehicleType.FormFactor formFactor1;
        if (formFactor == null) {
            return null;
        }
        switch (formFactor) {
            case BICYCLE: {
                formFactor1 = GBFSVehicleType.FormFactor.BICYCLE;
                break;
            }
            case CARGO_BICYCLE: {
                formFactor1 = GBFSVehicleType.FormFactor.CARGO_BICYCLE;
                break;
            }
            case CAR: {
                formFactor1 = GBFSVehicleType.FormFactor.CAR;
                break;
            }
            case MOPED: {
                formFactor1 = GBFSVehicleType.FormFactor.MOPED;
                break;
            }
            case SCOOTER_STANDING: {
                formFactor1 = GBFSVehicleType.FormFactor.SCOOTER_STANDING;
                break;
            }
            case SCOOTER_SEATED: {
                formFactor1 = GBFSVehicleType.FormFactor.SCOOTER_SEATED;
                break;
            }
            case OTHER: {
                formFactor1 = GBFSVehicleType.FormFactor.OTHER;
                break;
            }
            case SCOOTER: {
                formFactor1 = GBFSVehicleType.FormFactor.SCOOTER;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + formFactor);
            }
        }
        return formFactor1;
    }

    protected GBFSVehicleType.PropulsionType propulsionTypeToPropulsionType(GBFSVehicleType.PropulsionType propulsionType, String language) {
        GBFSVehicleType.PropulsionType propulsionType1;
        if (propulsionType == null) {
            return null;
        }
        switch (propulsionType) {
            case HUMAN: {
                propulsionType1 = GBFSVehicleType.PropulsionType.HUMAN;
                break;
            }
            case ELECTRIC_ASSIST: {
                propulsionType1 = GBFSVehicleType.PropulsionType.ELECTRIC_ASSIST;
                break;
            }
            case ELECTRIC: {
                propulsionType1 = GBFSVehicleType.PropulsionType.ELECTRIC;
                break;
            }
            case COMBUSTION: {
                propulsionType1 = GBFSVehicleType.PropulsionType.COMBUSTION;
                break;
            }
            case COMBUSTION_DIESEL: {
                propulsionType1 = GBFSVehicleType.PropulsionType.COMBUSTION_DIESEL;
                break;
            }
            case HYBRID: {
                propulsionType1 = GBFSVehicleType.PropulsionType.HYBRID;
                break;
            }
            case PLUG_IN_HYBRID: {
                propulsionType1 = GBFSVehicleType.PropulsionType.PLUG_IN_HYBRID;
                break;
            }
            case HYDROGEN_FUEL_CELL: {
                propulsionType1 = GBFSVehicleType.PropulsionType.HYDROGEN_FUEL_CELL;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + propulsionType);
            }
        }
        return propulsionType1;
    }

    protected GBFSEcoLabel gBFSEcoLabelToGBFSEcoLabel(org.entur.gbfs.v2_3.vehicle_types.GBFSEcoLabel gBFSEcoLabel, String language) {
        Map map;
        if (gBFSEcoLabel == null) {
            return null;
        }
        GBFSEcoLabel gBFSEcoLabel1 = new GBFSEcoLabel();
        gBFSEcoLabel1.setCountryCode(gBFSEcoLabel.getCountryCode());
        gBFSEcoLabel1.setEcoSticker(gBFSEcoLabel.getEcoSticker());
        if (gBFSEcoLabel1.getAdditionalProperties() != null && (map = gBFSEcoLabel.getAdditionalProperties()) != null) {
            gBFSEcoLabel1.getAdditionalProperties().putAll(map);
        }
        return gBFSEcoLabel1;
    }

    protected List<GBFSEcoLabel> gBFSEcoLabelListToGBFSEcoLabelList(List<org.entur.gbfs.v2_3.vehicle_types.GBFSEcoLabel> list, String language) {
        if (list == null) {
            return null;
        }
        ArrayList<GBFSEcoLabel> list1 = new ArrayList<GBFSEcoLabel>(list.size());
        for (org.entur.gbfs.v2_3.vehicle_types.GBFSEcoLabel gBFSEcoLabel : list) {
            list1.add(this.gBFSEcoLabelToGBFSEcoLabel(gBFSEcoLabel, language));
        }
        return list1;
    }

    protected org.entur.gbfs.v3_0_RC.vehicle_types.VehicleAccessory vehicleAccessoryToVehicleAccessory(VehicleAccessory vehicleAccessory, String language) {
        org.entur.gbfs.v3_0_RC.vehicle_types.VehicleAccessory vehicleAccessory1;
        if (vehicleAccessory == null) {
            return null;
        }
        switch (vehicleAccessory) {
            case AIR_CONDITIONING: {
                vehicleAccessory1 = org.entur.gbfs.v3_0_RC.vehicle_types.VehicleAccessory.AIR_CONDITIONING;
                break;
            }
            case AUTOMATIC: {
                vehicleAccessory1 = org.entur.gbfs.v3_0_RC.vehicle_types.VehicleAccessory.AUTOMATIC;
                break;
            }
            case MANUAL: {
                vehicleAccessory1 = org.entur.gbfs.v3_0_RC.vehicle_types.VehicleAccessory.MANUAL;
                break;
            }
            case CONVERTIBLE: {
                vehicleAccessory1 = org.entur.gbfs.v3_0_RC.vehicle_types.VehicleAccessory.CONVERTIBLE;
                break;
            }
            case CRUISE_CONTROL: {
                vehicleAccessory1 = org.entur.gbfs.v3_0_RC.vehicle_types.VehicleAccessory.CRUISE_CONTROL;
                break;
            }
            case DOORS_2: {
                vehicleAccessory1 = org.entur.gbfs.v3_0_RC.vehicle_types.VehicleAccessory.DOORS_2;
                break;
            }
            case DOORS_3: {
                vehicleAccessory1 = org.entur.gbfs.v3_0_RC.vehicle_types.VehicleAccessory.DOORS_3;
                break;
            }
            case DOORS_4: {
                vehicleAccessory1 = org.entur.gbfs.v3_0_RC.vehicle_types.VehicleAccessory.DOORS_4;
                break;
            }
            case DOORS_5: {
                vehicleAccessory1 = org.entur.gbfs.v3_0_RC.vehicle_types.VehicleAccessory.DOORS_5;
                break;
            }
            case NAVIGATION: {
                vehicleAccessory1 = org.entur.gbfs.v3_0_RC.vehicle_types.VehicleAccessory.NAVIGATION;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + vehicleAccessory);
            }
        }
        return vehicleAccessory1;
    }

    protected List<org.entur.gbfs.v3_0_RC.vehicle_types.VehicleAccessory> vehicleAccessoryListToVehicleAccessoryList(List<VehicleAccessory> list, String language) {
        if (list == null) {
            return null;
        }
        ArrayList<org.entur.gbfs.v3_0_RC.vehicle_types.VehicleAccessory> list1 = new ArrayList<org.entur.gbfs.v3_0_RC.vehicle_types.VehicleAccessory>(list.size());
        for (VehicleAccessory vehicleAccessory : list) {
            list1.add(this.vehicleAccessoryToVehicleAccessory(vehicleAccessory, language));
        }
        return list1;
    }

    protected GBFSVehicleType.ReturnConstraint returnConstraintToReturnConstraint(GBFSVehicleType.ReturnConstraint returnConstraint, String language) {
        GBFSVehicleType.ReturnConstraint returnConstraint1;
        if (returnConstraint == null) {
            return null;
        }
        switch (returnConstraint) {
            case FREE_FLOATING: {
                returnConstraint1 = GBFSVehicleType.ReturnConstraint.FREE_FLOATING;
                break;
            }
            case ROUNDTRIP_STATION: {
                returnConstraint1 = GBFSVehicleType.ReturnConstraint.ROUNDTRIP_STATION;
                break;
            }
            case ANY_STATION: {
                returnConstraint1 = GBFSVehicleType.ReturnConstraint.ANY_STATION;
                break;
            }
            case HYBRID: {
                returnConstraint1 = GBFSVehicleType.ReturnConstraint.HYBRID;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + returnConstraint);
            }
        }
        return returnConstraint1;
    }

    protected org.entur.gbfs.v3_0_RC.vehicle_types.GBFSVehicleAssets gBFSVehicleAssetsToGBFSVehicleAssets(GBFSVehicleAssets gBFSVehicleAssets, String language) {
        Map map;
        if (gBFSVehicleAssets == null) {
            return null;
        }
        org.entur.gbfs.v3_0_RC.vehicle_types.GBFSVehicleAssets gBFSVehicleAssets1 = new org.entur.gbfs.v3_0_RC.vehicle_types.GBFSVehicleAssets();
        gBFSVehicleAssets1.setIconUrl(gBFSVehicleAssets.getIconUrl());
        gBFSVehicleAssets1.setIconUrlDark(gBFSVehicleAssets.getIconUrlDark());
        gBFSVehicleAssets1.setIconLastModified(gBFSVehicleAssets.getIconLastModified());
        if (gBFSVehicleAssets1.getAdditionalProperties() != null && (map = gBFSVehicleAssets.getAdditionalProperties()) != null) {
            gBFSVehicleAssets1.getAdditionalProperties().putAll(map);
        }
        return gBFSVehicleAssets1;
    }

    protected org.entur.gbfs.v3_0_RC.vehicle_types.GBFSVehicleType gBFSVehicleTypeToGBFSVehicleType(GBFSVehicleType gBFSVehicleType, String language) {
        Map map;
        if (gBFSVehicleType == null) {
            return null;
        }
        org.entur.gbfs.v3_0_RC.vehicle_types.GBFSVehicleType gBFSVehicleType1 = new org.entur.gbfs.v3_0_RC.vehicle_types.GBFSVehicleType();
        gBFSVehicleType1.setVehicleTypeId(gBFSVehicleType.getVehicleTypeId());
        gBFSVehicleType1.setFormFactor(this.formFactorToFormFactor(gBFSVehicleType.getFormFactor(), language));
        gBFSVehicleType1.setRiderCapacity(gBFSVehicleType.getRiderCapacity());
        gBFSVehicleType1.setCargoVolumeCapacity(gBFSVehicleType.getCargoVolumeCapacity());
        gBFSVehicleType1.setCargoLoadCapacity(gBFSVehicleType.getCargoLoadCapacity());
        gBFSVehicleType1.setPropulsionType(this.propulsionTypeToPropulsionType(gBFSVehicleType.getPropulsionType(), language));
        gBFSVehicleType1.setEcoLabel(this.gBFSEcoLabelListToGBFSEcoLabelList(gBFSVehicleType.getEcoLabel(), language));
        gBFSVehicleType1.setMaxRangeMeters(gBFSVehicleType.getMaxRangeMeters());
        gBFSVehicleType1.setName(this.vehicleTypesAdditionalMapper.mapVehicleTypeName(gBFSVehicleType.getName(), language));
        gBFSVehicleType1.setVehicleAccessories(this.vehicleAccessoryListToVehicleAccessoryList(gBFSVehicleType.getVehicleAccessories(), language));
        gBFSVehicleType1.setgCO2Km(gBFSVehicleType.getgCO2Km());
        gBFSVehicleType1.setVehicleImage(gBFSVehicleType.getVehicleImage());
        gBFSVehicleType1.setMake(this.vehicleTypesAdditionalMapper.mapVehicleTypeMake(gBFSVehicleType.getMake(), language));
        gBFSVehicleType1.setModel(this.vehicleTypesAdditionalMapper.mapVehicleTypeModel(gBFSVehicleType.getModel(), language));
        gBFSVehicleType1.setColor(gBFSVehicleType.getColor());
        gBFSVehicleType1.setWheelCount(gBFSVehicleType.getWheelCount());
        gBFSVehicleType1.setMaxPermittedSpeed(gBFSVehicleType.getMaxPermittedSpeed());
        gBFSVehicleType1.setRatedPower(gBFSVehicleType.getRatedPower());
        gBFSVehicleType1.setDefaultReserveTime(gBFSVehicleType.getDefaultReserveTime());
        gBFSVehicleType1.setReturnConstraint(this.returnConstraintToReturnConstraint(gBFSVehicleType.getReturnConstraint(), language));
        gBFSVehicleType1.setVehicleAssets(this.gBFSVehicleAssetsToGBFSVehicleAssets(gBFSVehicleType.getVehicleAssets(), language));
        gBFSVehicleType1.setDefaultPricingPlanId(gBFSVehicleType.getDefaultPricingPlanId());
        List list5 = gBFSVehicleType.getPricingPlanIds();
        if (list5 != null) {
            gBFSVehicleType1.setPricingPlanIds(new ArrayList(list5));
        }
        if (gBFSVehicleType1.getAdditionalProperties() != null && (map = gBFSVehicleType.getAdditionalProperties()) != null) {
            gBFSVehicleType1.getAdditionalProperties().putAll(map);
        }
        return gBFSVehicleType1;
    }

    protected List<org.entur.gbfs.v3_0_RC.vehicle_types.GBFSVehicleType> gBFSVehicleTypeListToGBFSVehicleTypeList(List<GBFSVehicleType> list, String language) {
        if (list == null) {
            return null;
        }
        ArrayList<org.entur.gbfs.v3_0_RC.vehicle_types.GBFSVehicleType> list1 = new ArrayList<org.entur.gbfs.v3_0_RC.vehicle_types.GBFSVehicleType>(list.size());
        for (GBFSVehicleType gBFSVehicleType : list) {
            list1.add(this.gBFSVehicleTypeToGBFSVehicleType(gBFSVehicleType, language));
        }
        return list1;
    }

    protected org.entur.gbfs.v3_0_RC.vehicle_types.GBFSData gBFSDataToGBFSData2(org.entur.gbfs.v2_3.vehicle_types.GBFSData gBFSData, String language) {
        Map map;
        if (gBFSData == null) {
            return null;
        }
        org.entur.gbfs.v3_0_RC.vehicle_types.GBFSData gBFSData1 = new org.entur.gbfs.v3_0_RC.vehicle_types.GBFSData();
        gBFSData1.setVehicleTypes(this.gBFSVehicleTypeListToGBFSVehicleTypeList(gBFSData.getVehicleTypes(), language));
        if (gBFSData1.getAdditionalProperties() != null && (map = gBFSData.getAdditionalProperties()) != null) {
            gBFSData1.getAdditionalProperties().putAll(map);
        }
        return gBFSData1;
    }

    protected GBFSVehicleType.FormFactor formFactorToFormFactor1(GBFSVehicleType.FormFactor formFactor, String language) {
        GBFSVehicleType.FormFactor formFactor1;
        if (formFactor == null) {
            return null;
        }
        switch (formFactor) {
            case BICYCLE: {
                formFactor1 = GBFSVehicleType.FormFactor.BICYCLE;
                break;
            }
            case CARGO_BICYCLE: {
                formFactor1 = GBFSVehicleType.FormFactor.CARGO_BICYCLE;
                break;
            }
            case CAR: {
                formFactor1 = GBFSVehicleType.FormFactor.CAR;
                break;
            }
            case MOPED: {
                formFactor1 = GBFSVehicleType.FormFactor.MOPED;
                break;
            }
            case SCOOTER_STANDING: {
                formFactor1 = GBFSVehicleType.FormFactor.SCOOTER_STANDING;
                break;
            }
            case SCOOTER_SEATED: {
                formFactor1 = GBFSVehicleType.FormFactor.SCOOTER_SEATED;
                break;
            }
            case OTHER: {
                formFactor1 = GBFSVehicleType.FormFactor.OTHER;
                break;
            }
            case SCOOTER: {
                formFactor1 = GBFSVehicleType.FormFactor.SCOOTER;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + formFactor);
            }
        }
        return formFactor1;
    }

    protected GBFSVehicleType.PropulsionType propulsionTypeToPropulsionType1(GBFSVehicleType.PropulsionType propulsionType, String language) {
        GBFSVehicleType.PropulsionType propulsionType1;
        if (propulsionType == null) {
            return null;
        }
        switch (propulsionType) {
            case HUMAN: {
                propulsionType1 = GBFSVehicleType.PropulsionType.HUMAN;
                break;
            }
            case ELECTRIC_ASSIST: {
                propulsionType1 = GBFSVehicleType.PropulsionType.ELECTRIC_ASSIST;
                break;
            }
            case ELECTRIC: {
                propulsionType1 = GBFSVehicleType.PropulsionType.ELECTRIC;
                break;
            }
            case COMBUSTION: {
                propulsionType1 = GBFSVehicleType.PropulsionType.COMBUSTION;
                break;
            }
            case COMBUSTION_DIESEL: {
                propulsionType1 = GBFSVehicleType.PropulsionType.COMBUSTION_DIESEL;
                break;
            }
            case HYBRID: {
                propulsionType1 = GBFSVehicleType.PropulsionType.HYBRID;
                break;
            }
            case PLUG_IN_HYBRID: {
                propulsionType1 = GBFSVehicleType.PropulsionType.PLUG_IN_HYBRID;
                break;
            }
            case HYDROGEN_FUEL_CELL: {
                propulsionType1 = GBFSVehicleType.PropulsionType.HYDROGEN_FUEL_CELL;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + propulsionType);
            }
        }
        return propulsionType1;
    }

    protected org.entur.gbfs.v2_3.vehicle_types.GBFSEcoLabel gBFSEcoLabelToGBFSEcoLabel1(GBFSEcoLabel gBFSEcoLabel, String language) {
        Map map;
        if (gBFSEcoLabel == null) {
            return null;
        }
        org.entur.gbfs.v2_3.vehicle_types.GBFSEcoLabel gBFSEcoLabel1 = new org.entur.gbfs.v2_3.vehicle_types.GBFSEcoLabel();
        gBFSEcoLabel1.setCountryCode(gBFSEcoLabel.getCountryCode());
        gBFSEcoLabel1.setEcoSticker(gBFSEcoLabel.getEcoSticker());
        if (gBFSEcoLabel1.getAdditionalProperties() != null && (map = gBFSEcoLabel.getAdditionalProperties()) != null) {
            gBFSEcoLabel1.getAdditionalProperties().putAll(map);
        }
        return gBFSEcoLabel1;
    }

    protected List<org.entur.gbfs.v2_3.vehicle_types.GBFSEcoLabel> gBFSEcoLabelListToGBFSEcoLabelList1(List<GBFSEcoLabel> list, String language) {
        if (list == null) {
            return null;
        }
        ArrayList<org.entur.gbfs.v2_3.vehicle_types.GBFSEcoLabel> list1 = new ArrayList<org.entur.gbfs.v2_3.vehicle_types.GBFSEcoLabel>(list.size());
        for (GBFSEcoLabel gBFSEcoLabel : list) {
            list1.add(this.gBFSEcoLabelToGBFSEcoLabel1(gBFSEcoLabel, language));
        }
        return list1;
    }

    protected VehicleAccessory vehicleAccessoryToVehicleAccessory1(org.entur.gbfs.v3_0_RC.vehicle_types.VehicleAccessory vehicleAccessory, String language) {
        VehicleAccessory vehicleAccessory1;
        if (vehicleAccessory == null) {
            return null;
        }
        switch (vehicleAccessory) {
            case AIR_CONDITIONING: {
                vehicleAccessory1 = VehicleAccessory.AIR_CONDITIONING;
                break;
            }
            case AUTOMATIC: {
                vehicleAccessory1 = VehicleAccessory.AUTOMATIC;
                break;
            }
            case MANUAL: {
                vehicleAccessory1 = VehicleAccessory.MANUAL;
                break;
            }
            case CONVERTIBLE: {
                vehicleAccessory1 = VehicleAccessory.CONVERTIBLE;
                break;
            }
            case CRUISE_CONTROL: {
                vehicleAccessory1 = VehicleAccessory.CRUISE_CONTROL;
                break;
            }
            case DOORS_2: {
                vehicleAccessory1 = VehicleAccessory.DOORS_2;
                break;
            }
            case DOORS_3: {
                vehicleAccessory1 = VehicleAccessory.DOORS_3;
                break;
            }
            case DOORS_4: {
                vehicleAccessory1 = VehicleAccessory.DOORS_4;
                break;
            }
            case DOORS_5: {
                vehicleAccessory1 = VehicleAccessory.DOORS_5;
                break;
            }
            case NAVIGATION: {
                vehicleAccessory1 = VehicleAccessory.NAVIGATION;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + vehicleAccessory);
            }
        }
        return vehicleAccessory1;
    }

    protected List<VehicleAccessory> vehicleAccessoryListToVehicleAccessoryList1(List<org.entur.gbfs.v3_0_RC.vehicle_types.VehicleAccessory> list, String language) {
        if (list == null) {
            return null;
        }
        ArrayList<VehicleAccessory> list1 = new ArrayList<VehicleAccessory>(list.size());
        for (org.entur.gbfs.v3_0_RC.vehicle_types.VehicleAccessory vehicleAccessory : list) {
            list1.add(this.vehicleAccessoryToVehicleAccessory1(vehicleAccessory, language));
        }
        return list1;
    }

    protected GBFSVehicleType.ReturnConstraint returnConstraintToReturnConstraint1(GBFSVehicleType.ReturnConstraint returnConstraint, String language) {
        GBFSVehicleType.ReturnConstraint returnConstraint1;
        if (returnConstraint == null) {
            return null;
        }
        switch (returnConstraint) {
            case FREE_FLOATING: {
                returnConstraint1 = GBFSVehicleType.ReturnConstraint.FREE_FLOATING;
                break;
            }
            case ROUNDTRIP_STATION: {
                returnConstraint1 = GBFSVehicleType.ReturnConstraint.ROUNDTRIP_STATION;
                break;
            }
            case ANY_STATION: {
                returnConstraint1 = GBFSVehicleType.ReturnConstraint.ANY_STATION;
                break;
            }
            case HYBRID: {
                returnConstraint1 = GBFSVehicleType.ReturnConstraint.HYBRID;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + returnConstraint);
            }
        }
        return returnConstraint1;
    }

    protected GBFSVehicleAssets gBFSVehicleAssetsToGBFSVehicleAssets1(org.entur.gbfs.v3_0_RC.vehicle_types.GBFSVehicleAssets gBFSVehicleAssets, String language) {
        Map map;
        if (gBFSVehicleAssets == null) {
            return null;
        }
        GBFSVehicleAssets gBFSVehicleAssets1 = new GBFSVehicleAssets();
        gBFSVehicleAssets1.setIconUrl(gBFSVehicleAssets.getIconUrl());
        gBFSVehicleAssets1.setIconUrlDark(gBFSVehicleAssets.getIconUrlDark());
        gBFSVehicleAssets1.setIconLastModified(gBFSVehicleAssets.getIconLastModified());
        if (gBFSVehicleAssets1.getAdditionalProperties() != null && (map = gBFSVehicleAssets.getAdditionalProperties()) != null) {
            gBFSVehicleAssets1.getAdditionalProperties().putAll(map);
        }
        return gBFSVehicleAssets1;
    }

    protected GBFSVehicleType gBFSVehicleTypeToGBFSVehicleType1(org.entur.gbfs.v3_0_RC.vehicle_types.GBFSVehicleType gBFSVehicleType, String language) {
        Map map;
        if (gBFSVehicleType == null) {
            return null;
        }
        GBFSVehicleType gBFSVehicleType1 = new GBFSVehicleType();
        gBFSVehicleType1.setVehicleTypeId(gBFSVehicleType.getVehicleTypeId());
        gBFSVehicleType1.setFormFactor(this.formFactorToFormFactor1(gBFSVehicleType.getFormFactor(), language));
        gBFSVehicleType1.setRiderCapacity(gBFSVehicleType.getRiderCapacity());
        gBFSVehicleType1.setCargoVolumeCapacity(gBFSVehicleType.getCargoVolumeCapacity());
        gBFSVehicleType1.setCargoLoadCapacity(gBFSVehicleType.getCargoLoadCapacity());
        gBFSVehicleType1.setPropulsionType(this.propulsionTypeToPropulsionType1(gBFSVehicleType.getPropulsionType(), language));
        gBFSVehicleType1.setEcoLabel(this.gBFSEcoLabelListToGBFSEcoLabelList1(gBFSVehicleType.getEcoLabel(), language));
        gBFSVehicleType1.setMaxRangeMeters(gBFSVehicleType.getMaxRangeMeters());
        gBFSVehicleType1.setName(this.vehicleTypesAdditionalMapper.mapVehicleTypeNameInverse(gBFSVehicleType.getName(), language));
        gBFSVehicleType1.setVehicleAccessories(this.vehicleAccessoryListToVehicleAccessoryList1(gBFSVehicleType.getVehicleAccessories(), language));
        gBFSVehicleType1.setgCO2Km(gBFSVehicleType.getgCO2Km());
        gBFSVehicleType1.setVehicleImage(gBFSVehicleType.getVehicleImage());
        gBFSVehicleType1.setMake(this.vehicleTypesAdditionalMapper.mapVehicleTypeMakeInverse(gBFSVehicleType.getMake(), language));
        gBFSVehicleType1.setModel(this.vehicleTypesAdditionalMapper.mapVehicleTypeModelInverse(gBFSVehicleType.getModel(), language));
        gBFSVehicleType1.setColor(gBFSVehicleType.getColor());
        gBFSVehicleType1.setWheelCount(gBFSVehicleType.getWheelCount());
        gBFSVehicleType1.setMaxPermittedSpeed(gBFSVehicleType.getMaxPermittedSpeed());
        gBFSVehicleType1.setRatedPower(gBFSVehicleType.getRatedPower());
        gBFSVehicleType1.setDefaultReserveTime(gBFSVehicleType.getDefaultReserveTime());
        gBFSVehicleType1.setReturnConstraint(this.returnConstraintToReturnConstraint1(gBFSVehicleType.getReturnConstraint(), language));
        gBFSVehicleType1.setVehicleAssets(this.gBFSVehicleAssetsToGBFSVehicleAssets1(gBFSVehicleType.getVehicleAssets(), language));
        gBFSVehicleType1.setDefaultPricingPlanId(gBFSVehicleType.getDefaultPricingPlanId());
        List list2 = gBFSVehicleType.getPricingPlanIds();
        if (list2 != null) {
            gBFSVehicleType1.setPricingPlanIds(new ArrayList(list2));
        }
        if (gBFSVehicleType1.getAdditionalProperties() != null && (map = gBFSVehicleType.getAdditionalProperties()) != null) {
            gBFSVehicleType1.getAdditionalProperties().putAll(map);
        }
        return gBFSVehicleType1;
    }

    protected List<GBFSVehicleType> gBFSVehicleTypeListToGBFSVehicleTypeList1(List<org.entur.gbfs.v3_0_RC.vehicle_types.GBFSVehicleType> list, String language) {
        if (list == null) {
            return null;
        }
        ArrayList<GBFSVehicleType> list1 = new ArrayList<GBFSVehicleType>(list.size());
        for (org.entur.gbfs.v3_0_RC.vehicle_types.GBFSVehicleType gBFSVehicleType : list) {
            list1.add(this.gBFSVehicleTypeToGBFSVehicleType1(gBFSVehicleType, language));
        }
        return list1;
    }

    protected org.entur.gbfs.v2_3.vehicle_types.GBFSData gBFSDataToGBFSData3(org.entur.gbfs.v3_0_RC.vehicle_types.GBFSData gBFSData, String language) {
        Map map;
        if (gBFSData == null) {
            return null;
        }
        org.entur.gbfs.v2_3.vehicle_types.GBFSData gBFSData1 = new org.entur.gbfs.v2_3.vehicle_types.GBFSData();
        gBFSData1.setVehicleTypes(this.gBFSVehicleTypeListToGBFSVehicleTypeList1(gBFSData.getVehicleTypes(), language));
        if (gBFSData1.getAdditionalProperties() != null && (map = gBFSData.getAdditionalProperties()) != null) {
            gBFSData1.getAdditionalProperties().putAll(map);
        }
        return gBFSData1;
    }

    protected List<org.entur.gbfs.v3_0_RC.station_information.GBFSStation> gBFSStationListToGBFSStationList(List<org.entur.gbfs.v2_3.station_information.GBFSStation> list, String language) {
        if (list == null) {
            return null;
        }
        ArrayList<org.entur.gbfs.v3_0_RC.station_information.GBFSStation> list1 = new ArrayList<org.entur.gbfs.v3_0_RC.station_information.GBFSStation>(list.size());
        for (org.entur.gbfs.v2_3.station_information.GBFSStation gBFSStation : list) {
            list1.add(this.stationInformationAdditionalMapper.mapStation(gBFSStation, language));
        }
        return list1;
    }

    protected org.entur.gbfs.v3_0_RC.station_information.GBFSData gBFSDataToGBFSData4(org.entur.gbfs.v2_3.station_information.GBFSData gBFSData, String language) {
        Map map;
        if (gBFSData == null) {
            return null;
        }
        org.entur.gbfs.v3_0_RC.station_information.GBFSData gBFSData1 = new org.entur.gbfs.v3_0_RC.station_information.GBFSData();
        gBFSData1.setStations(this.gBFSStationListToGBFSStationList(gBFSData.getStations(), language));
        if (gBFSData1.getAdditionalProperties() != null && (map = gBFSData.getAdditionalProperties()) != null) {
            gBFSData1.getAdditionalProperties().putAll(map);
        }
        return gBFSData1;
    }

    protected List<org.entur.gbfs.v2_3.station_information.GBFSStation> gBFSStationListToGBFSStationList1(List<org.entur.gbfs.v3_0_RC.station_information.GBFSStation> list, String language) {
        if (list == null) {
            return null;
        }
        ArrayList<org.entur.gbfs.v2_3.station_information.GBFSStation> list1 = new ArrayList<org.entur.gbfs.v2_3.station_information.GBFSStation>(list.size());
        for (org.entur.gbfs.v3_0_RC.station_information.GBFSStation gBFSStation : list) {
            list1.add(this.stationInformationAdditionalMapper.mapStationInverse(gBFSStation, language));
        }
        return list1;
    }

    protected org.entur.gbfs.v2_3.station_information.GBFSData gBFSDataToGBFSData5(org.entur.gbfs.v3_0_RC.station_information.GBFSData gBFSData, String language) {
        Map map;
        if (gBFSData == null) {
            return null;
        }
        org.entur.gbfs.v2_3.station_information.GBFSData gBFSData1 = new org.entur.gbfs.v2_3.station_information.GBFSData();
        gBFSData1.setStations(this.gBFSStationListToGBFSStationList1(gBFSData.getStations(), language));
        if (gBFSData1.getAdditionalProperties() != null && (map = gBFSData.getAdditionalProperties()) != null) {
            gBFSData1.getAdditionalProperties().putAll(map);
        }
        return gBFSData1;
    }

    protected List<GBFSStation> gBFSStationListToGBFSStationList2(List<org.entur.gbfs.v2_3.station_status.GBFSStation> list, String language) {
        if (list == null) {
            return null;
        }
        ArrayList<GBFSStation> list1 = new ArrayList<GBFSStation>(list.size());
        for (org.entur.gbfs.v2_3.station_status.GBFSStation gBFSStation : list) {
            list1.add(this.stationStatusAdditionalMapper.mapStation(gBFSStation));
        }
        return list1;
    }

    protected GBFSData gBFSDataToGBFSData6(org.entur.gbfs.v2_3.station_status.GBFSData gBFSData, String language) {
        Map map;
        if (gBFSData == null) {
            return null;
        }
        GBFSData gBFSData1 = new GBFSData();
        gBFSData1.setStations(this.gBFSStationListToGBFSStationList2(gBFSData.getStations(), language));
        if (gBFSData1.getAdditionalProperties() != null && (map = gBFSData.getAdditionalProperties()) != null) {
            gBFSData1.getAdditionalProperties().putAll(map);
        }
        return gBFSData1;
    }

    protected List<org.entur.gbfs.v2_3.station_status.GBFSStation> gBFSStationListToGBFSStationList3(List<GBFSStation> list, String language) {
        if (list == null) {
            return null;
        }
        ArrayList<org.entur.gbfs.v2_3.station_status.GBFSStation> list1 = new ArrayList<org.entur.gbfs.v2_3.station_status.GBFSStation>(list.size());
        for (GBFSStation gBFSStation : list) {
            list1.add(this.stationStatusAdditionalMapper.mapStationInverse(gBFSStation));
        }
        return list1;
    }

    protected org.entur.gbfs.v2_3.station_status.GBFSData gBFSDataToGBFSData7(GBFSData gBFSData, String language) {
        Map map;
        if (gBFSData == null) {
            return null;
        }
        org.entur.gbfs.v2_3.station_status.GBFSData gBFSData1 = new org.entur.gbfs.v2_3.station_status.GBFSData();
        gBFSData1.setStations(this.gBFSStationListToGBFSStationList3(gBFSData.getStations(), language));
        if (gBFSData1.getAdditionalProperties() != null && (map = gBFSData.getAdditionalProperties()) != null) {
            gBFSData1.getAdditionalProperties().putAll(map);
        }
        return gBFSData1;
    }

    protected org.entur.gbfs.v3_0_RC.system_pricing_plans.GBFSPerKmPricing gBFSPerKmPricingToGBFSPerKmPricing(GBFSPerKmPricing gBFSPerKmPricing, String language) {
        Map map;
        if (gBFSPerKmPricing == null) {
            return null;
        }
        org.entur.gbfs.v3_0_RC.system_pricing_plans.GBFSPerKmPricing gBFSPerKmPricing1 = new org.entur.gbfs.v3_0_RC.system_pricing_plans.GBFSPerKmPricing();
        gBFSPerKmPricing1.setStart(gBFSPerKmPricing.getStart());
        gBFSPerKmPricing1.setRate(gBFSPerKmPricing.getRate());
        gBFSPerKmPricing1.setInterval(gBFSPerKmPricing.getInterval());
        gBFSPerKmPricing1.setEnd(gBFSPerKmPricing.getEnd());
        if (gBFSPerKmPricing1.getAdditionalProperties() != null && (map = gBFSPerKmPricing.getAdditionalProperties()) != null) {
            gBFSPerKmPricing1.getAdditionalProperties().putAll(map);
        }
        return gBFSPerKmPricing1;
    }

    protected List<org.entur.gbfs.v3_0_RC.system_pricing_plans.GBFSPerKmPricing> gBFSPerKmPricingListToGBFSPerKmPricingList(List<GBFSPerKmPricing> list, String language) {
        if (list == null) {
            return null;
        }
        ArrayList<org.entur.gbfs.v3_0_RC.system_pricing_plans.GBFSPerKmPricing> list1 = new ArrayList<org.entur.gbfs.v3_0_RC.system_pricing_plans.GBFSPerKmPricing>(list.size());
        for (GBFSPerKmPricing gBFSPerKmPricing : list) {
            list1.add(this.gBFSPerKmPricingToGBFSPerKmPricing(gBFSPerKmPricing, language));
        }
        return list1;
    }

    protected GBFSPerMinPricing gBFSPerMinPricingToGBFSPerMinPricing(org.entur.gbfs.v2_3.system_pricing_plans.GBFSPerMinPricing gBFSPerMinPricing, String language) {
        Map map;
        if (gBFSPerMinPricing == null) {
            return null;
        }
        GBFSPerMinPricing gBFSPerMinPricing1 = new GBFSPerMinPricing();
        gBFSPerMinPricing1.setStart(gBFSPerMinPricing.getStart());
        gBFSPerMinPricing1.setRate(gBFSPerMinPricing.getRate());
        gBFSPerMinPricing1.setInterval(gBFSPerMinPricing.getInterval());
        gBFSPerMinPricing1.setEnd(gBFSPerMinPricing.getEnd());
        if (gBFSPerMinPricing1.getAdditionalProperties() != null && (map = gBFSPerMinPricing.getAdditionalProperties()) != null) {
            gBFSPerMinPricing1.getAdditionalProperties().putAll(map);
        }
        return gBFSPerMinPricing1;
    }

    protected List<GBFSPerMinPricing> gBFSPerMinPricingListToGBFSPerMinPricingList(List<org.entur.gbfs.v2_3.system_pricing_plans.GBFSPerMinPricing> list, String language) {
        if (list == null) {
            return null;
        }
        ArrayList<GBFSPerMinPricing> list1 = new ArrayList<GBFSPerMinPricing>(list.size());
        for (org.entur.gbfs.v2_3.system_pricing_plans.GBFSPerMinPricing gBFSPerMinPricing : list) {
            list1.add(this.gBFSPerMinPricingToGBFSPerMinPricing(gBFSPerMinPricing, language));
        }
        return list1;
    }

    protected GBFSPlan gBFSPlanToGBFSPlan(org.entur.gbfs.v2_3.system_pricing_plans.GBFSPlan gBFSPlan, String language) {
        Map map;
        if (gBFSPlan == null) {
            return null;
        }
        GBFSPlan gBFSPlan1 = new GBFSPlan();
        gBFSPlan1.setPlanId(gBFSPlan.getPlanId());
        gBFSPlan1.setUrl(gBFSPlan.getUrl());
        gBFSPlan1.setName(this.systemPricingPlansAdditionalMapper.mapName(gBFSPlan.getName(), language));
        gBFSPlan1.setCurrency(gBFSPlan.getCurrency());
        gBFSPlan1.setPrice(gBFSPlan.getPrice());
        gBFSPlan1.setIsTaxable(gBFSPlan.getIsTaxable());
        gBFSPlan1.setDescription(this.systemPricingPlansAdditionalMapper.mapDescription(gBFSPlan.getDescription(), language));
        gBFSPlan1.setPerKmPricing(this.gBFSPerKmPricingListToGBFSPerKmPricingList(gBFSPlan.getPerKmPricing(), language));
        gBFSPlan1.setPerMinPricing(this.gBFSPerMinPricingListToGBFSPerMinPricingList(gBFSPlan.getPerMinPricing(), language));
        gBFSPlan1.setSurgePricing(gBFSPlan.getSurgePricing());
        if (gBFSPlan1.getAdditionalProperties() != null && (map = gBFSPlan.getAdditionalProperties()) != null) {
            gBFSPlan1.getAdditionalProperties().putAll(map);
        }
        return gBFSPlan1;
    }

    protected List<GBFSPlan> gBFSPlanListToGBFSPlanList(List<org.entur.gbfs.v2_3.system_pricing_plans.GBFSPlan> list, String language) {
        if (list == null) {
            return null;
        }
        ArrayList<GBFSPlan> list1 = new ArrayList<GBFSPlan>(list.size());
        for (org.entur.gbfs.v2_3.system_pricing_plans.GBFSPlan gBFSPlan : list) {
            list1.add(this.gBFSPlanToGBFSPlan(gBFSPlan, language));
        }
        return list1;
    }

    protected org.entur.gbfs.v3_0_RC.system_pricing_plans.GBFSData gBFSDataToGBFSData8(org.entur.gbfs.v2_3.system_pricing_plans.GBFSData gBFSData, String language) {
        Map map;
        if (gBFSData == null) {
            return null;
        }
        org.entur.gbfs.v3_0_RC.system_pricing_plans.GBFSData gBFSData1 = new org.entur.gbfs.v3_0_RC.system_pricing_plans.GBFSData();
        gBFSData1.setPlans(this.gBFSPlanListToGBFSPlanList(gBFSData.getPlans(), language));
        if (gBFSData1.getAdditionalProperties() != null && (map = gBFSData.getAdditionalProperties()) != null) {
            gBFSData1.getAdditionalProperties().putAll(map);
        }
        return gBFSData1;
    }

    protected GBFSPerKmPricing gBFSPerKmPricingToGBFSPerKmPricing1(org.entur.gbfs.v3_0_RC.system_pricing_plans.GBFSPerKmPricing gBFSPerKmPricing, String language) {
        Map map;
        if (gBFSPerKmPricing == null) {
            return null;
        }
        GBFSPerKmPricing gBFSPerKmPricing1 = new GBFSPerKmPricing();
        gBFSPerKmPricing1.setStart(gBFSPerKmPricing.getStart());
        gBFSPerKmPricing1.setRate(gBFSPerKmPricing.getRate());
        gBFSPerKmPricing1.setInterval(gBFSPerKmPricing.getInterval());
        gBFSPerKmPricing1.setEnd(gBFSPerKmPricing.getEnd());
        if (gBFSPerKmPricing1.getAdditionalProperties() != null && (map = gBFSPerKmPricing.getAdditionalProperties()) != null) {
            gBFSPerKmPricing1.getAdditionalProperties().putAll(map);
        }
        return gBFSPerKmPricing1;
    }

    protected List<GBFSPerKmPricing> gBFSPerKmPricingListToGBFSPerKmPricingList1(List<org.entur.gbfs.v3_0_RC.system_pricing_plans.GBFSPerKmPricing> list, String language) {
        if (list == null) {
            return null;
        }
        ArrayList<GBFSPerKmPricing> list1 = new ArrayList<GBFSPerKmPricing>(list.size());
        for (org.entur.gbfs.v3_0_RC.system_pricing_plans.GBFSPerKmPricing gBFSPerKmPricing : list) {
            list1.add(this.gBFSPerKmPricingToGBFSPerKmPricing1(gBFSPerKmPricing, language));
        }
        return list1;
    }

    protected org.entur.gbfs.v2_3.system_pricing_plans.GBFSPerMinPricing gBFSPerMinPricingToGBFSPerMinPricing1(GBFSPerMinPricing gBFSPerMinPricing, String language) {
        Map map;
        if (gBFSPerMinPricing == null) {
            return null;
        }
        org.entur.gbfs.v2_3.system_pricing_plans.GBFSPerMinPricing gBFSPerMinPricing1 = new org.entur.gbfs.v2_3.system_pricing_plans.GBFSPerMinPricing();
        gBFSPerMinPricing1.setStart(gBFSPerMinPricing.getStart());
        gBFSPerMinPricing1.setRate(gBFSPerMinPricing.getRate());
        gBFSPerMinPricing1.setInterval(gBFSPerMinPricing.getInterval());
        gBFSPerMinPricing1.setEnd(gBFSPerMinPricing.getEnd());
        if (gBFSPerMinPricing1.getAdditionalProperties() != null && (map = gBFSPerMinPricing.getAdditionalProperties()) != null) {
            gBFSPerMinPricing1.getAdditionalProperties().putAll(map);
        }
        return gBFSPerMinPricing1;
    }

    protected List<org.entur.gbfs.v2_3.system_pricing_plans.GBFSPerMinPricing> gBFSPerMinPricingListToGBFSPerMinPricingList1(List<GBFSPerMinPricing> list, String language) {
        if (list == null) {
            return null;
        }
        ArrayList<org.entur.gbfs.v2_3.system_pricing_plans.GBFSPerMinPricing> list1 = new ArrayList<org.entur.gbfs.v2_3.system_pricing_plans.GBFSPerMinPricing>(list.size());
        for (GBFSPerMinPricing gBFSPerMinPricing : list) {
            list1.add(this.gBFSPerMinPricingToGBFSPerMinPricing1(gBFSPerMinPricing, language));
        }
        return list1;
    }

    protected org.entur.gbfs.v2_3.system_pricing_plans.GBFSPlan gBFSPlanToGBFSPlan1(GBFSPlan gBFSPlan, String language) {
        Map map;
        if (gBFSPlan == null) {
            return null;
        }
        org.entur.gbfs.v2_3.system_pricing_plans.GBFSPlan gBFSPlan1 = new org.entur.gbfs.v2_3.system_pricing_plans.GBFSPlan();
        gBFSPlan1.setPlanId(gBFSPlan.getPlanId());
        gBFSPlan1.setUrl(gBFSPlan.getUrl());
        gBFSPlan1.setName(this.systemPricingPlansAdditionalMapper.mapNameInverse(gBFSPlan.getName(), language));
        gBFSPlan1.setCurrency(gBFSPlan.getCurrency());
        gBFSPlan1.setPrice(gBFSPlan.getPrice());
        gBFSPlan1.setIsTaxable(gBFSPlan.getIsTaxable());
        gBFSPlan1.setDescription(this.systemPricingPlansAdditionalMapper.mapDescriptionInverse(gBFSPlan.getDescription(), language));
        gBFSPlan1.setPerKmPricing(this.gBFSPerKmPricingListToGBFSPerKmPricingList1(gBFSPlan.getPerKmPricing(), language));
        gBFSPlan1.setPerMinPricing(this.gBFSPerMinPricingListToGBFSPerMinPricingList1(gBFSPlan.getPerMinPricing(), language));
        gBFSPlan1.setSurgePricing(gBFSPlan.getSurgePricing());
        if (gBFSPlan1.getAdditionalProperties() != null && (map = gBFSPlan.getAdditionalProperties()) != null) {
            gBFSPlan1.getAdditionalProperties().putAll(map);
        }
        return gBFSPlan1;
    }

    protected List<org.entur.gbfs.v2_3.system_pricing_plans.GBFSPlan> gBFSPlanListToGBFSPlanList1(List<GBFSPlan> list, String language) {
        if (list == null) {
            return null;
        }
        ArrayList<org.entur.gbfs.v2_3.system_pricing_plans.GBFSPlan> list1 = new ArrayList<org.entur.gbfs.v2_3.system_pricing_plans.GBFSPlan>(list.size());
        for (GBFSPlan gBFSPlan : list) {
            list1.add(this.gBFSPlanToGBFSPlan1(gBFSPlan, language));
        }
        return list1;
    }

    protected org.entur.gbfs.v2_3.system_pricing_plans.GBFSData gBFSDataToGBFSData9(org.entur.gbfs.v3_0_RC.system_pricing_plans.GBFSData gBFSData, String language) {
        Map map;
        if (gBFSData == null) {
            return null;
        }
        org.entur.gbfs.v2_3.system_pricing_plans.GBFSData gBFSData1 = new org.entur.gbfs.v2_3.system_pricing_plans.GBFSData();
        gBFSData1.setPlans(this.gBFSPlanListToGBFSPlanList1(gBFSData.getPlans(), language));
        if (gBFSData1.getAdditionalProperties() != null && (map = gBFSData.getAdditionalProperties()) != null) {
            gBFSData1.getAdditionalProperties().putAll(map);
        }
        return gBFSData1;
    }

    protected GBFSGeofencingZones__1.Type typeToType(GBFSGeofencingZones__1.Type type, String language) {
        GBFSGeofencingZones__1.Type type1;
        if (type == null) {
            return null;
        }
        switch (type) {
            case FEATURE_COLLECTION: {
                type1 = GBFSGeofencingZones__1.Type.FEATURE_COLLECTION;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + type);
            }
        }
        return type1;
    }

    protected GBFSFeature.Type typeToType1(GBFSFeature.Type type, String language) {
        GBFSFeature.Type type1;
        if (type == null) {
            return null;
        }
        switch (type) {
            case FEATURE: {
                type1 = GBFSFeature.Type.FEATURE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + type);
            }
        }
        return type1;
    }

    protected List<GBFSRule> gBFSRuleListToGBFSRuleList(List<org.entur.gbfs.v2_3.geofencing_zones.GBFSRule> list, String language) {
        if (list == null) {
            return null;
        }
        ArrayList<GBFSRule> list1 = new ArrayList<GBFSRule>(list.size());
        for (org.entur.gbfs.v2_3.geofencing_zones.GBFSRule gBFSRule : list) {
            list1.add(this.geofencingZonesAdditionalMapper.mapRule(gBFSRule));
        }
        return list1;
    }

    protected org.entur.gbfs.v3_0_RC.geofencing_zones.GBFSProperties gBFSPropertiesToGBFSProperties(GBFSProperties gBFSProperties, String language) {
        Map map;
        if (gBFSProperties == null) {
            return null;
        }
        org.entur.gbfs.v3_0_RC.geofencing_zones.GBFSProperties gBFSProperties1 = new org.entur.gbfs.v3_0_RC.geofencing_zones.GBFSProperties();
        gBFSProperties1.setName(this.geofencingZonesAdditionalMapper.mapName(gBFSProperties.getName(), language));
        gBFSProperties1.setStart(gBFSProperties.getStart());
        gBFSProperties1.setEnd(gBFSProperties.getEnd());
        gBFSProperties1.setRules(this.gBFSRuleListToGBFSRuleList(gBFSProperties.getRules(), language));
        if (gBFSProperties1.getAdditionalProperties() != null && (map = gBFSProperties.getAdditionalProperties()) != null) {
            gBFSProperties1.getAdditionalProperties().putAll(map);
        }
        return gBFSProperties1;
    }

    protected GBFSFeature gBFSFeatureToGBFSFeature(org.entur.gbfs.v2_3.geofencing_zones.GBFSFeature gBFSFeature, String language) {
        Map map;
        if (gBFSFeature == null) {
            return null;
        }
        GBFSFeature gBFSFeature1 = new GBFSFeature();
        gBFSFeature1.setType(this.typeToType1(gBFSFeature.getType(), language));
        gBFSFeature1.setProperties(this.gBFSPropertiesToGBFSProperties(gBFSFeature.getProperties(), language));
        gBFSFeature1.setGeometry(gBFSFeature.getGeometry());
        if (gBFSFeature1.getAdditionalProperties() != null && (map = gBFSFeature.getAdditionalProperties()) != null) {
            gBFSFeature1.getAdditionalProperties().putAll(map);
        }
        return gBFSFeature1;
    }

    protected List<GBFSFeature> gBFSFeatureListToGBFSFeatureList(List<org.entur.gbfs.v2_3.geofencing_zones.GBFSFeature> list, String language) {
        if (list == null) {
            return null;
        }
        ArrayList<GBFSFeature> list1 = new ArrayList<GBFSFeature>(list.size());
        for (org.entur.gbfs.v2_3.geofencing_zones.GBFSFeature gBFSFeature : list) {
            list1.add(this.gBFSFeatureToGBFSFeature(gBFSFeature, language));
        }
        return list1;
    }

    protected GBFSGeofencingZones__1 gBFSGeofencingZones__1ToGBFSGeofencingZones__1(org.entur.gbfs.v2_3.geofencing_zones.GBFSGeofencingZones__1 gBFSGeofencingZones__1, String language) {
        Map map;
        if (gBFSGeofencingZones__1 == null) {
            return null;
        }
        GBFSGeofencingZones__1 gBFSGeofencingZones__1_1 = new GBFSGeofencingZones__1();
        gBFSGeofencingZones__1_1.setType(this.typeToType(gBFSGeofencingZones__1.getType(), language));
        gBFSGeofencingZones__1_1.setFeatures(this.gBFSFeatureListToGBFSFeatureList(gBFSGeofencingZones__1.getFeatures(), language));
        if (gBFSGeofencingZones__1_1.getAdditionalProperties() != null && (map = gBFSGeofencingZones__1.getAdditionalProperties()) != null) {
            gBFSGeofencingZones__1_1.getAdditionalProperties().putAll(map);
        }
        return gBFSGeofencingZones__1_1;
    }

    protected org.entur.gbfs.v3_0_RC.geofencing_zones.GBFSData gBFSDataToGBFSData10(org.entur.gbfs.v2_3.geofencing_zones.GBFSData gBFSData, String language) {
        Map map;
        if (gBFSData == null) {
            return null;
        }
        org.entur.gbfs.v3_0_RC.geofencing_zones.GBFSData gBFSData1 = new org.entur.gbfs.v3_0_RC.geofencing_zones.GBFSData();
        gBFSData1.setGeofencingZones(this.gBFSGeofencingZones__1ToGBFSGeofencingZones__1(gBFSData.getGeofencingZones(), language));
        if (gBFSData1.getAdditionalProperties() != null && (map = gBFSData.getAdditionalProperties()) != null) {
            gBFSData1.getAdditionalProperties().putAll(map);
        }
        return gBFSData1;
    }

    protected GBFSGeofencingZones__1.Type typeToType2(GBFSGeofencingZones__1.Type type, String language) {
        GBFSGeofencingZones__1.Type type1;
        if (type == null) {
            return null;
        }
        switch (type) {
            case FEATURE_COLLECTION: {
                type1 = GBFSGeofencingZones__1.Type.FEATURE_COLLECTION;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + type);
            }
        }
        return type1;
    }

    protected GBFSFeature.Type typeToType3(GBFSFeature.Type type, String language) {
        GBFSFeature.Type type1;
        if (type == null) {
            return null;
        }
        switch (type) {
            case FEATURE: {
                type1 = GBFSFeature.Type.FEATURE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + type);
            }
        }
        return type1;
    }

    protected List<org.entur.gbfs.v2_3.geofencing_zones.GBFSRule> gBFSRuleListToGBFSRuleList1(List<GBFSRule> list, String language) {
        if (list == null) {
            return null;
        }
        ArrayList<org.entur.gbfs.v2_3.geofencing_zones.GBFSRule> list1 = new ArrayList<org.entur.gbfs.v2_3.geofencing_zones.GBFSRule>(list.size());
        for (GBFSRule gBFSRule : list) {
            list1.add(this.geofencingZonesAdditionalMapper.mapRuleInverse(gBFSRule));
        }
        return list1;
    }

    protected GBFSProperties gBFSPropertiesToGBFSProperties1(org.entur.gbfs.v3_0_RC.geofencing_zones.GBFSProperties gBFSProperties, String language) {
        Map map;
        if (gBFSProperties == null) {
            return null;
        }
        GBFSProperties gBFSProperties1 = new GBFSProperties();
        gBFSProperties1.setName(this.geofencingZonesAdditionalMapper.mapNameInverse(gBFSProperties.getName(), language));
        gBFSProperties1.setStart(gBFSProperties.getStart());
        gBFSProperties1.setEnd(gBFSProperties.getEnd());
        gBFSProperties1.setRules(this.gBFSRuleListToGBFSRuleList1(gBFSProperties.getRules(), language));
        if (gBFSProperties1.getAdditionalProperties() != null && (map = gBFSProperties.getAdditionalProperties()) != null) {
            gBFSProperties1.getAdditionalProperties().putAll(map);
        }
        return gBFSProperties1;
    }

    protected org.entur.gbfs.v2_3.geofencing_zones.GBFSFeature gBFSFeatureToGBFSFeature1(GBFSFeature gBFSFeature, String language) {
        Map map;
        if (gBFSFeature == null) {
            return null;
        }
        org.entur.gbfs.v2_3.geofencing_zones.GBFSFeature gBFSFeature1 = new org.entur.gbfs.v2_3.geofencing_zones.GBFSFeature();
        gBFSFeature1.setType(this.typeToType3(gBFSFeature.getType(), language));
        gBFSFeature1.setProperties(this.gBFSPropertiesToGBFSProperties1(gBFSFeature.getProperties(), language));
        gBFSFeature1.setGeometry(gBFSFeature.getGeometry());
        if (gBFSFeature1.getAdditionalProperties() != null && (map = gBFSFeature.getAdditionalProperties()) != null) {
            gBFSFeature1.getAdditionalProperties().putAll(map);
        }
        return gBFSFeature1;
    }

    protected List<org.entur.gbfs.v2_3.geofencing_zones.GBFSFeature> gBFSFeatureListToGBFSFeatureList1(List<GBFSFeature> list, String language) {
        if (list == null) {
            return null;
        }
        ArrayList<org.entur.gbfs.v2_3.geofencing_zones.GBFSFeature> list1 = new ArrayList<org.entur.gbfs.v2_3.geofencing_zones.GBFSFeature>(list.size());
        for (GBFSFeature gBFSFeature : list) {
            list1.add(this.gBFSFeatureToGBFSFeature1(gBFSFeature, language));
        }
        return list1;
    }

    protected org.entur.gbfs.v2_3.geofencing_zones.GBFSGeofencingZones__1 gBFSGeofencingZones__1ToGBFSGeofencingZones__1_1(GBFSGeofencingZones__1 gBFSGeofencingZones__1, String language) {
        Map map;
        if (gBFSGeofencingZones__1 == null) {
            return null;
        }
        org.entur.gbfs.v2_3.geofencing_zones.GBFSGeofencingZones__1 gBFSGeofencingZones__1_1 = new org.entur.gbfs.v2_3.geofencing_zones.GBFSGeofencingZones__1();
        gBFSGeofencingZones__1_1.setType(this.typeToType2(gBFSGeofencingZones__1.getType(), language));
        gBFSGeofencingZones__1_1.setFeatures(this.gBFSFeatureListToGBFSFeatureList1(gBFSGeofencingZones__1.getFeatures(), language));
        if (gBFSGeofencingZones__1_1.getAdditionalProperties() != null && (map = gBFSGeofencingZones__1.getAdditionalProperties()) != null) {
            gBFSGeofencingZones__1_1.getAdditionalProperties().putAll(map);
        }
        return gBFSGeofencingZones__1_1;
    }

    protected org.entur.gbfs.v2_3.geofencing_zones.GBFSData gBFSDataToGBFSData11(org.entur.gbfs.v3_0_RC.geofencing_zones.GBFSData gBFSData, String language) {
        Map map;
        if (gBFSData == null) {
            return null;
        }
        org.entur.gbfs.v2_3.geofencing_zones.GBFSData gBFSData1 = new org.entur.gbfs.v2_3.geofencing_zones.GBFSData();
        gBFSData1.setGeofencingZones(this.gBFSGeofencingZones__1ToGBFSGeofencingZones__1_1(gBFSData.getGeofencingZones(), language));
        if (gBFSData1.getAdditionalProperties() != null && (map = gBFSData.getAdditionalProperties()) != null) {
            gBFSData1.getAdditionalProperties().putAll(map);
        }
        return gBFSData1;
    }

    protected org.entur.gbfs.v3_0_RC.system_regions.GBFSRegion gBFSRegionToGBFSRegion(GBFSRegion gBFSRegion, String language) {
        Map map;
        if (gBFSRegion == null) {
            return null;
        }
        org.entur.gbfs.v3_0_RC.system_regions.GBFSRegion gBFSRegion1 = new org.entur.gbfs.v3_0_RC.system_regions.GBFSRegion();
        gBFSRegion1.setRegionId(gBFSRegion.getRegionId());
        gBFSRegion1.setName(this.systemRegionsAdditionalMapper.mapName(gBFSRegion.getName(), language));
        if (gBFSRegion1.getAdditionalProperties() != null && (map = gBFSRegion.getAdditionalProperties()) != null) {
            gBFSRegion1.getAdditionalProperties().putAll(map);
        }
        return gBFSRegion1;
    }

    protected List<org.entur.gbfs.v3_0_RC.system_regions.GBFSRegion> gBFSRegionListToGBFSRegionList(List<GBFSRegion> list, String language) {
        if (list == null) {
            return null;
        }
        ArrayList<org.entur.gbfs.v3_0_RC.system_regions.GBFSRegion> list1 = new ArrayList<org.entur.gbfs.v3_0_RC.system_regions.GBFSRegion>(list.size());
        for (GBFSRegion gBFSRegion : list) {
            list1.add(this.gBFSRegionToGBFSRegion(gBFSRegion, language));
        }
        return list1;
    }

    protected org.entur.gbfs.v3_0_RC.system_regions.GBFSData gBFSDataToGBFSData12(org.entur.gbfs.v2_3.system_regions.GBFSData gBFSData, String language) {
        Map map;
        if (gBFSData == null) {
            return null;
        }
        org.entur.gbfs.v3_0_RC.system_regions.GBFSData gBFSData1 = new org.entur.gbfs.v3_0_RC.system_regions.GBFSData();
        gBFSData1.setRegions(this.gBFSRegionListToGBFSRegionList(gBFSData.getRegions(), language));
        if (gBFSData1.getAdditionalProperties() != null && (map = gBFSData.getAdditionalProperties()) != null) {
            gBFSData1.getAdditionalProperties().putAll(map);
        }
        return gBFSData1;
    }

    protected GBFSRegion gBFSRegionToGBFSRegion1(org.entur.gbfs.v3_0_RC.system_regions.GBFSRegion gBFSRegion, String language) {
        Map map;
        if (gBFSRegion == null) {
            return null;
        }
        GBFSRegion gBFSRegion1 = new GBFSRegion();
        gBFSRegion1.setRegionId(gBFSRegion.getRegionId());
        gBFSRegion1.setName(this.systemRegionsAdditionalMapper.mapNameInverse(gBFSRegion.getName(), language));
        if (gBFSRegion1.getAdditionalProperties() != null && (map = gBFSRegion.getAdditionalProperties()) != null) {
            gBFSRegion1.getAdditionalProperties().putAll(map);
        }
        return gBFSRegion1;
    }

    protected List<GBFSRegion> gBFSRegionListToGBFSRegionList1(List<org.entur.gbfs.v3_0_RC.system_regions.GBFSRegion> list, String language) {
        if (list == null) {
            return null;
        }
        ArrayList<GBFSRegion> list1 = new ArrayList<GBFSRegion>(list.size());
        for (org.entur.gbfs.v3_0_RC.system_regions.GBFSRegion gBFSRegion : list) {
            list1.add(this.gBFSRegionToGBFSRegion1(gBFSRegion, language));
        }
        return list1;
    }

    protected org.entur.gbfs.v2_3.system_regions.GBFSData gBFSDataToGBFSData13(org.entur.gbfs.v3_0_RC.system_regions.GBFSData gBFSData, String language) {
        Map map;
        if (gBFSData == null) {
            return null;
        }
        org.entur.gbfs.v2_3.system_regions.GBFSData gBFSData1 = new org.entur.gbfs.v2_3.system_regions.GBFSData();
        gBFSData1.setRegions(this.gBFSRegionListToGBFSRegionList1(gBFSData.getRegions(), language));
        if (gBFSData1.getAdditionalProperties() != null && (map = gBFSData.getAdditionalProperties()) != null) {
            gBFSData1.getAdditionalProperties().putAll(map);
        }
        return gBFSData1;
    }

    protected GBFSAlert.Type typeToType4(GBFSAlert.Type type, String language) {
        GBFSAlert.Type type1;
        if (type == null) {
            return null;
        }
        switch (type) {
            case SYSTEM_CLOSURE: {
                type1 = GBFSAlert.Type.SYSTEM_CLOSURE;
                break;
            }
            case STATION_CLOSURE: {
                type1 = GBFSAlert.Type.STATION_CLOSURE;
                break;
            }
            case STATION_MOVE: {
                type1 = GBFSAlert.Type.STATION_MOVE;
                break;
            }
            case OTHER: {
                type1 = GBFSAlert.Type.OTHER;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + type);
            }
        }
        return type1;
    }

    protected GBFSTime gBFSTimeToGBFSTime(org.entur.gbfs.v2_3.system_alerts.GBFSTime gBFSTime, String language) {
        Map map;
        if (gBFSTime == null) {
            return null;
        }
        GBFSTime gBFSTime1 = new GBFSTime();
        gBFSTime1.setStart(gBFSTime.getStart());
        gBFSTime1.setEnd(gBFSTime.getEnd());
        if (gBFSTime1.getAdditionalProperties() != null && (map = gBFSTime.getAdditionalProperties()) != null) {
            gBFSTime1.getAdditionalProperties().putAll(map);
        }
        return gBFSTime1;
    }

    protected List<GBFSTime> gBFSTimeListToGBFSTimeList(List<org.entur.gbfs.v2_3.system_alerts.GBFSTime> list, String language) {
        if (list == null) {
            return null;
        }
        ArrayList<GBFSTime> list1 = new ArrayList<GBFSTime>(list.size());
        for (org.entur.gbfs.v2_3.system_alerts.GBFSTime gBFSTime : list) {
            list1.add(this.gBFSTimeToGBFSTime(gBFSTime, language));
        }
        return list1;
    }

    protected org.entur.gbfs.v3_0_RC.system_alerts.GBFSAlert gBFSAlertToGBFSAlert(GBFSAlert gBFSAlert, String language) {
        Map map;
        List list2;
        if (gBFSAlert == null) {
            return null;
        }
        org.entur.gbfs.v3_0_RC.system_alerts.GBFSAlert gBFSAlert1 = new org.entur.gbfs.v3_0_RC.system_alerts.GBFSAlert();
        gBFSAlert1.setAlertId(gBFSAlert.getAlertId());
        gBFSAlert1.setType(this.typeToType4(gBFSAlert.getType(), language));
        gBFSAlert1.setTimes(this.gBFSTimeListToGBFSTimeList(gBFSAlert.getTimes(), language));
        List list1 = gBFSAlert.getStationIds();
        if (list1 != null) {
            gBFSAlert1.setStationIds(new ArrayList(list1));
        }
        if ((list2 = gBFSAlert.getRegionIds()) != null) {
            gBFSAlert1.setRegionIds(new ArrayList(list2));
        }
        gBFSAlert1.setUrl(this.systemAlertsAdditionalMapper.mapUrl(gBFSAlert.getUrl(), language));
        gBFSAlert1.setSummary(this.systemAlertsAdditionalMapper.mapSummary(gBFSAlert.getSummary(), language));
        gBFSAlert1.setDescription(this.systemAlertsAdditionalMapper.mapDescription(gBFSAlert.getDescription(), language));
        gBFSAlert1.setLastUpdated(gBFSAlert.getLastUpdated());
        if (gBFSAlert1.getAdditionalProperties() != null && (map = gBFSAlert.getAdditionalProperties()) != null) {
            gBFSAlert1.getAdditionalProperties().putAll(map);
        }
        return gBFSAlert1;
    }

    protected List<org.entur.gbfs.v3_0_RC.system_alerts.GBFSAlert> gBFSAlertListToGBFSAlertList(List<GBFSAlert> list, String language) {
        if (list == null) {
            return null;
        }
        ArrayList<org.entur.gbfs.v3_0_RC.system_alerts.GBFSAlert> list1 = new ArrayList<org.entur.gbfs.v3_0_RC.system_alerts.GBFSAlert>(list.size());
        for (GBFSAlert gBFSAlert : list) {
            list1.add(this.gBFSAlertToGBFSAlert(gBFSAlert, language));
        }
        return list1;
    }

    protected org.entur.gbfs.v3_0_RC.system_alerts.GBFSData gBFSDataToGBFSData14(org.entur.gbfs.v2_3.system_alerts.GBFSData gBFSData, String language) {
        Map map;
        if (gBFSData == null) {
            return null;
        }
        org.entur.gbfs.v3_0_RC.system_alerts.GBFSData gBFSData1 = new org.entur.gbfs.v3_0_RC.system_alerts.GBFSData();
        gBFSData1.setAlerts(this.gBFSAlertListToGBFSAlertList(gBFSData.getAlerts(), language));
        if (gBFSData1.getAdditionalProperties() != null && (map = gBFSData.getAdditionalProperties()) != null) {
            gBFSData1.getAdditionalProperties().putAll(map);
        }
        return gBFSData1;
    }

    protected GBFSAlert.Type typeToType5(GBFSAlert.Type type, String language) {
        GBFSAlert.Type type1;
        if (type == null) {
            return null;
        }
        switch (type) {
            case SYSTEM_CLOSURE: {
                type1 = GBFSAlert.Type.SYSTEM_CLOSURE;
                break;
            }
            case STATION_CLOSURE: {
                type1 = GBFSAlert.Type.STATION_CLOSURE;
                break;
            }
            case STATION_MOVE: {
                type1 = GBFSAlert.Type.STATION_MOVE;
                break;
            }
            case OTHER: {
                type1 = GBFSAlert.Type.OTHER;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + type);
            }
        }
        return type1;
    }

    protected org.entur.gbfs.v2_3.system_alerts.GBFSTime gBFSTimeToGBFSTime1(GBFSTime gBFSTime, String language) {
        Map map;
        if (gBFSTime == null) {
            return null;
        }
        org.entur.gbfs.v2_3.system_alerts.GBFSTime gBFSTime1 = new org.entur.gbfs.v2_3.system_alerts.GBFSTime();
        gBFSTime1.setStart(gBFSTime.getStart());
        gBFSTime1.setEnd(gBFSTime.getEnd());
        if (gBFSTime1.getAdditionalProperties() != null && (map = gBFSTime.getAdditionalProperties()) != null) {
            gBFSTime1.getAdditionalProperties().putAll(map);
        }
        return gBFSTime1;
    }

    protected List<org.entur.gbfs.v2_3.system_alerts.GBFSTime> gBFSTimeListToGBFSTimeList1(List<GBFSTime> list, String language) {
        if (list == null) {
            return null;
        }
        ArrayList<org.entur.gbfs.v2_3.system_alerts.GBFSTime> list1 = new ArrayList<org.entur.gbfs.v2_3.system_alerts.GBFSTime>(list.size());
        for (GBFSTime gBFSTime : list) {
            list1.add(this.gBFSTimeToGBFSTime1(gBFSTime, language));
        }
        return list1;
    }

    protected GBFSAlert gBFSAlertToGBFSAlert1(org.entur.gbfs.v3_0_RC.system_alerts.GBFSAlert gBFSAlert, String language) {
        Map map;
        List list2;
        if (gBFSAlert == null) {
            return null;
        }
        GBFSAlert gBFSAlert1 = new GBFSAlert();
        gBFSAlert1.setAlertId(gBFSAlert.getAlertId());
        gBFSAlert1.setType(this.typeToType5(gBFSAlert.getType(), language));
        gBFSAlert1.setTimes(this.gBFSTimeListToGBFSTimeList1(gBFSAlert.getTimes(), language));
        List list1 = gBFSAlert.getStationIds();
        if (list1 != null) {
            gBFSAlert1.setStationIds(new ArrayList(list1));
        }
        if ((list2 = gBFSAlert.getRegionIds()) != null) {
            gBFSAlert1.setRegionIds(new ArrayList(list2));
        }
        gBFSAlert1.setUrl(this.systemAlertsAdditionalMapper.mapUrlInverse(gBFSAlert.getUrl(), language));
        gBFSAlert1.setSummary(this.systemAlertsAdditionalMapper.mapSummaryInverse(gBFSAlert.getSummary(), language));
        gBFSAlert1.setDescription(this.systemAlertsAdditionalMapper.mapDescriptionInverse(gBFSAlert.getDescription(), language));
        gBFSAlert1.setLastUpdated(gBFSAlert.getLastUpdated());
        if (gBFSAlert1.getAdditionalProperties() != null && (map = gBFSAlert.getAdditionalProperties()) != null) {
            gBFSAlert1.getAdditionalProperties().putAll(map);
        }
        return gBFSAlert1;
    }

    protected List<GBFSAlert> gBFSAlertListToGBFSAlertList1(List<org.entur.gbfs.v3_0_RC.system_alerts.GBFSAlert> list, String language) {
        if (list == null) {
            return null;
        }
        ArrayList<GBFSAlert> list1 = new ArrayList<GBFSAlert>(list.size());
        for (org.entur.gbfs.v3_0_RC.system_alerts.GBFSAlert gBFSAlert : list) {
            list1.add(this.gBFSAlertToGBFSAlert1(gBFSAlert, language));
        }
        return list1;
    }

    protected org.entur.gbfs.v2_3.system_alerts.GBFSData gBFSDataToGBFSData15(org.entur.gbfs.v3_0_RC.system_alerts.GBFSData gBFSData, String language) {
        Map map;
        if (gBFSData == null) {
            return null;
        }
        org.entur.gbfs.v2_3.system_alerts.GBFSData gBFSData1 = new org.entur.gbfs.v2_3.system_alerts.GBFSData();
        gBFSData1.setAlerts(this.gBFSAlertListToGBFSAlertList1(gBFSData.getAlerts(), language));
        if (gBFSData1.getAdditionalProperties() != null && (map = gBFSData.getAdditionalProperties()) != null) {
            gBFSData1.getAdditionalProperties().putAll(map);
        }
        return gBFSData1;
    }
}

