/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.mapper;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.entur.gbfs.v2_3.gbfs.GBFSFeed;
import org.entur.gbfs.v2_3.gbfs.GBFSFeedName;
import org.entur.gbfs.v2_3.gbfs.GBFSFeeds;
import org.entur.gbfs.v3_0_RC.gbfs.GBFSData;
import org.entur.gbfs.v3_0_RC.gbfs.GBFSFeed;
import org.mapstruct.Context;

public class DiscoveryFileAdditionalMapper {
    public GBFSData map(Map<String, GBFSFeeds> source, @Context String sourceLanguage) {
        List mappedFeeds = source.get(sourceLanguage).getFeeds().stream().filter(this::filterLegacySourceFeeds).map(this::map).collect(Collectors.toList());
        return new GBFSData().withFeeds(mappedFeeds);
    }

    public Map<String, GBFSFeeds> map(GBFSData source, @Context String targetLanguage) {
        GBFSFeeds mappedFeeds = new GBFSFeeds();
        mappedFeeds.setFeeds(source.getFeeds().stream().map(this::map).collect(Collectors.toList()));
        return Map.of(targetLanguage, mappedFeeds);
    }

    private boolean filterLegacySourceFeeds(GBFSFeed sourceFeed) {
        return !List.of(GBFSFeedName.SystemHours, GBFSFeedName.SystemCalendar).contains(sourceFeed.getName());
    }

    private org.entur.gbfs.v3_0_RC.gbfs.GBFSFeed map(GBFSFeed sourceFeed) {
        org.entur.gbfs.v3_0_RC.gbfs.GBFSFeed targetFeed = new org.entur.gbfs.v3_0_RC.gbfs.GBFSFeed();
        if (sourceFeed.getName().equals((Object)GBFSFeedName.FreeBikeStatus)) {
            targetFeed.setName(GBFSFeed.Name.VEHICLE_STATUS);
        } else {
            targetFeed.setName(GBFSFeed.Name.fromValue((String)sourceFeed.getName().value()));
        }
        targetFeed.setUrl(sourceFeed.getUrl().toString());
        return targetFeed;
    }

    private GBFSFeed map(org.entur.gbfs.v3_0_RC.gbfs.GBFSFeed sourceFeed) {
        GBFSFeed targetFeed = new GBFSFeed();
        if (sourceFeed.getName().equals((Object)GBFSFeed.Name.VEHICLE_STATUS)) {
            targetFeed.setName(GBFSFeedName.FreeBikeStatus);
        } else {
            targetFeed.setName(GBFSFeedName.fromValue((String)sourceFeed.getName().value()));
        }
        targetFeed.setUrl(URI.create(sourceFeed.getUrl()));
        return targetFeed;
    }
}

