/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.deps.maven;

import java.io.FileNotFoundException;
import java.io.IOError;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.AbstractRepositoryListener;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.supplier.RepositorySystemSupplier;
import org.eclipse.aether.util.filter.DependencyFilterUtils;
import org.embulk.deps.maven.MavenRepositoryNotFoundException;
import org.embulk.deps.maven.MavenResolutionException;
import org.embulk.plugin.maven.MavenArtifactInstaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenArtifactInstallerImpl
extends MavenArtifactInstaller {
    private static final RemoteRepository MAVEN_CENTRAL = new RemoteRepository.Builder("central", "default", "https://repo.maven.apache.org/maven2").build();
    private static final Logger installLogger = LoggerFactory.getLogger((String)"install");
    private final Path givenLocalMavenRepositoryPath;
    private final Path absoluteLocalMavenRepositoryPath;
    private final RepositorySystemSupplier repositorySystemSupplier;
    private final RepositorySystem repositorySystem;
    private final RepositorySystemSession repositorySystemSession;

    public MavenArtifactInstallerImpl(Path localMavenRepositoryPath) throws FileNotFoundException {
        Path absolutePath;
        try {
            absolutePath = localMavenRepositoryPath.normalize().toAbsolutePath();
        }
        catch (IOError ex) {
            throw new MavenRepositoryNotFoundException(localMavenRepositoryPath, (Throwable)ex);
        }
        catch (SecurityException ex) {
            throw new MavenRepositoryNotFoundException(localMavenRepositoryPath, (Throwable)ex);
        }
        if (!Files.exists(absolutePath, new LinkOption[0])) {
            throw new MavenRepositoryNotFoundException(localMavenRepositoryPath, absolutePath, new NoSuchFileException(absolutePath.toString()));
        }
        if (!Files.isDirectory(absolutePath, new LinkOption[0])) {
            throw new MavenRepositoryNotFoundException(localMavenRepositoryPath, absolutePath, new NotDirectoryException(absolutePath.toString()));
        }
        this.givenLocalMavenRepositoryPath = localMavenRepositoryPath;
        this.absoluteLocalMavenRepositoryPath = absolutePath;
        this.repositorySystemSupplier = new InstallRepositorySystemSupplier();
        this.repositorySystem = this.repositorySystemSupplier.get();
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepository = new LocalRepository(this.absoluteLocalMavenRepositoryPath.toString());
        session.setLocalRepositoryManager(this.repositorySystem.newLocalRepositoryManager((RepositorySystemSession)session, localRepository));
        this.repositorySystemSession = session;
    }

    public final void install(String coords, String ... repositoryUrls) throws IOException {
        DependencyResult dependencyResult;
        DefaultArtifact artifact = new DefaultArtifact(coords);
        DependencyRequest dependencyRequest = MavenArtifactInstallerImpl.buildDependencyRequest((Artifact)artifact, repositoryUrls);
        try {
            dependencyResult = this.repositorySystem.resolveDependencies(this.repositorySystemSession, dependencyRequest);
        }
        catch (DependencyResolutionException ex) {
            throw new MavenResolutionException(ex);
        }
        List artifactResults = dependencyResult.getArtifactResults();
        for (ArtifactResult result : artifactResults) {
            LocalArtifactResult localArtifactResult = result.getLocalArtifactResult();
            if (localArtifactResult.isAvailable()) {
                installLogger.info("Installed {} at {} (already)", (Object)result.getArtifact(), (Object)result.getArtifact().getFile());
                continue;
            }
            installLogger.info("Installed {} at {}", (Object)result.getArtifact(), (Object)result.getArtifact().getFile());
        }
    }

    private static DependencyRequest buildDependencyRequest(Artifact artifact, String ... repositoryUrls) throws IOException {
        List<RemoteRepository> repositories = MavenArtifactInstallerImpl.listRemoteRepositories(repositoryUrls);
        DependencyFilter classpathFilter = DependencyFilterUtils.classpathFilter((String[])new String[]{"runtime"});
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency(artifact, "runtime"));
        collectRequest.setRepositories(repositories);
        return new DependencyRequest(collectRequest, classpathFilter);
    }

    static List<RemoteRepository> listRemoteRepositories(String ... repositoryUrls) throws IOException {
        ArrayList<RemoteRepository> repositories = new ArrayList<RemoteRepository>();
        if (repositoryUrls.length == 0) {
            installLogger.info("No alternative remote Maven repositories are specified. Downloading artifacts from Maven Central.");
            repositories.add(MAVEN_CENTRAL);
        } else {
            for (String url : repositoryUrls) {
                repositories.add(MavenArtifactInstallerImpl.buildRemoteRepositoryFromUrl(url));
            }
            installLogger.info("Downloading artifacts from alternative remote Maven repositories: {}", (Object)repositories.stream().map(RemoteRepository::getUrl).collect(Collectors.joining(", ")));
        }
        return Collections.unmodifiableList(repositories);
    }

    static RemoteRepository buildRemoteRepositoryFromUrl(String url) throws IOException {
        if (url == null) {
            throw new MalformedURLException("null specified for remote repository.");
        }
        if (url.equalsIgnoreCase(MAVEN_CENTRAL.getId()) || url.equals(MAVEN_CENTRAL.getUrl())) {
            return MAVEN_CENTRAL;
        }
        return new RemoteRepository.Builder(null, null, url).build();
    }

    private static class InstallRepositorySystemSupplier
    extends RepositorySystemSupplier {
        private InstallRepositorySystemSupplier() {
        }

        protected Map<String, RepositoryListener> getRepositoryListeners() {
            HashMap<String, RepositoryListener> listeners = new HashMap<String, RepositoryListener>(super.getRepositoryListeners());
            listeners.put("embulk-install", (RepositoryListener)new LoggingListener());
            return listeners;
        }
    }

    private static class LoggingListener
    extends AbstractRepositoryListener {
        private LoggingListener() {
        }

        public void artifactDownloaded(RepositoryEvent event) {
            installLogger.info("Downloaded {} at {}", (Object)event.getArtifact().toString(), (Object)event.getFile());
        }

        public void artifactDownloading(RepositoryEvent event) {
            ArtifactRepository repository = event.getRepository();
            if (repository instanceof RemoteRepository) {
                RemoteRepository remoteRepository = (RemoteRepository)repository;
                installLogger.info("Downloading {} from {}", (Object)event.getArtifact().toString(), (Object)remoteRepository.getUrl());
            } else {
                installLogger.info("Downloading {} from {}", (Object)event.getArtifact().toString(), (Object)repository.toString());
            }
        }
    }
}

