/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.deps.config;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.embulk.config.ConfigException;
import org.embulk.config.TaskSource;
import org.embulk.deps.config.ModelManagerDelegateImpl;
import org.embulk.plugin.PluginType;
import org.embulk.spi.ProcessTask;
import org.embulk.spi.Schema;

final class ProcessTaskJacksonModule
extends SimpleModule {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public ProcessTaskJacksonModule(ModelManagerDelegateImpl model) {
        this.addSerializer(ProcessTask.class, new ProcessTaskSerializer(model));
        this.addDeserializer(ProcessTask.class, new ProcessTaskDeserializer(model));
    }

    private static class ProcessTaskDeserializer
    extends JsonDeserializer<ProcessTask> {
        private final ModelManagerDelegateImpl model;

        ProcessTaskDeserializer(ModelManagerDelegateImpl model) {
            this.model = model;
        }

        public ProcessTask deserialize(JsonParser jsonParser, DeserializationContext context) throws JsonMappingException {
            JsonNode node;
            try {
                node = (JsonNode)OBJECT_MAPPER.readTree(jsonParser);
            }
            catch (JsonParseException ex) {
                throw JsonMappingException.from((JsonParser)jsonParser, (String)"Failed to parse JSON.", (Throwable)ex);
            }
            catch (JsonProcessingException ex) {
                throw JsonMappingException.from((JsonParser)jsonParser, (String)"Failed to process JSON in parsing.", (Throwable)ex);
            }
            catch (IOException ex) {
                throw JsonMappingException.from((JsonParser)jsonParser, (String)"Failed to read JSON in parsing.", (Throwable)ex);
            }
            if (!node.isObject()) {
                throw new JsonMappingException("Expected object to deserialize ProcessTask", jsonParser.getCurrentLocation());
            }
            ObjectNode object = (ObjectNode)node;
            try {
                PluginType inputPluginType = this.model.readObject(PluginType.class, object.get("inputType").traverse());
                PluginType outputPluginType = this.model.readObject(PluginType.class, object.get("outputType").traverse());
                JsonNode filterPluginTypesNode = object.get("filterTypes");
                if (!filterPluginTypesNode.isArray()) {
                    throw new JsonMappingException("An array is expected for ProcessTask's filterTypes", jsonParser.getCurrentLocation());
                }
                ArrayList<PluginType> filterPluginTypes = new ArrayList<PluginType>();
                for (JsonNode filterPluginTypeNode : (ArrayNode)filterPluginTypesNode) {
                    if (filterPluginTypeNode == null || filterPluginTypeNode.isNull()) {
                        filterPluginTypes.add(null);
                        continue;
                    }
                    filterPluginTypes.add(this.model.readObject(PluginType.class, filterPluginTypeNode.traverse()));
                }
                TaskSource inputTaskSource = this.model.readObject(TaskSource.class, object.get("inputTask").traverse());
                TaskSource outputTaskSource = this.model.readObject(TaskSource.class, object.get("outputTask").traverse());
                JsonNode filterTaskSourcesNode = object.get("filterTasks");
                if (!filterTaskSourcesNode.isArray()) {
                    throw new JsonMappingException("An array is expected for ProcessTask's filterTasks", jsonParser.getCurrentLocation());
                }
                ArrayList<TaskSource> filterTaskSources = new ArrayList<TaskSource>();
                for (JsonNode filterTaskSourceNode : (ArrayNode)filterTaskSourcesNode) {
                    if (filterTaskSourceNode == null || filterTaskSourceNode.isNull()) {
                        filterTaskSources.add(null);
                        continue;
                    }
                    filterTaskSources.add(this.model.readObject(TaskSource.class, filterTaskSourceNode.traverse()));
                }
                JsonNode schemasNode = object.get("schemas");
                if (!schemasNode.isArray()) {
                    throw new JsonMappingException("An array is expected for ProcessTask's schemas", jsonParser.getCurrentLocation());
                }
                ArrayList<Schema> schemas = new ArrayList<Schema>();
                for (JsonNode schemaNode : (ArrayNode)schemasNode) {
                    if (schemaNode == null || schemaNode.isNull()) {
                        schemas.add(null);
                        continue;
                    }
                    schemas.add(this.model.readObject(Schema.class, schemaNode.traverse()));
                }
                Schema executorSchema = this.model.readObject(Schema.class, object.get("executorSchema").traverse());
                TaskSource executorTaskSource = this.model.readObject(TaskSource.class, object.get("executorTask").traverse());
                return new ProcessTask(inputPluginType, outputPluginType, Collections.unmodifiableList(filterPluginTypes), inputTaskSource, outputTaskSource, Collections.unmodifiableList(filterTaskSources), Collections.unmodifiableList(schemas), executorSchema, executorTaskSource);
            }
            catch (ConfigException ex) {
                throw JsonMappingException.from((JsonParser)jsonParser, (String)"Invalid object to deserialize ProcessTask", (Throwable)ex);
            }
        }
    }

    private static class ProcessTaskSerializer
    extends JsonSerializer<ProcessTask> {
        private final ModelManagerDelegateImpl model;

        ProcessTaskSerializer(ModelManagerDelegateImpl model) {
            this.model = model;
        }

        public void serialize(ProcessTask value, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            ObjectNode object = OBJECT_MAPPER.createObjectNode();
            object.put("inputType", (JsonNode)this.model.writeObjectAsObjectNode(value.getInputPluginType()));
            object.put("outputType", (JsonNode)this.model.writeObjectAsObjectNode(value.getOutputPluginType()));
            object.put("filterTypes", (JsonNode)this.model.writeObjectAsObjectNode(value.getFilterPluginTypes()));
            object.put("inputTask", (JsonNode)this.model.writeObjectAsObjectNode(value.getInputTaskSource()));
            object.put("outputTask", (JsonNode)this.model.writeObjectAsObjectNode(value.getOutputTaskSource()));
            object.put("filterTasks", (JsonNode)this.model.writeObjectAsObjectNode(value.getFilterTaskSources()));
            object.put("schemas", (JsonNode)this.model.writeObjectAsObjectNode(value.getFilterSchemas()));
            object.put("executorSchema", (JsonNode)this.model.writeObjectAsObjectNode(value.getExecutorSchema()));
            object.put("executorTask", (JsonNode)this.model.writeObjectAsObjectNode(value.getExecutorTaskSource()));
            jsonGenerator.writeTree((TreeNode)object);
        }
    }
}

