/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.deps.config;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdNodeBasedDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.embulk.spi.Column;
import org.embulk.spi.type.Type;
import org.embulk.spi.type.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ColumnJacksonModule
extends SimpleModule {
    private static final Logger logger;
    private static final ObjectMapper OBJECT_MAPPER;
    private static final Map<String, Type> STRING_TO_TYPE;

    public ColumnJacksonModule() {
        this.addSerializer(Column.class, new ColumnSerializer());
        this.addDeserializer(Column.class, (JsonDeserializer)new ColumnDeserializer());
    }

    static final Column convertJsonNodeToColumn(JsonNode root, JsonParser jsonParser) throws JsonProcessingException {
        int index;
        if (root == null || !root.isObject()) {
            throw JsonMappingException.from((JsonParser)jsonParser, (String)"Column expects a JSON Object node.");
        }
        ObjectNode object = (ObjectNode)root;
        JsonNode indexNode = object.get("index");
        if (indexNode == null) {
            logger.warn("Building Column from JSON without \"index\".", (Throwable)JsonMappingException.from((JsonParser)jsonParser, (String)"Building Column from JSON without \"index\"."));
            index = 0;
        } else {
            index = (Integer)OBJECT_MAPPER.treeToValue((TreeNode)indexNode, Integer.TYPE);
        }
        JsonNode nameNode = object.get("name");
        if (nameNode == null) {
            throw JsonMappingException.from((JsonParser)jsonParser, (String)"Building Column from JSON without \"name\".");
        }
        String name = (String)OBJECT_MAPPER.treeToValue((TreeNode)nameNode, String.class);
        JsonNode typeNode = object.get("type");
        if (typeNode == null) {
            throw JsonMappingException.from((JsonParser)jsonParser, (String)"Building Column from JSON without \"type\".");
        }
        String typeString = (String)OBJECT_MAPPER.treeToValue((TreeNode)typeNode, String.class);
        if (!STRING_TO_TYPE.containsKey(typeString)) {
            throw JsonMappingException.from((JsonParser)jsonParser, (String)("Building Column from JSON with unexpected type: " + typeString));
        }
        Type type = STRING_TO_TYPE.get(typeString);
        return new Column(index, name, type);
    }

    static {
        HashMap<String, Object> builder = new HashMap<String, Object>();
        builder.put(Types.BOOLEAN.getName(), Types.BOOLEAN);
        builder.put(Types.LONG.getName(), Types.LONG);
        builder.put(Types.DOUBLE.getName(), Types.DOUBLE);
        builder.put(Types.STRING.getName(), Types.STRING);
        builder.put(Types.TIMESTAMP.getName(), Types.TIMESTAMP);
        builder.put(Types.JSON.getName(), Types.JSON);
        STRING_TO_TYPE = Collections.unmodifiableMap(builder);
        logger = LoggerFactory.getLogger(ColumnJacksonModule.class);
        OBJECT_MAPPER = new ObjectMapper();
    }

    private static class ColumnDeserializer
    extends StdNodeBasedDeserializer<Column> {
        protected ColumnDeserializer() {
            super(Column.class);
        }

        public Column convert(JsonNode root, DeserializationContext context) throws JsonProcessingException {
            return ColumnJacksonModule.convertJsonNodeToColumn(root, context.getParser());
        }
    }

    private static class ColumnSerializer
    extends JsonSerializer<Column> {
        private ColumnSerializer() {
        }

        public void serialize(Column value, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            ObjectNode object = OBJECT_MAPPER.createObjectNode();
            object.put("index", value.getIndex());
            object.put("name", value.getName());
            object.put("type", value.getType().getName());
            jsonGenerator.writeTree((TreeNode)object);
        }
    }
}

