/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.deps.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import javax.validation.Validation;
import org.apache.bval.jsr303.ApacheValidationProvider;
import org.apache.bval.jsr303.ApacheValidatorConfiguration;
import org.embulk.config.ConfigDiff;
import org.embulk.config.ConfigException;
import org.embulk.config.ConfigSource;
import org.embulk.config.DataSource;
import org.embulk.config.TaskReport;
import org.embulk.config.TaskSource;
import org.embulk.deps.config.ByteSizeJacksonModule;
import org.embulk.deps.config.CharsetJacksonModule;
import org.embulk.deps.config.ColumnConfigJacksonModule;
import org.embulk.deps.config.ColumnJacksonModule;
import org.embulk.deps.config.DataSourceImpl;
import org.embulk.deps.config.DataSourceSerDe;
import org.embulk.deps.config.LocalFileJacksonModule;
import org.embulk.deps.config.ModelManagerDelegate;
import org.embulk.deps.config.PluginTypeJacksonModule;
import org.embulk.deps.config.ProcessTaskJacksonModule;
import org.embulk.deps.config.ResumeStateJacksonModule;
import org.embulk.deps.config.SchemaConfigJacksonModule;
import org.embulk.deps.config.SchemaJacksonModule;
import org.embulk.deps.config.TaskSerDe;
import org.embulk.deps.config.TaskValidator;
import org.embulk.deps.config.TimestampFormatJacksonModule;
import org.embulk.deps.config.TimestampJacksonModule;
import org.embulk.deps.config.ToStringJacksonModule;
import org.embulk.deps.config.ToStringMapJacksonModule;
import org.embulk.deps.config.TypeJacksonModule;

public class ModelManagerDelegateImpl
extends ModelManagerDelegate {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final ObjectMapper configObjectMapper;
    private final TaskValidator taskValidator;

    public ModelManagerDelegateImpl() {
        this.objectMapper.registerModule((Module)new ColumnConfigJacksonModule(this));
        this.objectMapper.registerModule((Module)new SchemaConfigJacksonModule(this));
        this.objectMapper.registerModule((Module)new PluginTypeJacksonModule());
        this.objectMapper.registerModule((Module)new ProcessTaskJacksonModule(this));
        this.objectMapper.registerModule((Module)new ResumeStateJacksonModule(this));
        this.objectMapper.registerModule((Module)new TimestampJacksonModule());
        this.objectMapper.registerModule((Module)new TimestampFormatJacksonModule());
        this.objectMapper.registerModule((Module)new ByteSizeJacksonModule());
        this.objectMapper.registerModule((Module)new CharsetJacksonModule());
        this.objectMapper.registerModule((Module)new LocalFileJacksonModule());
        this.objectMapper.registerModule((Module)new ToStringJacksonModule());
        this.objectMapper.registerModule((Module)new ToStringMapJacksonModule());
        this.objectMapper.registerModule((Module)new TypeJacksonModule());
        this.objectMapper.registerModule((Module)new ColumnJacksonModule());
        this.objectMapper.registerModule((Module)new SchemaJacksonModule());
        this.objectMapper.registerModule((Module)new Jdk8Module());
        this.configObjectMapper = this.objectMapper.copy();
        this.taskValidator = new TaskValidator(((ApacheValidatorConfiguration)Validation.byProvider(ApacheValidationProvider.class).configure()).buildValidatorFactory().getValidator());
        this.objectMapper.registerModule((Module)new TaskSerDe.TaskSerializerModule(this.objectMapper));
        this.objectMapper.registerModule((Module)new TaskSerDe.TaskDeserializerModule(this.objectMapper, this));
        this.objectMapper.registerModule((Module)new DataSourceSerDe.SerDeModule(this));
        this.configObjectMapper.registerModule((Module)new TaskSerDe.TaskSerializerModule(this.configObjectMapper));
        this.configObjectMapper.registerModule((Module)new TaskSerDe.ConfigTaskDeserializerModule(this.configObjectMapper, this));
        this.configObjectMapper.registerModule((Module)new DataSourceSerDe.SerDeModule(this));
    }

    public <T> T readObject(Class<T> valueType, String json) {
        try {
            return (T)this.objectMapper.readValue(json, valueType);
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    <T> T readObject(Class<T> valueType, JsonParser parser) {
        try {
            return (T)this.objectMapper.readValue(parser, valueType);
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    public <T> T readObjectWithConfigSerDe(Class<T> valueType, String json) {
        Object t;
        try {
            t = this.configObjectMapper.readValue(json, valueType);
        }
        catch (Exception ex) {
            if (ex instanceof ConfigException) {
                throw (ConfigException)ex;
            }
            throw new ConfigException((Throwable)ex);
        }
        this.validate(t);
        return (T)t;
    }

    <T> T readObjectWithConfigSerDe(Class<T> valueType, JsonParser parser) {
        Object t;
        try {
            t = this.configObjectMapper.readValue(parser, valueType);
        }
        catch (Exception ex) {
            if (ex instanceof ConfigException) {
                throw (ConfigException)ex;
            }
            throw new ConfigException((Throwable)ex);
        }
        this.validate(t);
        return (T)t;
    }

    public DataSource readObjectAsDataSource(String json) {
        try {
            return (DataSource)this.objectMapper.readValue(json, DataSourceImpl.class);
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    public String writeObject(Object object) {
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    public void validate(Object object) {
        this.taskValidator.validateModel(object);
    }

    public TaskReport newTaskReport() {
        return new DataSourceImpl(this);
    }

    public ConfigDiff newConfigDiff() {
        return new DataSourceImpl(this);
    }

    public ConfigSource newConfigSource() {
        return new DataSourceImpl(this);
    }

    public TaskSource newTaskSource() {
        return new DataSourceImpl(this);
    }

    JsonNode writeObjectAsJsonNode(Object v) {
        String json = this.writeObject(v);
        try {
            return (JsonNode)this.objectMapper.readValue(json, JsonNode.class);
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    ObjectNode writeObjectAsObjectNode(Object v) {
        String json = this.writeObject(v);
        try {
            return (ObjectNode)this.objectMapper.readValue(json, ObjectNode.class);
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
    }
}

