/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.deps.config;

import java.util.regex.Pattern;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.resolver.Resolver;

public class YamlTagResolver
extends Resolver {
    public static final Pattern FLOAT_EXCEPTING_ZERO_START = Pattern.compile("^([-+]?(\\.[0-9]+|[1-9][0-9_]*(\\.[0-9_]*)?)([eE][-+]?[0-9]+)?|[-+]?[0-9][0-9_]*(?::[0-5]?[0-9])+\\.[0-9_]*|[-+]?\\.(?:inf|Inf|INF)|\\.(?:nan|NaN|NAN))$");

    public void addImplicitResolver(Tag tag, Pattern regexp, String first) {
        if (tag.equals((Object)Tag.FLOAT)) {
            super.addImplicitResolver(Tag.FLOAT, FLOAT_EXCEPTING_ZERO_START, "-+0123456789.");
        } else if (tag.equals((Object)Tag.BOOL)) {
            super.addImplicitResolver(Tag.BOOL, Pattern.compile("^(?:[Tt]rue|[Ff]alse)$"), "TtFf");
        } else {
            if (tag.equals((Object)Tag.TIMESTAMP)) {
                return;
            }
            super.addImplicitResolver(tag, regexp, first);
        }
    }

    public Tag resolve(NodeId kind, String value, boolean implicit) {
        return super.resolve(kind, value, implicit);
    }
}

