/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.deps.config;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.embulk.config.ConfigException;
import org.embulk.config.ConfigSource;
import org.embulk.deps.config.DataSourceImpl;
import org.embulk.deps.config.ModelManagerDelegateImpl;
import org.embulk.spi.ColumnConfig;
import org.embulk.spi.type.Type;

public final class ColumnConfigJacksonModule
extends SimpleModule {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public ColumnConfigJacksonModule(ModelManagerDelegateImpl model) {
        this.addSerializer(ColumnConfig.class, new ColumnConfigSerializer(model));
        this.addDeserializer(ColumnConfig.class, new ColumnConfigDeserializer(model));
    }

    private static class ColumnConfigDeserializer
    extends JsonDeserializer<ColumnConfig> {
        private final ModelManagerDelegateImpl model;

        ColumnConfigDeserializer(ModelManagerDelegateImpl model) {
            this.model = model;
        }

        public ColumnConfig deserialize(JsonParser jsonParser, DeserializationContext context) throws JsonMappingException {
            JsonNode node;
            try {
                node = (JsonNode)OBJECT_MAPPER.readTree(jsonParser);
            }
            catch (JsonParseException ex) {
                throw JsonMappingException.from((JsonParser)jsonParser, (String)"Failed to parse JSON.", (Throwable)ex);
            }
            catch (JsonProcessingException ex) {
                throw JsonMappingException.from((JsonParser)jsonParser, (String)"Failed to process JSON in parsing.", (Throwable)ex);
            }
            catch (IOException ex) {
                throw JsonMappingException.from((JsonParser)jsonParser, (String)"Failed to read JSON in parsing.", (Throwable)ex);
            }
            if (!node.isObject()) {
                throw new JsonMappingException("Expected object to deserialize ColumnConfig", jsonParser.getCurrentLocation());
            }
            try {
                DataSourceImpl config = new DataSourceImpl(this.model, (ObjectNode)node);
                String name = (String)config.get(String.class, "name");
                Type type = (Type)config.get(Type.class, "type");
                ConfigSource option = config.deepCopy();
                option.remove("name");
                option.remove("type");
                return new ColumnConfig(name, type, option);
            }
            catch (ConfigException ex) {
                throw JsonMappingException.from((JsonParser)jsonParser, (String)"Invalid object to deserialize ColumnConfig", (Throwable)ex);
            }
        }
    }

    private static class ColumnConfigSerializer
    extends JsonSerializer<ColumnConfig> {
        private final ModelManagerDelegateImpl model;

        ColumnConfigSerializer(ModelManagerDelegateImpl model) {
            this.model = model;
        }

        public void serialize(ColumnConfig value, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            ConfigSource option = value.getOption();
            ObjectNode object = this.model.writeObjectAsObjectNode(option);
            object.put("name", value.getName());
            object.put("type", value.getType().getName());
            jsonGenerator.writeTree((TreeNode)object);
        }
    }
}

