/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.deps.config;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdNodeBasedDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.embulk.deps.config.ColumnJacksonModule;
import org.embulk.spi.Column;
import org.embulk.spi.Schema;

public final class SchemaJacksonModule
extends SimpleModule {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public SchemaJacksonModule() {
        this.addSerializer(Schema.class, new SchemaSerializer());
        this.addDeserializer(Schema.class, (JsonDeserializer)new SchemaDeserializer());
    }

    private static class SchemaDeserializer
    extends StdNodeBasedDeserializer<Schema> {
        protected SchemaDeserializer() {
            super(Schema.class);
        }

        public Schema convert(JsonNode root, DeserializationContext context) throws JsonProcessingException {
            if (root == null || !root.isArray()) {
                throw JsonMappingException.from((JsonParser)context.getParser(), (String)"Schema expects a JSON Array node.");
            }
            ArrayNode array = (ArrayNode)root;
            ArrayList<Column> builder = new ArrayList<Column>();
            for (JsonNode element : () -> array.elements()) {
                builder.add(ColumnJacksonModule.convertJsonNodeToColumn(element, context.getParser()));
            }
            return new Schema(Collections.unmodifiableList(builder));
        }
    }

    private static class SchemaSerializer
    extends JsonSerializer<Schema> {
        private SchemaSerializer() {
        }

        public void serialize(Schema value, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            ArrayNode array = OBJECT_MAPPER.createArrayNode();
            for (Column column : value.getColumns()) {
                ObjectNode object = OBJECT_MAPPER.createObjectNode();
                object.put("index", column.getIndex());
                object.put("name", column.getName());
                object.put("type", column.getType().getName());
                array.add((JsonNode)object);
            }
            jsonGenerator.writeTree((TreeNode)array);
        }
    }
}

