/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.deps.config;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.embulk.config.Config;
import org.embulk.config.TaskSource;
import org.embulk.deps.config.DataSourceImpl;
import org.embulk.deps.config.ModelManagerDelegateImpl;

class TaskInvocationHandler
implements InvocationHandler {
    @Deprecated
    private final ModelManagerDelegateImpl model;
    private final Class<?> iface;
    private final Map<String, Object> objects;
    private static final Constructor<MethodHandles.Lookup> CONSTRUCTOR_MethodHandles_Lookup;

    public TaskInvocationHandler(ModelManagerDelegateImpl model, Class<?> iface, Map<String, Object> objects) {
        this.model = model;
        this.iface = iface;
        this.objects = objects;
    }

    static Multimap<String, Method> fieldGetters(Class<?> iface) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (Method method : iface.getMethods()) {
            String methodName = method.getName();
            String fieldName = TaskInvocationHandler.getterFieldNameOrNull(methodName);
            if (fieldName == null || !TaskInvocationHandler.hasExpectedArgumentLength(method, 0) || method.isDefault() && method.getAnnotation(Config.class) == null) continue;
            builder.put((Object)fieldName, (Object)method);
        }
        return builder.build();
    }

    Map<String, Object> getObjects() {
        return this.objects;
    }

    protected Object invokeGetter(Method method, String fieldName) {
        return this.objects.get(fieldName);
    }

    protected void invokeSetter(Method method, String fieldName, Object value) {
        if (value == null) {
            this.objects.remove(fieldName);
        } else {
            this.objects.put(fieldName, value);
        }
    }

    private Map<String, Object> getSerializableFields() {
        return new HashMap<String, Object>(this.objects);
    }

    protected TaskSource invokeDump() {
        return new DataSourceImpl(this.model, this.model.writeObjectAsObjectNode(this.getSerializableFields()));
    }

    protected String invokeToString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.iface.getName());
        sb.append(this.getSerializableFields());
        return sb.toString();
    }

    protected int invokeHashCode() {
        return this.objects.hashCode();
    }

    protected boolean invokeEquals(Object other) {
        return other instanceof TaskInvocationHandler && this.objects.equals(((TaskInvocationHandler)other).objects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        String methodName;
        switch (methodName = method.getName()) {
            case "validate": {
                TaskInvocationHandler.checkArgumentLength(method, 0, methodName);
                this.model.validate(proxy);
                return proxy;
            }
            case "dump": {
                TaskInvocationHandler.checkArgumentLength(method, 0, methodName);
                return this.invokeDump();
            }
            case "toString": {
                TaskInvocationHandler.checkArgumentLength(method, 0, methodName);
                return this.invokeToString();
            }
            case "hashCode": {
                TaskInvocationHandler.checkArgumentLength(method, 0, methodName);
                return this.invokeHashCode();
            }
            case "equals": {
                TaskInvocationHandler.checkArgumentLength(method, 1, methodName);
                if (args[0] instanceof Proxy) {
                    InvocationHandler otherHandler = Proxy.getInvocationHandler(args[0]);
                    return this.invokeEquals(otherHandler);
                }
                return false;
            }
        }
        String fieldName = TaskInvocationHandler.getterFieldNameOrNull(methodName);
        if (fieldName != null) {
            if (method.isDefault() && !this.objects.containsKey(fieldName) && CONSTRUCTOR_MethodHandles_Lookup != null) {
                Constructor<MethodHandles.Lookup> constructor = CONSTRUCTOR_MethodHandles_Lookup;
                synchronized (constructor) {
                    boolean hasSetAccessible = false;
                    try {
                        CONSTRUCTOR_MethodHandles_Lookup.setAccessible(true);
                        hasSetAccessible = true;
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    if (hasSetAccessible) {
                        try {
                            Object object = CONSTRUCTOR_MethodHandles_Lookup.newInstance(method.getDeclaringClass(), 15).unreflectSpecial(method, method.getDeclaringClass()).bindTo(proxy).invokeWithArguments(new Object[0]);
                            return object;
                        }
                        catch (Throwable throwable) {
                        }
                        finally {
                            CONSTRUCTOR_MethodHandles_Lookup.setAccessible(false);
                        }
                    }
                }
            }
            TaskInvocationHandler.checkArgumentLength(method, 0, methodName);
            return this.invokeGetter(method, fieldName);
        }
        fieldName = TaskInvocationHandler.setterFieldNameOrNull(methodName);
        if (fieldName != null) {
            TaskInvocationHandler.checkArgumentLength(method, 1, methodName);
            this.invokeSetter(method, fieldName, args[0]);
            return this;
        }
        throw new IllegalArgumentException(String.format("Undefined method '%s'", methodName));
    }

    private static String getterFieldNameOrNull(String methodName) {
        if (methodName.startsWith("get")) {
            return methodName.substring(3);
        }
        return null;
    }

    private static String setterFieldNameOrNull(String methodName) {
        if (methodName.startsWith("set")) {
            return methodName.substring(3);
        }
        return null;
    }

    protected static boolean hasExpectedArgumentLength(Method method, int expected) {
        return method.getParameterTypes().length == expected;
    }

    protected static void checkArgumentLength(Method method, int expected, String methodName) {
        if (!TaskInvocationHandler.hasExpectedArgumentLength(method, expected)) {
            throw new IllegalArgumentException(String.format("Method '%s' expected %d argument but got %d arguments", methodName, expected, method.getParameterTypes().length));
        }
    }

    static {
        Constructor constructorMethodHandlesLookupTemporary = null;
        try {
            constructorMethodHandlesLookupTemporary = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            constructorMethodHandlesLookupTemporary = null;
        }
        finally {
            CONSTRUCTOR_MethodHandles_Lookup = constructorMethodHandlesLookupTemporary;
        }
    }
}

