/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.deps.preview;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.embulk.deps.preview.PreviewPrinter;
import org.embulk.deps.preview.ValueFormatter;
import org.embulk.spi.Page;
import org.embulk.spi.Schema;
import org.embulk.spi.util.Pages;

final class TablePreviewPrinter
extends PreviewPrinter {
    private static final int MAX_SAMPLE_SIZE = 32000;
    private final PrintStream out;
    private final Schema schema;
    private final ValueFormatter valueFormatter;
    private List<String[]> samples;
    private int sampleSize;
    private String format;
    private String border;

    TablePreviewPrinter(PrintStream out, Schema schema) {
        this.out = out;
        this.schema = schema;
        this.valueFormatter = new ValueFormatter();
        this.format = null;
        this.border = null;
        this.sampleSize = 0;
        this.samples = new ArrayList<String[]>();
        String[] header = new String[schema.getColumnCount()];
        for (int i = 0; i < header.length; ++i) {
            header[i] = schema.getColumnName(i) + ":" + schema.getColumnType(i);
        }
        this.samples.add(header);
    }

    public void printAllPages(List<Page> pages) throws IOException {
        List records = Pages.toObjects((Schema)this.schema, pages, (boolean)true);
        for (Object[] record : records) {
            this.printRecord(record);
        }
    }

    public void close() throws IOException {
        this.out.close();
    }

    public void finish() throws IOException {
        if (this.samples != null) {
            this.flushSamples();
        }
        this.out.println(this.border);
    }

    private void printRecord(Object ... values) throws IOException {
        int i;
        String[] stringValues = new String[this.schema.getColumnCount()];
        int min = Math.min(this.schema.getColumnCount(), values.length);
        for (i = 0; i < min; ++i) {
            stringValues[i] = this.valueFormatter.valueToString(values[i]);
        }
        for (i = min; i < this.schema.getColumnCount(); ++i) {
            stringValues[i] = this.valueFormatter.valueToString(null);
        }
        if (this.samples == null) {
            this.out.format(this.format, Arrays.copyOf(stringValues, stringValues.length, Object[].class));
        } else {
            this.samples.add(Arrays.copyOf(stringValues, stringValues.length));
            for (String v : stringValues) {
                this.sampleSize += v.length();
            }
            if (this.sampleSize > 32000) {
                this.flushSamples();
            }
        }
    }

    private void flushSamples() {
        int i;
        StringBuilder borderBuilder = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        sb.append("| ");
        borderBuilder.append("+-");
        for (i = 0; i < this.schema.getColumnCount(); ++i) {
            if (i != 0) {
                sb.append(" | ");
                borderBuilder.append("-+-");
            }
            int colLen = this.maxLengthInColumn(i);
            sb.append("%" + colLen + "s");
            for (int b = 0; b < colLen; ++b) {
                borderBuilder.append("-");
            }
        }
        sb.append(" |");
        borderBuilder.append("-+");
        sb.append("\n");
        this.format = sb.toString();
        this.border = borderBuilder.toString();
        this.out.println(this.border);
        for (i = 0; i < this.samples.size(); ++i) {
            String[] values = this.samples.get(i);
            this.out.format(this.format, Arrays.copyOf(values, values.length, Object[].class));
            if (i != 0) continue;
            this.out.println(this.border);
        }
        this.samples = null;
    }

    private int maxLengthInColumn(int i) {
        int max = 0;
        for (String[] values : this.samples) {
            max = Math.max(max, values[i].length());
        }
        return max;
    }
}

