/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.deps.config;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.embulk.plugin.DefaultPluginType;
import org.embulk.plugin.MavenPluginType;
import org.embulk.plugin.PluginSource;
import org.embulk.plugin.PluginType;

final class PluginTypeJacksonModule
extends SimpleModule {
    public PluginTypeJacksonModule() {
        this.addSerializer(DefaultPluginType.class, new DefaultPluginTypeSerializer());
        this.addSerializer(MavenPluginType.class, new MavenPluginTypeSerializer());
        this.addDeserializer(PluginType.class, new PluginTypeDeserializer());
    }

    private static PluginType createFromString(String name) {
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        return DefaultPluginType.create((String)name);
    }

    private static PluginType createFromStringMap(Map<String, String> stringMap) {
        PluginSource.Type sourceType = stringMap.containsKey("source") ? PluginSource.Type.of((String)stringMap.get("source")) : PluginSource.Type.DEFAULT;
        switch (sourceType) {
            case DEFAULT: {
                String name = stringMap.get("name");
                return PluginTypeJacksonModule.createFromString(name);
            }
            case MAVEN: {
                String name = stringMap.get("name");
                String group = stringMap.get("group");
                String classifier = stringMap.get("classifier");
                String version = stringMap.get("version");
                return MavenPluginType.create((String)name, (String)group, (String)classifier, (String)version);
            }
        }
        throw new IllegalArgumentException("\"source\" must be one of: [\"default\", \"maven\"]");
    }

    static PluginType createFromStringForTesting(String name) {
        return PluginTypeJacksonModule.createFromString(name);
    }

    static PluginType createFromStringMapForTesting(Map<String, String> stringMap) {
        return PluginTypeJacksonModule.createFromStringMap(stringMap);
    }

    private static class PluginTypeDeserializer
    extends JsonDeserializer<PluginType> {
        private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

        private PluginTypeDeserializer() {
        }

        public PluginType deserialize(JsonParser jsonParser, DeserializationContext context) throws JsonMappingException {
            JsonNode typeJson;
            try {
                typeJson = (JsonNode)OBJECT_MAPPER.readTree(jsonParser);
            }
            catch (JsonParseException ex) {
                throw JsonMappingException.from((JsonParser)jsonParser, (String)"Failed to parse JSON.", (Throwable)ex);
            }
            catch (JsonProcessingException ex) {
                throw JsonMappingException.from((JsonParser)jsonParser, (String)"Failed to process JSON in parsing.", (Throwable)ex);
            }
            catch (IOException ex) {
                throw JsonMappingException.from((JsonParser)jsonParser, (String)"Failed to read JSON in parsing.", (Throwable)ex);
            }
            if (typeJson.isTextual()) {
                return PluginTypeJacksonModule.createFromString(((TextNode)typeJson).textValue());
            }
            if (typeJson.isObject()) {
                HashMap stringMap = new HashMap();
                ObjectNode typeObject = (ObjectNode)typeJson;
                Iterator fieldIterator = typeObject.fields();
                while (fieldIterator.hasNext()) {
                    Map.Entry field = (Map.Entry)fieldIterator.next();
                    JsonNode fieldValue = (JsonNode)field.getValue();
                    if (fieldValue instanceof ContainerNode) {
                        throw new IllegalArgumentException("\"type\" must be a string or a 1-depth mapping.");
                    }
                    stringMap.put(field.getKey(), fieldValue.textValue());
                }
                return PluginTypeJacksonModule.createFromStringMap(stringMap);
            }
            throw new IllegalArgumentException("\"type\" must be a string or a 1-depth mapping.");
        }
    }

    private static class MavenPluginTypeSerializer
    extends JsonSerializer<MavenPluginType> {
        private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

        private MavenPluginTypeSerializer() {
        }

        public void serialize(MavenPluginType value, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            ObjectNode object = OBJECT_MAPPER.createObjectNode();
            object.put("source", value.getSourceName());
            object.put("name", value.getName());
            if (value.getGroup() != null) {
                object.put("group", value.getGroup());
            }
            if (value.getClassifier() != null) {
                object.put("classifier", value.getClassifier());
            }
            if (value.getVersion() != null) {
                object.put("version", value.getVersion());
            }
            jsonGenerator.writeTree((TreeNode)object);
        }
    }

    private static class DefaultPluginTypeSerializer
    extends JsonSerializer<DefaultPluginType> {
        private DefaultPluginTypeSerializer() {
        }

        public void serialize(DefaultPluginType value, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            jsonGenerator.writeString(value.getName());
        }
    }
}

