/*
 * Decompiled with CFR 0.152.
 */
package org.elder.sourcerer.eventstore.test.rules;

import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.shazam.tocker.AliveStrategies;
import com.shazam.tocker.DockerInstance;
import com.shazam.tocker.PortMap;
import com.shazam.tocker.RunningDockerInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventStoreRule
extends ExternalResource {
    private static final int SERVICE_PORT = 1113;
    private static final int PROBE_PORT = 2113;
    private static final Logger logger = LoggerFactory.getLogger(EventStoreRule.class);
    private final DockerInstance instance = DockerInstance.fromImage((String)"eventstore/eventstore:release-4.0.1").withContainerName("eventstore-test-container").mappingPorts(new PortMap[]{PortMap.ephemeral((int)1113), PortMap.ephemeral((int)2113)}).build();
    private RunningDockerInstance store;
    private List<Runnable> cleanup = new ArrayList<Runnable>();

    protected void before() throws Throwable {
        logger.info("Starting EventStore");
        this.store = this.instance.run(AliveStrategies.retrying(this.livenessProbe(), (int)100, (int)100));
    }

    protected void after() {
        for (Runnable job : this.cleanup) {
            job.run();
        }
    }

    public EventStoreRule start() {
        return this;
    }

    private Function<RunningDockerInstance, Boolean> livenessProbe() {
        return inst -> {
            int port = inst.mappedPorts().forContainerPort(2113);
            try {
                Unirest.get((String)String.format("http://%s:%d/streams/newstream2", this.hostname(), port)).asJson();
                return true;
            }
            catch (UnirestException ex) {
                logger.info("Liveness probe failed", (Object)ex.getMessage());
                return false;
            }
        };
    }

    public String hostname() {
        return this.instance.host();
    }

    public int port() {
        return this.store.mappedPorts().forContainerPort(1113);
    }
}

