/*
 * Decompiled with CFR 0.152.
 */
package org.elder.sourcerer.spring;

import org.elder.sourcerer.DefaultEventSubscriptionFactory;
import org.elder.sourcerer.EventRepository;
import org.elder.sourcerer.EventRepositoryFactory;
import org.elder.sourcerer.EventSubscriptionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;

public class SourcererEventConfiguration<T> {
    private final Class<T> eventType;
    @Autowired
    private EventRepositoryFactory repositoryFactory;

    protected SourcererEventConfiguration(Class<T> eventType) {
        this.eventType = eventType;
    }

    @Bean
    @Lazy
    @Scope(value="singleton")
    public EventRepository<T> getEventRepository() {
        return this.repositoryFactory.getEventRepository(this.eventType);
    }

    @Bean
    @Lazy
    @Scope(value="singleton")
    EventSubscriptionFactory<T> getEventSubscriptionFactory(EventRepository<T> eventRepository) {
        return new DefaultEventSubscriptionFactory(eventRepository);
    }
}

