/*
 * Decompiled with CFR 0.152.
 */
package org.elder.sourcerer.spring;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elder.sourcerer.AggregateProjection;
import org.elder.sourcerer.AggregateRepository;
import org.elder.sourcerer.CommandFactory;
import org.elder.sourcerer.DefaultAggregateRepository;
import org.elder.sourcerer.DefaultCommandFactory;
import org.elder.sourcerer.EventRepository;
import org.elder.sourcerer.MetadataDecorator;
import org.elder.sourcerer.MetadataDecoratorCommandPostProcessor;
import org.elder.sourcerer.spring.SourcererEventConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;

public class SourcererCommandConfiguration<TEvent, TAggregate>
extends SourcererEventConfiguration<TEvent> {
    private final Class<TAggregate> aggregateType;
    private final AggregateProjection<TAggregate, TEvent> projection;
    @Autowired(required=false)
    private List<MetadataDecorator> metadataDecorators;
    @Autowired
    private ObjectMapper objectMapper;

    protected SourcererCommandConfiguration(Class<TEvent> eventType, Class<TAggregate> aggregateType, AggregateProjection<TAggregate, TEvent> projection) {
        super(eventType);
        this.aggregateType = aggregateType;
        this.projection = projection;
    }

    @Bean
    @Lazy
    @Scope(value="singleton")
    public AggregateRepository<TAggregate, TEvent> getAggregateRepository(EventRepository<TEvent> eventRepository) {
        return new DefaultAggregateRepository(eventRepository, this.projection, this::resolveType);
    }

    @Bean
    @Lazy
    @Scope(value="singleton")
    public CommandFactory<TAggregate, TEvent> getCommandFactory(AggregateRepository<TAggregate, TEvent> aggregateRepository) {
        ArrayList<MetadataDecoratorCommandPostProcessor> commandPostProcessors = new ArrayList<MetadataDecoratorCommandPostProcessor>();
        if (this.metadataDecorators != null) {
            for (MetadataDecorator metadataDecorator : this.metadataDecorators) {
                commandPostProcessors.add(new MetadataDecoratorCommandPostProcessor(metadataDecorator));
            }
        }
        return new DefaultCommandFactory(aggregateRepository, commandPostProcessors);
    }

    public String resolveType(TEvent event) {
        Map jsonMap = (Map)this.objectMapper.convertValue(event, Map.class);
        if (!jsonMap.containsKey("type")) {
            throw new IllegalArgumentException("Event does not appear to use polymorphic Jackson serialization, override resolveType() to provide a different implementation");
        }
        return (String)jsonMap.get("type");
    }
}

