/*
 * Decompiled with CFR 0.152.
 */
package org.elder.sourcerer.kotlin;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.elder.sourcerer.EventData;
import org.elder.sourcerer.EventRecord;
import org.elder.sourcerer.EventRepository;
import org.elder.sourcerer.ExpectedVersion;
import org.elder.sourcerer.Snapshot;
import org.elder.sourcerer.kotlin.SnapshotEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0006\u0018\u0000 '*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001'BM\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J3\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000e2\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010\u001d\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00192\u0006\u0010\u001e\u001a\u00020\u000eJ$\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000e2\u0012\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\"0!H\u0002J\u0010\u0010#\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u000eH\u0002J\u0018\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0019*\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0002J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019*\u0006\u0012\u0002\b\u00030\u0019H\u0002J\u0018\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019*\b\u0012\u0004\u0012\u00020\u000e0\u0019H\u0002R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/elder/sourcerer/kotlin/SnapshottingSupport;", "STATE", "", "snapshottingEnabled", "", "compressingEnabled", "snapshotRepository", "Lorg/elder/sourcerer/EventRepository;", "Lorg/elder/sourcerer/kotlin/SnapshotEvent;", "clazz", "Ljava/lang/Class;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "snapshottingVersion", "", "minVersionsBetweenSnapshots", "", "(ZZLorg/elder/sourcerer/EventRepository;Ljava/lang/Class;Lcom/fasterxml/jackson/databind/ObjectMapper;Ljava/lang/String;I)V", "getCompressingEnabled", "()Z", "getSnapshottingEnabled", "createNewSnapshotIfNecessary", "", "id", "snapshot", "Lorg/elder/sourcerer/Snapshot;", "newVersion", "newState", "(Ljava/lang/String;Lorg/elder/sourcerer/Snapshot;ILjava/lang/Object;)V", "findSnapshot", "entityId", "snapshotAppend", "operation", "Lkotlin/Function0;", "", "snapshotEntityId", "compress", "parse", "uncompress", "Companion", "sourcerer-kotlin"})
public final class SnapshottingSupport<STATE> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean snapshottingEnabled;
    private final boolean compressingEnabled;
    @NotNull
    private final EventRepository<SnapshotEvent> snapshotRepository;
    @NotNull
    private final Class<STATE> clazz;
    @NotNull
    private final ObjectMapper mapper;
    @NotNull
    private final String snapshottingVersion;
    private final int minVersionsBetweenSnapshots;
    private static final Logger logger = LoggerFactory.getLogger(SnapshottingSupport.class);

    public SnapshottingSupport(boolean snapshottingEnabled, boolean compressingEnabled, @NotNull EventRepository<SnapshotEvent> snapshotRepository, @NotNull Class<STATE> clazz, @NotNull ObjectMapper mapper, @NotNull String snapshottingVersion, int minVersionsBetweenSnapshots) {
        Intrinsics.checkNotNullParameter(snapshotRepository, (String)"snapshotRepository");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)snapshottingVersion, (String)"snapshottingVersion");
        this.snapshottingEnabled = snapshottingEnabled;
        this.compressingEnabled = compressingEnabled;
        this.snapshotRepository = snapshotRepository;
        this.clazz = clazz;
        this.mapper = mapper;
        this.snapshottingVersion = snapshottingVersion;
        this.minVersionsBetweenSnapshots = minVersionsBetweenSnapshots;
    }

    public /* synthetic */ SnapshottingSupport(boolean bl, boolean bl2, EventRepository eventRepository, Class clazz, ObjectMapper objectMapper, String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        if ((n2 & 2) != 0) {
            bl2 = false;
        }
        this(bl, bl2, (EventRepository<SnapshotEvent>)eventRepository, clazz, objectMapper, string, n);
    }

    public final boolean getSnapshottingEnabled() {
        return this.snapshottingEnabled;
    }

    public final boolean getCompressingEnabled() {
        return this.compressingEnabled;
    }

    public final void createNewSnapshotIfNecessary(@NotNull String id, @Nullable Snapshot<STATE> snapshot, int newVersion, STATE newState) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        try {
            boolean snapshotIsWellBehind;
            Snapshot<STATE> snapshot2 = snapshot;
            Integer n = snapshot2 != null ? snapshot2.getStreamVersion() : null;
            int snapshotVersion = n == null ? -1 : n;
            boolean bl = snapshotIsWellBehind = newVersion - snapshotVersion >= this.minVersionsBetweenSnapshots;
            if (snapshotIsWellBehind) {
                String snapshotEntityId = this.snapshotEntityId(id);
                Snapshot snapshot3 = new Snapshot(newState, Integer.valueOf(newVersion));
                this.snapshotAppend(snapshotEntityId, (Function0<List<SnapshotEvent>>)((Function0)new Function0<List<? extends SnapshotEvent>>(this, snapshot3){
                    final /* synthetic */ SnapshottingSupport<STATE> this$0;
                    final /* synthetic */ Snapshot<STATE> $snapshot;
                    {
                        this.this$0 = $receiver;
                        this.$snapshot = $snapshot;
                        super(0);
                    }

                    @NotNull
                    public final List<SnapshotEvent> invoke() {
                        SnapshotEvent snapshotEvent;
                        boolean bl = this.this$0.getCompressingEnabled();
                        if (bl) {
                            snapshotEvent = new SnapshotEvent.CompressedAdded((Snapshot<String>)SnapshottingSupport.access$compress(this.this$0, this.$snapshot), SnapshottingSupport.access$getSnapshottingVersion$p(this.this$0));
                        } else if (!bl) {
                            snapshotEvent = new SnapshotEvent.Added<STATE>(this.$snapshot, SnapshottingSupport.access$getSnapshottingVersion$p(this.this$0));
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        return CollectionsKt.listOf((Object)snapshotEvent);
                    }
                }));
            }
        }
        catch (Exception ex) {
            logger.warn("Error attempting to create new snapshot", (Throwable)ex);
        }
    }

    @Nullable
    public final Snapshot<STATE> findSnapshot(@NotNull String entityId) {
        Snapshot<STATE> snapshot;
        Intrinsics.checkNotNullParameter((Object)entityId, (String)"entityId");
        try {
            SnapshotEvent snapshotEvent;
            SnapshotEvent snapshotEvent2;
            String snapshotEntityId = this.snapshotEntityId(entityId);
            EventRecord eventRecord = this.snapshotRepository.readLast(snapshotEntityId);
            if (eventRecord != null && (snapshotEvent2 = (SnapshotEvent)eventRecord.getEvent()) != null) {
                SnapshotEvent snapshotEvent3;
                SnapshotEvent it = snapshotEvent3 = snapshotEvent2;
                boolean bl = false;
                snapshotEvent = Intrinsics.areEqual((Object)it.getMonitorVersion(), (Object)this.snapshottingVersion) ? snapshotEvent3 : null;
            } else {
                snapshotEvent = null;
            }
            SnapshotEvent event = snapshotEvent;
            eventRecord = event;
            snapshot = eventRecord instanceof SnapshotEvent.Added ? this.parse(((SnapshotEvent.Added)event).getSnapshot()) : (eventRecord instanceof SnapshotEvent.CompressedAdded ? this.uncompress(((SnapshotEvent.CompressedAdded)event).getCompressedSnapshot()) : null);
        }
        catch (Exception ex) {
            logger.warn("Error trying to find snapshot", (Throwable)ex);
            snapshot = null;
        }
        return snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Snapshot<String> compress(Snapshot<STATE> $this$compress) {
        ByteArrayOutputStream byteArrayOutputStream;
        byte[] data = this.mapper.writeValueAsBytes($this$compress.getState());
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream it = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new GZIPOutputStream(it);
            Throwable throwable2 = null;
            try {
                GZIPOutputStream it2 = (GZIPOutputStream)closeable2;
                boolean bl2 = false;
                it2.write(data);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            byteArrayOutputStream = it;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] compressed = byteArrayOutputStream.toByteArray();
        String stringState = Base64.getEncoder().encodeToString(compressed);
        return new Snapshot((Object)stringState, $this$compress.getStreamVersion());
    }

    private final Snapshot<STATE> uncompress(Snapshot<String> $this$uncompress) {
        byte[] data = Base64.getDecoder().decode((String)$this$uncompress.getState());
        Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
        GZIPInputStream inputStream = new GZIPInputStream(new ByteArrayInputStream(data));
        Object state = this.mapper.readValue((InputStream)inputStream, this.clazz);
        return new Snapshot(state, $this$uncompress.getStreamVersion());
    }

    private final Snapshot<STATE> parse(Snapshot<?> $this$parse) {
        Object state = this.mapper.convertValue($this$parse.getState(), this.clazz);
        return new Snapshot(state, $this$parse.getStreamVersion());
    }

    /*
     * WARNING - void declaration
     */
    private final void snapshotAppend(String id, Function0<? extends List<? extends SnapshotEvent>> operation) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)operation.invoke();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void element$iv2;
            void event;
            Collection collection;
            block4: {
                void $this$first$iv;
                SnapshotEvent snapshotEvent = (SnapshotEvent)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Annotation[] annotationArray = event.getClass().getAnnotations();
                Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"event::class.java.annotations");
                Object[] objectArray = annotationArray;
                boolean $i$f$first = false;
                for (void element$iv2 : $this$first$iv) {
                    Annotation it = (Annotation)element$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)JvmClassMappingKt.getAnnotationClass((Annotation)it), (Object)Reflection.getOrCreateKotlinClass(JsonTypeName.class))) {
                        continue;
                    }
                    break block4;
                }
                throw new NoSuchElementException("Array contains no element matching the predicate.");
            }
            Annotation it = (Annotation)element$iv2;
            boolean bl = false;
            Annotation annotation = it;
            if (annotation == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.fasterxml.jackson.annotation.JsonTypeName");
            }
            String eventTypeName = ((JsonTypeName)annotation).value();
            collection.add(new EventData(eventTypeName, UUID.randomUUID(), MapsKt.emptyMap(), (Object)event));
        }
        List events = (List)destination$iv$iv;
        this.snapshotRepository.append(id, events, ExpectedVersion.any());
    }

    private final String snapshotEntityId(String entityId) {
        return entityId + '-' + this.snapshottingVersion;
    }

    public static final /* synthetic */ Snapshot access$compress(SnapshottingSupport $this, Snapshot $receiver) {
        return $this.compress($receiver);
    }

    public static final /* synthetic */ String access$getSnapshottingVersion$p(SnapshottingSupport $this) {
        return $this.snapshottingVersion;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/elder/sourcerer/kotlin/SnapshottingSupport$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "sourcerer-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

