/*
 * Decompiled with CFR 0.152.
 */
package org.elder.sourcerer.eventstore;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import eventstore.j.EsConnection;
import java.util.regex.Pattern;
import org.elder.sourcerer.EventNormalizer;
import org.elder.sourcerer.EventRepository;
import org.elder.sourcerer.EventRepositoryFactory;
import org.elder.sourcerer.EventTypeUtils;
import org.elder.sourcerer.eventstore.EventStoreEventRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventStoreEventRepositoryFactory
implements EventRepositoryFactory {
    private static final Pattern NAMESPACE_REGEX = Pattern.compile("[a-zA-Z][a-zA-Z_0-9]*");
    private static final Logger logger = LoggerFactory.getLogger(EventStoreEventRepositoryFactory.class);
    private final EsConnection connection;
    private final ObjectMapper objectMapper;
    private final String defaultNamespace;

    public EventStoreEventRepositoryFactory(EsConnection connection, ObjectMapper objectMapper, String defaultNamespace) {
        Preconditions.checkNotNull((Object)connection);
        Preconditions.checkNotNull((Object)objectMapper);
        Preconditions.checkNotNull((Object)defaultNamespace);
        EventStoreEventRepositoryFactory.validateNamespace(defaultNamespace);
        this.connection = connection;
        this.objectMapper = objectMapper;
        this.defaultNamespace = defaultNamespace;
    }

    public <T> EventRepository<T> getEventRepository(Class<T> eventType) {
        return this.getEventRepository(eventType, this.defaultNamespace);
    }

    public <T> EventRepository<T> getEventRepository(Class<T> eventType, String namespace) {
        EventStoreEventRepositoryFactory.validateNamespace(namespace);
        String repositoryName = EventTypeUtils.getRepositoryName(eventType);
        EventNormalizer normalizer = EventTypeUtils.getNormalizer(eventType);
        String eventStreamPrefix = String.format("%s:%s", namespace, repositoryName);
        logger.info("Creating Event Store repository for {} with prefix {}", (Object)eventType.getSimpleName(), (Object)eventStreamPrefix);
        return new EventStoreEventRepository<T>(eventStreamPrefix, this.connection, eventType, this.objectMapper, normalizer);
    }

    private static void validateNamespace(String defaultNamespace) {
        if (!NAMESPACE_REGEX.matcher(defaultNamespace).matches()) {
            throw new IllegalArgumentException("Invalid namespace, namespaces cannot include - / : or other special characters");
        }
    }
}

