/*
 * Decompiled with CFR 0.152.
 */
package org.elder.soucerer.eventstore;

import eventstore.Position;
import eventstore.ReadAllEventsCompleted;
import eventstore.j.EsConnection;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import scala.compat.java8.FutureConverters;
import scala.concurrent.Future;

public class EventStoreHealthIndicator
extends AbstractHealthIndicator {
    private static final Logger logger = LoggerFactory.getLogger(EventStoreHealthIndicator.class);
    private final EsConnection connection;

    public EventStoreHealthIndicator(EsConnection connection) {
        this.connection = connection;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        logger.debug("Reading Event Store for health check");
        ReadAllEventsCompleted res = (ReadAllEventsCompleted)EventStoreHealthIndicator.completeFuture(this.connection.readAllEventsBackward((Position)Position.Last$.MODULE$, 1, false, null));
        logger.debug("Event store successfully pinged");
        builder.status(Status.UP).withDetail("position", (Object)res.position().toString());
    }

    private static <T> T completeFuture(Future<T> future) {
        try {
            return FutureConverters.toJava(future).toCompletableFuture().get();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Internal error reading event", ex);
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            throw new RuntimeException("Internal error reading event", ex);
        }
    }
}

