/*
 * Decompiled with CFR 0.152.
 */
package org.elder.soucerer.eventstore;

import akka.actor.ActorSystem;
import com.fasterxml.jackson.databind.ObjectMapper;
import eventstore.Settings;
import eventstore.cluster.ClusterSettings;
import eventstore.cluster.GossipSeedsOrDns;
import eventstore.cluster.GossipSeedsOrDns$;
import eventstore.j.EsConnection;
import eventstore.j.EsConnectionFactory;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.elder.soucerer.eventstore.EventStoreHealthIndicator;
import org.elder.sourcerer.EventRepositoryFactory;
import org.elder.sourcerer.eventstore.EventStoreEventRepositoryFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import scala.Option;
import scala.concurrent.duration.FiniteDuration;

@Configuration
public class EventStoreConfiguration {
    @Bean
    @Scope(value="singleton")
    public EsConnection getEventStoreConnection(@Value(value="${sourcerer.eventstore.hostname:127.0.0.1}") String hostname, @Value(value="${sourcerer.eventstore.port:1113}") int port, @Value(value="${sourcerer.eventstore.gossipPort:2113}") int gossipPort, @Value(value="${sourcerer.eventstore.requireMaster:false}") boolean requireMaster, @Value(value="${sourcerer.eventstore.useClusterDiscovery:false}") boolean useClusterDiscovery) {
        Option clusterSettings;
        ActorSystem system = ActorSystem.create();
        Settings defaultSettings = Settings.Default();
        if (useClusterDiscovery) {
            GossipSeedsOrDns clusterDns = GossipSeedsOrDns$.MODULE$.apply(hostname, gossipPort);
            clusterSettings = Option.apply((Object)new ClusterSettings(clusterDns, FiniteDuration.apply((long)2L, (TimeUnit)TimeUnit.SECONDS), 10, FiniteDuration.apply((long)500L, (TimeUnit)TimeUnit.MILLISECONDS), FiniteDuration.apply((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS), FiniteDuration.apply((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS)));
        } else {
            clusterSettings = Option.empty();
        }
        Settings settings = new Settings(new InetSocketAddress(hostname, port), defaultSettings.connectionTimeout(), -1, defaultSettings.reconnectionDelayMin(), defaultSettings.reconnectionDelayMax(), defaultSettings.defaultCredentials(), defaultSettings.heartbeatInterval(), defaultSettings.heartbeatTimeout(), defaultSettings.operationMaxRetries(), defaultSettings.operationTimeout(), defaultSettings.resolveLinkTos(), requireMaster, defaultSettings.readBatchSize(), defaultSettings.backpressure(), clusterSettings);
        return EsConnectionFactory.create((ActorSystem)system, (Settings)settings);
    }

    @Bean
    @Scope(value="singleton")
    public EventRepositoryFactory getEventRepositoryFactory(EsConnection connection, ObjectMapper objectMapper, @Value(value="${sourcerer.eventstore.namespace}") String namespace) {
        return new EventStoreEventRepositoryFactory(connection, objectMapper, namespace.trim());
    }

    @Bean(name={"eventStoreStatus"})
    @Scope(value="singleton")
    public HealthIndicator getEventStoreHealthIndicator(EsConnection connection) {
        return new EventStoreHealthIndicator(connection);
    }
}

