/*
 * Decompiled with CFR 0.152.
 */
package org.elder.sourcerer.eventstoredb;

import com.eventstore.dbclient.EventStoreDBClient;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import org.elder.sourcerer.EventNormalizer;
import org.elder.sourcerer.EventRepository;
import org.elder.sourcerer.EventRepositoryFactory;
import org.elder.sourcerer.EventTypeUtils;
import org.elder.sourcerer.eventstoredb.EventStoreGrpcEventRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventStoreGrpcEventRepositoryFactory
implements EventRepositoryFactory {
    private static final Pattern NAMESPACE_REGEX = Pattern.compile("[a-zA-Z][a-zA-Z_0-9]*");
    private static final Logger logger = LoggerFactory.getLogger(EventStoreGrpcEventRepositoryFactory.class);
    private final EventStoreDBClient eventStore;
    private final ObjectMapper objectMapper;
    private final String defaultNamespace;

    public EventStoreGrpcEventRepositoryFactory(EventStoreDBClient eventStore, ObjectMapper objectMapper, String defaultNamespace) {
        Preconditions.checkNotNull((Object)eventStore);
        Preconditions.checkNotNull((Object)objectMapper);
        Preconditions.checkNotNull((Object)defaultNamespace);
        EventStoreGrpcEventRepositoryFactory.validateNamespace(defaultNamespace);
        this.eventStore = eventStore;
        this.objectMapper = objectMapper;
        this.defaultNamespace = defaultNamespace;
    }

    public <T> EventRepository<T> getEventRepository(Class<T> eventType) {
        return this.getEventRepository(eventType, this.defaultNamespace);
    }

    public <T> EventRepository<T> getEventRepository(Class<T> eventType, String namespace) {
        EventStoreGrpcEventRepositoryFactory.validateNamespace(namespace);
        String repositoryName = EventTypeUtils.getRepositoryName(eventType);
        EventNormalizer normalizer = EventTypeUtils.getNormalizer(eventType);
        String eventStreamPrefix = String.format("%s:%s", namespace, repositoryName);
        logger.info("Creating Event Store repository for {} with prefix {}", (Object)eventType.getSimpleName(), (Object)eventStreamPrefix);
        return new EventStoreGrpcEventRepository<T>(eventStreamPrefix, this.eventStore, eventType, this.objectMapper, normalizer);
    }

    public void close() throws IOException {
        try {
            this.eventStore.shutdown();
        }
        catch (ExecutionException ex) {
            throw new IOException(ex.getCause());
        }
        catch (InterruptedException ex) {
            throw new IOException(ex);
        }
    }

    private static void validateNamespace(String defaultNamespace) {
        if (!NAMESPACE_REGEX.matcher(defaultNamespace).matches()) {
            throw new IllegalArgumentException("Invalid namespace, namespaces cannot include - / : or other special characters");
        }
    }
}

