/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.vault.scripting;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.security.InvalidParameterException;
import java.util.Map;
import okhttp3.ResponseBody;
import org.elastos.hive.connection.NodeRPCConnection;
import org.elastos.hive.connection.NodeRPCException;
import org.elastos.hive.connection.UploadOutputStream;
import org.elastos.hive.connection.UploadOutputStreamWriter;
import org.elastos.hive.exception.HiveException;
import org.elastos.hive.exception.NetworkException;
import org.elastos.hive.exception.NotFoundException;
import org.elastos.hive.exception.ServerUnknownException;
import org.elastos.hive.exception.UnauthorizedException;
import org.elastos.hive.exception.VaultForbiddenException;
import org.elastos.hive.vault.scripting.Condition;
import org.elastos.hive.vault.scripting.Context;
import org.elastos.hive.vault.scripting.Executable;
import org.elastos.hive.vault.scripting.HiveUrlInfo;
import org.elastos.hive.vault.scripting.RegScriptParams;
import org.elastos.hive.vault.scripting.RunScriptParams;
import org.elastos.hive.vault.scripting.ScriptingAPI;
import retrofit2.Response;

public class ScriptingController {
    private WeakReference<NodeRPCConnection> connection;
    private ScriptingAPI scriptingAPI;

    public ScriptingController(NodeRPCConnection connection) {
        this.connection = new WeakReference<NodeRPCConnection>(connection);
        this.scriptingAPI = connection.createService(ScriptingAPI.class, true);
    }

    public void registerScript(String name, Condition condition, Executable executable, boolean allowAnonymousUser, boolean allowAnonymousApp) throws HiveException {
        try {
            this.scriptingAPI.registerScript(name, new RegScriptParams().setExecutable(executable).setAllowAnonymousUser(allowAnonymousUser).setAllowAnonymousApp(allowAnonymousApp).setCondition(condition)).execute().body();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 403: {
                    throw new VaultForbiddenException((Throwable)e);
                }
                case 400: {
                    throw new InvalidParameterException(e.getMessage());
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public <T> T callScript(String name, JsonNode params, String targetDid, String targetAppDid, Class<T> resultType) throws HiveException {
        try {
            Map map = (Map)new ObjectMapper().convertValue((Object)params, (TypeReference)new TypeReference<Map<String, Object>>(){});
            String json = ((ResponseBody)this.scriptingAPI.runScript(name, new RunScriptParams().setContext(new Context().setTargetDid(targetDid).setTargetAppDid(targetAppDid)).setParams(map)).execute().body()).string();
            Object obj = null;
            try {
                obj = resultType.isAssignableFrom(String.class) ? json : (resultType.isAssignableFrom(byte[].class) ? (Object)json.getBytes() : (resultType.isAssignableFrom(JsonNode.class) ? new ObjectMapper().readTree(json) : (resultType.isAssignableFrom(Reader.class) ? new StringReader(json) : new ObjectMapper().readValue(json, resultType))));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unsupported result Type class.");
            }
            return resultType.cast(obj);
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 403: {
                    throw new VaultForbiddenException((Throwable)e);
                }
                case 400: {
                    throw new InvalidParameterException(e.getMessage());
                }
                case 404: {
                    throw new NotFoundException(e);
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public <T> T callScriptUrl(String name, String params, String targetDid, String targetAppDid, Class<T> resultType) throws HiveException {
        try {
            String json = ((ResponseBody)this.scriptingAPI.runScriptUrl(name, targetDid, targetAppDid, params).execute().body()).string();
            Object obj = null;
            try {
                obj = resultType.isAssignableFrom(String.class) ? json : (resultType.isAssignableFrom(byte[].class) ? (Object)json.getBytes() : (resultType.isAssignableFrom(JsonNode.class) ? new ObjectMapper().readTree(json) : (resultType.isAssignableFrom(Reader.class) ? new StringReader(json) : new ObjectMapper().readValue(json, resultType))));
            }
            catch (Exception e) {
                throw new RuntimeException("unsupported result type for call script.");
            }
            return resultType.cast(obj);
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 403: {
                    throw new VaultForbiddenException((Throwable)e);
                }
                case 400: {
                    throw new InvalidParameterException(e.getMessage());
                }
                case 404: {
                    throw new NotFoundException(e);
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public <T> T uploadFile(String transactionId, Class<T> resultType) throws HiveException {
        try {
            HttpURLConnection conn = ((NodeRPCConnection)this.connection.get()).openConnection("/api/v2/vault/scripting/stream/" + transactionId);
            return this.getRequestStream(conn, resultType);
        }
        catch (NodeRPCException e) {
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public <T> T downloadFile(String transactionId, Class<T> resultType) throws HiveException {
        try {
            return this.getResponseStream((Response<ResponseBody>)this.scriptingAPI.downloadFile(transactionId).execute(), resultType);
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 403: {
                    throw new VaultForbiddenException((Throwable)e);
                }
                case 400: {
                    throw new InvalidParameterException(e.getMessage());
                }
                case 404: {
                    throw new NotFoundException(e);
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    private <T> T getRequestStream(HttpURLConnection connection, Class<T> resultType) throws IOException {
        OutputStream outputStream = connection.getOutputStream();
        if (resultType.isAssignableFrom(OutputStream.class)) {
            UploadOutputStream uploader = new UploadOutputStream(connection, outputStream);
            return resultType.cast(uploader);
        }
        if (resultType.isAssignableFrom(OutputStreamWriter.class)) {
            UploadOutputStreamWriter writer = new UploadOutputStreamWriter(connection, outputStream);
            return resultType.cast(writer);
        }
        return null;
    }

    private <T> T getResponseStream(Response<ResponseBody> response, Class<T> resultType) {
        ResponseBody body = (ResponseBody)response.body();
        if (body == null) {
            throw new RuntimeException("Failed to get response body");
        }
        if (resultType.isAssignableFrom(Reader.class)) {
            return resultType.cast(new InputStreamReader(body.byteStream()));
        }
        if (resultType.isAssignableFrom(InputStream.class)) {
            return resultType.cast(body.byteStream());
        }
        return null;
    }

    public <T> T downloadFileByHiveUrl(String hiveUrl, Class<T> resultType) throws HiveException {
        HiveUrlInfo info = new HiveUrlInfo(hiveUrl);
        JsonNode result = this.callScriptUrl(info.getScriptName(), info.getParams(), info.getTargetDid(), info.getTargetAppDid(), JsonNode.class);
        return this.downloadFile(this.getTransactionIdByJsonNode(result), resultType);
    }

    private String getTransactionIdByJsonNode(JsonNode jsonNode) {
        JsonNode node = this.searchForEntity(jsonNode, "transaction_id");
        if (node == null) {
            throw new InvalidParameterException("Can't get transaction id by calling script.");
        }
        return node.asText();
    }

    private JsonNode searchForEntity(JsonNode node, String entityName) {
        if (node == null) {
            return null;
        }
        if (node.has(entityName)) {
            return node.get(entityName);
        }
        if (!node.isContainerNode()) {
            return null;
        }
        for (JsonNode child : node) {
            JsonNode childResult;
            if (!child.isContainerNode() || (childResult = this.searchForEntity(child, entityName)) == null || childResult.isMissingNode()) continue;
            return childResult;
        }
        return null;
    }

    public void unregisterScript(String name) throws HiveException {
        try {
            this.scriptingAPI.unregisterScript(name).execute();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 403: {
                    throw new VaultForbiddenException((Throwable)e);
                }
                case 400: {
                    throw new InvalidParameterException(e.getMessage());
                }
                case 404: {
                    throw new NotFoundException(e);
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }
}

