/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.vault.files;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.security.InvalidParameterException;
import java.util.List;
import okhttp3.ResponseBody;
import org.elastos.hive.connection.NodeRPCConnection;
import org.elastos.hive.connection.NodeRPCException;
import org.elastos.hive.connection.UploadOutputStream;
import org.elastos.hive.connection.UploadOutputStreamWriter;
import org.elastos.hive.exception.HiveException;
import org.elastos.hive.exception.NetworkException;
import org.elastos.hive.exception.NotFoundException;
import org.elastos.hive.exception.ServerUnknownException;
import org.elastos.hive.exception.UnauthorizedException;
import org.elastos.hive.exception.VaultForbiddenException;
import org.elastos.hive.vault.files.ChildrenInfo;
import org.elastos.hive.vault.files.FileInfo;
import org.elastos.hive.vault.files.FilesAPI;
import org.elastos.hive.vault.files.HashInfo;

public class FilesController {
    private NodeRPCConnection connection;
    private FilesAPI filesAPI;

    public FilesController(NodeRPCConnection connection) {
        this.connection = connection;
        this.filesAPI = connection.createService(FilesAPI.class, true);
    }

    public OutputStream getUploadStream(String path) throws HiveException {
        try {
            HttpURLConnection urlConnection = this.connection.openConnection("/api/v2/vault/files/" + path);
            return new UploadOutputStream(urlConnection, urlConnection.getOutputStream());
        }
        catch (NodeRPCException e) {
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public Writer getUploadWriter(String path) throws HiveException {
        try {
            HttpURLConnection urlConnection = this.connection.openConnection("/api/v2/vault/files/" + path);
            return new UploadOutputStreamWriter(urlConnection, urlConnection.getOutputStream());
        }
        catch (NodeRPCException e) {
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public InputStream getDownloadStream(String path) throws HiveException {
        try {
            return ((ResponseBody)this.filesAPI.download(path).execute().body()).byteStream();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 403: {
                    throw new VaultForbiddenException((Throwable)e);
                }
                case 400: {
                    throw new InvalidParameterException(e.getMessage());
                }
                case 404: {
                    throw new NotFoundException(e);
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public Reader getDownloadReader(String path) throws HiveException {
        try {
            return new InputStreamReader(((ResponseBody)this.filesAPI.download(path).execute().body()).byteStream());
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 403: {
                    throw new VaultForbiddenException((Throwable)e);
                }
                case 400: {
                    throw new InvalidParameterException(e.getMessage());
                }
                case 404: {
                    throw new NotFoundException(e);
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public List<FileInfo> listChildren(String path) throws HiveException {
        try {
            return ((ChildrenInfo)this.filesAPI.listChildren(path).execute().body()).getValue();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 403: {
                    throw new VaultForbiddenException((Throwable)e);
                }
                case 400: {
                    throw new InvalidParameterException(e.getMessage());
                }
                case 404: {
                    throw new NotFoundException(e);
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public FileInfo getProperty(String path) throws HiveException {
        try {
            return (FileInfo)this.filesAPI.getMetadata(path).execute().body();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 403: {
                    throw new VaultForbiddenException((Throwable)e);
                }
                case 400: {
                    throw new InvalidParameterException(e.getMessage());
                }
                case 404: {
                    throw new NotFoundException(e);
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public String getHash(String path) throws HiveException {
        try {
            return ((HashInfo)this.filesAPI.getHash(path).execute().body()).getHash();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 403: {
                    throw new VaultForbiddenException((Throwable)e);
                }
                case 400: {
                    throw new InvalidParameterException(e.getMessage());
                }
                case 404: {
                    throw new NotFoundException(e);
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public void copyFile(String srcPath, String destPath) throws HiveException {
        try {
            this.filesAPI.copy(srcPath, destPath).execute();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 403: {
                    throw new VaultForbiddenException((Throwable)e);
                }
                case 400: {
                    throw new InvalidParameterException(e.getMessage());
                }
                case 404: {
                    throw new NotFoundException(e);
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public void moveFile(String srcPath, String destPath) throws HiveException {
        try {
            this.filesAPI.move(srcPath, destPath).execute();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 403: {
                    throw new VaultForbiddenException((Throwable)e);
                }
                case 400: {
                    throw new InvalidParameterException(e.getMessage());
                }
                case 404: {
                    throw new NotFoundException(e);
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public void delete(String path) throws HiveException {
        try {
            this.filesAPI.delete(path).execute();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 403: {
                    throw new VaultForbiddenException((Throwable)e);
                }
                case 400: {
                    throw new InvalidParameterException(e.getMessage());
                }
                case 404: {
                    throw new NotFoundException(e);
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }
}

