/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.vault;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.elastos.hive.ServiceEndpoint;
import org.elastos.hive.exception.HiveException;
import org.elastos.hive.service.FilesService;
import org.elastos.hive.vault.files.FileInfo;
import org.elastos.hive.vault.files.FilesController;

class FilesServiceRender
implements FilesService {
    private FilesController controller;

    public FilesServiceRender(ServiceEndpoint serviceEndpoint) {
        this.controller = new FilesController(serviceEndpoint);
    }

    @Override
    public CompletableFuture<OutputStream> getUploadStream(String path) {
        return CompletableFuture.supplyAsync(() -> {
            if (path == null) {
                throw new IllegalArgumentException("Empty path parameter");
            }
            try {
                return this.controller.getUploadStream(path);
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public CompletableFuture<Writer> getUploadWriter(String path) {
        return CompletableFuture.supplyAsync(() -> {
            if (path == null) {
                throw new IllegalArgumentException("Empty path parameter");
            }
            try {
                return this.controller.getUploadWriter(path);
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public CompletableFuture<InputStream> getDownloadStream(String path) {
        return CompletableFuture.supplyAsync(() -> {
            if (path == null) {
                throw new IllegalArgumentException("Empty path parameter");
            }
            try {
                return this.controller.getDownloadStream(path);
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public CompletableFuture<Reader> getDownloadReader(String path) {
        return CompletableFuture.supplyAsync(() -> {
            if (path == null) {
                throw new IllegalArgumentException("Empty path parameter");
            }
            try {
                return this.controller.getDownloadReader(path);
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public CompletableFuture<List<FileInfo>> list(String path) {
        return CompletableFuture.supplyAsync(() -> {
            if (path == null) {
                throw new IllegalArgumentException("Empty path parameter");
            }
            try {
                return this.controller.listChildren(path);
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public CompletableFuture<FileInfo> stat(String path) {
        return CompletableFuture.supplyAsync(() -> {
            if (path == null) {
                throw new IllegalArgumentException("Empty path parameter");
            }
            try {
                return this.controller.getProperty(path);
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public CompletableFuture<String> hash(String path) {
        return CompletableFuture.supplyAsync(() -> {
            if (path == null) {
                throw new IllegalArgumentException("Empty path parameter");
            }
            try {
                return this.controller.getHash(path);
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public CompletableFuture<Void> move(String source, String target) {
        return CompletableFuture.runAsync(() -> {
            if (source == null || target == null) {
                throw new IllegalArgumentException("Empty path parameter");
            }
            try {
                this.controller.moveFile(source, target);
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public CompletableFuture<Void> copy(String source, String target) {
        return CompletableFuture.runAsync(() -> {
            if (source == null || target == null) {
                throw new IllegalArgumentException("Empty path parameter");
            }
            try {
                this.controller.copyFile(source, target);
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public CompletableFuture<Void> delete(String path) {
        return CompletableFuture.runAsync(() -> {
            if (path == null) {
                throw new IllegalArgumentException("Empty path parameter");
            }
            try {
                this.controller.delete(path);
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }
}

