/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.vault;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.elastos.hive.ServiceEndpoint;
import org.elastos.hive.exception.HiveException;
import org.elastos.hive.exception.NotImplementedException;
import org.elastos.hive.service.BackupContext;
import org.elastos.hive.service.BackupService;
import org.elastos.hive.vault.backup.BackupController;
import org.elastos.hive.vault.backup.BackupResult;
import org.elastos.hive.vault.backup.credential.CredentialCode;

class BackupServiceRender
implements BackupService {
    private ServiceEndpoint serviceEndpoint;
    private BackupController controller;
    private CredentialCode credentialCode;

    public BackupServiceRender(ServiceEndpoint serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
        this.controller = new BackupController(serviceEndpoint);
    }

    @Override
    public CompletableFuture<Void> setupContext(BackupContext backupContext) {
        this.credentialCode = new CredentialCode(this.serviceEndpoint, backupContext);
        return CompletableFuture.runAsync(() -> {});
    }

    @Override
    public CompletableFuture<Void> startBackup() {
        return CompletableFuture.runAsync(() -> {
            try {
                this.controller.startBackup(this.credentialCode.getToken());
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public CompletableFuture<Void> stopBackup() {
        return CompletableFuture.runAsync(() -> {
            throw new NotImplementedException();
        });
    }

    @Override
    public CompletableFuture<Void> restoreFrom() {
        return CompletableFuture.runAsync(() -> {
            try {
                this.controller.restoreFrom(this.credentialCode.getToken());
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public CompletableFuture<Void> stopRestore() {
        return CompletableFuture.runAsync(() -> {
            throw new NotImplementedException();
        });
    }

    @Override
    public CompletableFuture<BackupResult> checkResult() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.controller.checkResult();
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }
}

