/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.provider;

import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.List;
import org.elastos.hive.connection.NodeRPCConnection;
import org.elastos.hive.connection.NodeRPCException;
import org.elastos.hive.exception.HiveException;
import org.elastos.hive.exception.NetworkException;
import org.elastos.hive.exception.NotFoundException;
import org.elastos.hive.exception.ServerUnknownException;
import org.elastos.hive.exception.UnauthorizedException;
import org.elastos.hive.exception.VaultForbiddenException;
import org.elastos.hive.provider.BackupDetail;
import org.elastos.hive.provider.BackupStats;
import org.elastos.hive.provider.FilledOrderDetail;
import org.elastos.hive.provider.FilledOrderStats;
import org.elastos.hive.provider.RunStatsAPI;
import org.elastos.hive.provider.VaultDetail;
import org.elastos.hive.provider.VaultStats;

public class RunStatsController {
    private RunStatsAPI runStatsAPI;

    public RunStatsController(NodeRPCConnection connection) {
        this.runStatsAPI = connection.createService(RunStatsAPI.class, true);
    }

    public List<VaultDetail> getVaults() throws HiveException {
        try {
            return ((VaultStats)this.runStatsAPI.getVaults().execute().body()).getVaults();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 403: {
                    throw new VaultForbiddenException((Throwable)e);
                }
                case 400: {
                    throw new InvalidParameterException(e.getMessage());
                }
                case 404: {
                    throw new NotFoundException(e);
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public List<BackupDetail> getBackups() throws HiveException {
        try {
            return ((BackupStats)this.runStatsAPI.getBackups().execute().body()).getBackups();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 403: {
                    throw new VaultForbiddenException((Throwable)e);
                }
                case 400: {
                    throw new InvalidParameterException(e.getMessage());
                }
                case 404: {
                    throw new NotFoundException(e);
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public List<FilledOrderDetail> getFilledOrders() throws HiveException {
        try {
            return ((FilledOrderStats)this.runStatsAPI.getFilledOrders().execute().body()).getPayments();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 403: {
                    throw new VaultForbiddenException((Throwable)e);
                }
                case 400: {
                    throw new InvalidParameterException(e.getMessage());
                }
                case 404: {
                    throw new NotFoundException(e);
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }
}

