/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.connection;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.elastos.hive.connection.LoggerInterceptor;
import org.elastos.hive.connection.NodeRPCException;
import org.elastos.hive.connection.auth.AccessToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public abstract class NodeRPCConnection {
    private static final Logger log = LoggerFactory.getLogger(NodeRPCConnection.class);
    private static final int DEFAULT_TIMEOUT = 30;

    protected abstract String getProviderAddress();

    protected abstract AccessToken getAccessToken();

    public HttpURLConnection openConnection(String urlPath) throws IOException {
        String url = this.getProviderAddress() + urlPath;
        log.debug("open connection with URL: {} and method: PUT", (Object)url);
        HttpURLConnection urlConnection = (HttpURLConnection)new URL(url).openConnection();
        urlConnection.setRequestMethod("PUT");
        urlConnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
        urlConnection.setConnectTimeout(5000);
        urlConnection.setReadTimeout(5000);
        urlConnection.setDoOutput(true);
        urlConnection.setDoInput(true);
        urlConnection.setUseCaches(false);
        urlConnection.setRequestProperty("Transfer-Encoding", "chunked");
        urlConnection.setRequestProperty("Connection", "Keep-Alive");
        urlConnection.setRequestProperty("Authorization", this.getAccessToken().getCanonicalizedAccessToken());
        urlConnection.setChunkedStreamingMode(0);
        return urlConnection;
    }

    public <S> S createService(Class<S> serviceClass, boolean requiredAuthorization) {
        Object requestInterceptor = requiredAuthorization ? new PlainRequestInterceptor(this.getAccessToken()) : new AuthRequestInterceptor();
        return (S)this.createRetrofit((Interceptor)requestInterceptor).create(serviceClass);
    }

    private Retrofit createRetrofit(Interceptor requestInterceptor) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS);
        builder.interceptors().clear();
        builder.interceptors().add(requestInterceptor);
        builder.interceptors().add(new LoggerInterceptor());
        return new Retrofit.Builder().baseUrl(this.getProviderAddress()).addConverterFactory((Converter.Factory)this.getGsonConverterFactory()).client(builder.build()).build();
    }

    private GsonConverterFactory getGsonConverterFactory() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(JsonNode.class, (src, typeOfSrc, context) -> {
            if (src == null) {
                return new JsonPrimitive("");
            }
            return new JsonParser().parse(src.toString()).getAsJsonObject();
        });
        builder.registerTypeAdapter(JsonNode.class, (src, typeOfSrc, context) -> {
            if (src == null) {
                return null;
            }
            String json = new Gson().toJson(src);
            try {
                return new ObjectMapper().readTree(json);
            }
            catch (IOException e) {
                log.error("Failed to deserialize to JsonNode.");
                return null;
            }
        });
        return GsonConverterFactory.create((Gson)builder.create());
    }

    private static class PlainRequestInterceptor
    implements Interceptor {
        private AccessToken accessToken;

        PlainRequestInterceptor(AccessToken accessToken) {
            this.accessToken = accessToken;
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request request = chain.request().newBuilder().addHeader("Authorization", this.accessToken.getCanonicalizedAccessToken()).build();
            Response response = chain.proceed(request);
            if (!response.isSuccessful()) {
                int httpCode = response.code();
                if (httpCode == 401) {
                    this.accessToken.invalidate();
                }
                if (response.body() == null) {
                    throw new NodeRPCException(httpCode, -1, "Empty body.");
                }
                JsonNode error = this.getResponseErrorNode(response.body().string());
                if (error == null) {
                    throw new NodeRPCException(httpCode, -1, response.body().string());
                }
                if (httpCode == 401) {
                    this.accessToken.invalidate();
                }
                throw new NodeRPCException(httpCode, error.has("internal_code") ? error.get("internal_code").asInt() : -1, error.get("message").asText());
            }
            return response;
        }

        private JsonNode getResponseErrorNode(String body) {
            try {
                return new ObjectMapper().readTree(body).get("error");
            }
            catch (JsonParseException | IOException e) {
                log.error("No Json response body returned: " + body);
                return null;
            }
        }
    }

    private static class AuthRequestInterceptor
    implements Interceptor {
        private AuthRequestInterceptor() {
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Response response = chain.proceed(chain.request());
            if (!response.isSuccessful()) {
                throw new NodeRPCException(response.code(), -1, response.message());
            }
            return response;
        }
    }
}

