/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.backup.promotion;

import java.io.IOException;
import java.security.InvalidParameterException;
import org.elastos.hive.backup.promotion.PromotionAPI;
import org.elastos.hive.connection.NodeRPCConnection;
import org.elastos.hive.connection.NodeRPCException;
import org.elastos.hive.exception.HiveException;
import org.elastos.hive.exception.InsufficientStorageException;
import org.elastos.hive.exception.NetworkException;
import org.elastos.hive.exception.NotFoundException;
import org.elastos.hive.exception.ServerUnknownException;
import org.elastos.hive.exception.UnauthorizedException;
import org.elastos.hive.exception.VaultAlreadyExistsException;

public class PromotionController {
    private PromotionAPI promotionAPI;

    public PromotionController(NodeRPCConnection connection) {
        this.promotionAPI = connection.createService(PromotionAPI.class, true);
    }

    public void promote() throws HiveException {
        try {
            this.promotionAPI.promoteToVault().execute();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 455: {
                    throw new VaultAlreadyExistsException(e);
                }
                case 404: {
                    throw new NotFoundException(e);
                }
                case 400: {
                    throw new InvalidParameterException(e.getMessage());
                }
                case 507: {
                    throw new InsufficientStorageException((Throwable)e);
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }
}

