/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.elastos.hive.AppContext;
import org.elastos.hive.ServiceEndpoint;
import org.elastos.hive.exception.HiveException;
import org.elastos.hive.provider.BackupDetail;
import org.elastos.hive.provider.FilledOrderDetail;
import org.elastos.hive.provider.RunStatsController;
import org.elastos.hive.provider.VaultDetail;

public class Provider
extends ServiceEndpoint {
    private RunStatsController managementController = new RunStatsController(this);

    public Provider(AppContext context) {
        this(context, null);
    }

    public Provider(AppContext context, String providerAddress) {
        super(context, providerAddress);
    }

    public CompletableFuture<List<VaultDetail>> getVaults() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.managementController.getVaults();
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    public CompletableFuture<List<BackupDetail>> getBackups() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.managementController.getBackups();
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    public CompletableFuture<List<FilledOrderDetail>> getFilledOrders() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.managementController.getFilledOrders();
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }
}

