/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.vault.backup.credential;

import org.elastos.hive.DataStorage;
import org.elastos.hive.ServiceEndpoint;
import org.elastos.hive.connection.NodeRPCException;
import org.elastos.hive.connection.auth.CodeFetcher;

class LocalResolver
implements CodeFetcher {
    private ServiceEndpoint serviceEndpoint;
    private CodeFetcher nextResolver;

    public LocalResolver(ServiceEndpoint serviceEndpoint, CodeFetcher next) {
        this.serviceEndpoint = serviceEndpoint;
        this.nextResolver = next;
    }

    @Override
    public String fetch() throws NodeRPCException {
        String token = this.restoreToken();
        if (token == null) {
            token = this.nextResolver.fetch();
            this.saveToken(token);
        }
        return token;
    }

    @Override
    public void invalidate() {
        this.clearToken();
    }

    private String restoreToken() {
        DataStorage storage = this.serviceEndpoint.getStorage();
        if (this.serviceEndpoint.getServiceInstanceDid() == null) {
            return null;
        }
        return storage.loadBackupCredential(this.serviceEndpoint.getServiceInstanceDid());
    }

    private void saveToken(String token) {
        DataStorage storage = this.serviceEndpoint.getStorage();
        if (this.serviceEndpoint.getServiceInstanceDid() != null) {
            storage.storeBackupCredential(this.serviceEndpoint.getServiceInstanceDid(), token);
        }
    }

    private void clearToken() {
        DataStorage storage = this.serviceEndpoint.getStorage();
        if (this.serviceEndpoint.getServiceInstanceDid() != null) {
            storage.clearBackupCredential(this.serviceEndpoint.getServiceInstanceDid());
        }
    }
}

