/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.connection.auth;

import org.elastos.hive.DataStorage;
import org.elastos.hive.ServiceEndpoint;
import org.elastos.hive.connection.NodeRPCException;
import org.elastos.hive.connection.auth.BridgeHandler;
import org.elastos.hive.connection.auth.CodeFetcher;
import org.elastos.hive.connection.auth.RemoteFetcher;

public class AccessToken
implements CodeFetcher {
    private String jwtCode;
    private CodeFetcher remoteFetcher;
    private DataStorage storage;
    private BridgeHandler bridge;

    public AccessToken(ServiceEndpoint endpoint, DataStorage storage, BridgeHandler bridge) {
        this.remoteFetcher = new RemoteFetcher(endpoint);
        this.storage = storage;
        this.bridge = bridge;
    }

    public String getCanonicalizedAccessToken() {
        try {
            this.jwtCode = this.fetch();
        }
        catch (Exception e) {
            return null;
        }
        return "token " + this.jwtCode;
    }

    @Override
    public String fetch() throws NodeRPCException {
        if (this.jwtCode != null) {
            return this.jwtCode;
        }
        this.jwtCode = this.restoreToken();
        if (this.jwtCode == null) {
            this.jwtCode = this.remoteFetcher.fetch();
            if (this.jwtCode != null) {
                this.bridge.flush(this.jwtCode);
                this.saveToken(this.jwtCode);
            }
        } else {
            this.bridge.flush(this.jwtCode);
        }
        return this.jwtCode;
    }

    @Override
    public void invalidate() {
        this.clearToken();
    }

    private String restoreToken() {
        ServiceEndpoint endpoint = (ServiceEndpoint)this.bridge.target();
        if (endpoint == null) {
            return null;
        }
        String jwtCode = null;
        String serviceDid = endpoint.getServiceInstanceDid();
        String address = endpoint.getProviderAddress();
        if (serviceDid != null) {
            jwtCode = this.storage.loadAccessToken(serviceDid);
        }
        if (jwtCode != null && this.isExpired(jwtCode)) {
            this.storage.clearAccessTokenByAddress(address);
            this.storage.clearAccessToken(serviceDid);
        }
        if (jwtCode == null) {
            jwtCode = this.storage.loadAccessTokenByAddress(address);
        }
        if (jwtCode != null && this.isExpired(jwtCode)) {
            this.storage.clearAccessTokenByAddress(address);
            this.storage.clearAccessToken(serviceDid);
        }
        return jwtCode;
    }

    private boolean isExpired(String jwtCode) {
        return false;
    }

    private void saveToken(String jwtCode) {
        ServiceEndpoint endpoint = (ServiceEndpoint)this.bridge.target();
        if (endpoint == null) {
            return;
        }
        this.storage.storeAccessToken(endpoint.getServiceInstanceDid(), jwtCode);
        this.storage.storeAccessTokenByAddress(endpoint.getProviderAddress(), jwtCode);
    }

    private void clearToken() {
        ServiceEndpoint endpoint = (ServiceEndpoint)this.bridge.target();
        if (endpoint == null) {
            return;
        }
        this.storage.clearAccessToken(endpoint.getServiceInstanceDid());
        this.storage.clearAccessTokenByAddress(endpoint.getProviderAddress());
    }
}

