/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.connection;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LoggerInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(LoggerInterceptor.class);
    private static final int MAX_BODY_LEN = 500;

    LoggerInterceptor() {
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        return this.dumpResponse(chain.proceed(this.dumpRequest(chain.request())));
    }

    private Request dumpRequest(Request request) throws IOException {
        RequestBody body = request.body();
        String bodyInString = null;
        log.debug("Request -> [{}] {}", (Object)request.method(), (Object)request.url().toString());
        if (body != null) {
            Buffer buffer = new Buffer();
            body.writeTo((BufferedSink)buffer);
            Charset charset = Charset.defaultCharset();
            MediaType type = body.contentType();
            if (type != null) {
                try {
                    charset = type.charset(charset);
                }
                catch (UnsupportedCharsetException e) {
                    e.printStackTrace();
                }
            }
            if (charset != null) {
                bodyInString = buffer.readString(charset);
            }
        }
        if (bodyInString != null && !bodyInString.equals("")) {
            log.debug("Request Body: {}", (Object)this.getOutputBodyContent(bodyInString));
        } else {
            log.debug("Request Body: N/A");
        }
        return request;
    }

    private Response dumpResponse(Response response) throws IOException {
        ResponseBody body = response.body();
        String bodyInString = null;
        if (body != null) {
            BufferedSource source = body.source();
            source.request(Long.MAX_VALUE);
            Buffer buffer = source.buffer();
            Charset charset = Charset.defaultCharset();
            MediaType type = body.contentType();
            if (type != null) {
                try {
                    charset = type.charset(charset);
                }
                catch (UnsupportedCharsetException e) {
                    e.printStackTrace();
                }
            }
            if (charset != null) {
                bodyInString = buffer.clone().readString(charset);
            }
        }
        log.info("Response Code: {}", (Object)response.code());
        if (bodyInString != null && !bodyInString.equals("")) {
            log.debug("Response Body: {}", (Object)this.getOutputBodyContent(bodyInString));
        } else {
            log.debug("Response Body: N/A");
        }
        return response;
    }

    private String getOutputBodyContent(String body) {
        return body.length() > 500 ? body.substring(0, 500) : body;
    }
}

